/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.SplitCompressionInputStream;
import org.apache.hadoop.mapreduce.lib.input.SplitLineReader;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class CompressedSplitLineReader
extends SplitLineReader {
    SplitCompressionInputStream scin;
    private boolean usingCRLF;
    private boolean needAdditionalRecord = false;
    private boolean finished = false;

    public CompressedSplitLineReader(SplitCompressionInputStream in, Configuration conf, byte[] recordDelimiterBytes) throws IOException {
        super((InputStream)in, conf, recordDelimiterBytes);
        this.scin = in;
        this.usingCRLF = recordDelimiterBytes == null;
    }

    @Override
    protected int fillBuffer(InputStream in, byte[] buffer, boolean inDelimiter) throws IOException {
        int bytesRead = in.read(buffer);
        if (inDelimiter && bytesRead > 0) {
            this.needAdditionalRecord = this.usingCRLF ? buffer[0] != 10 : true;
        }
        return bytesRead;
    }

    @Override
    public int readLine(Text str, int maxLineLength, int maxBytesToConsume) throws IOException {
        int bytesRead = 0;
        if (!this.finished) {
            if (this.scin.getPos() > this.scin.getAdjustedEnd()) {
                this.finished = true;
            }
            bytesRead = super.readLine(str, maxLineLength, maxBytesToConsume);
        }
        return bytesRead;
    }

    @Override
    public boolean needAdditionalRecordAfterSplit() {
        return !this.finished && this.needAdditionalRecord;
    }

    @Override
    protected void unsetNeedAdditionalRecordAfterSplit() {
        this.needAdditionalRecord = false;
    }
}

