/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.Trace;
import com.ibm.as400.resource.Presentation;
import com.ibm.as400.resource.ResourceException;
import com.ibm.as400.resource.ResourceList;
import com.ibm.as400.resource.ResourceMetaData;
import com.ibm.as400.vaccess.ChangeEventSupport;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ResourceLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;

class ResourceListPropertiesTabbedPane
extends JComponent {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String DLG_ADD_ = ResourceLoader.getText("DLG_ADD");
    private static final String DLG_REMOVE_ = ResourceLoader.getText("DLG_REMOVE");
    private static final String RESOURCE_ALL_SORTS_ = ResourceLoader.getText("RESOURCE_ALL_SORTS");
    private static final String RESOURCE_CURRENT_SORTS_ = ResourceLoader.getText("RESOURCE_CURRENT_SORTS");
    private static final String RESOURCE_SELECTION_TAB_ = ResourceLoader.getText("RESOURCE_SELECTION_TAB");
    private static final String RESOURCE_SORT_TAB_ = ResourceLoader.getText("RESOURCE_SORT_TAB");
    private Hashtable changes_ = new Hashtable();
    private DefaultListModel currentSortsModel_;
    private Presentation presentation_;
    private ResourceList resourceList_;
    private ErrorEventSupport errorEventSupport_ = new ErrorEventSupport(this);
    private ChangeEventSupport changeEventSupport_ = new ChangeEventSupport(this);
    static /* synthetic */ Class class$java$lang$Boolean;

    public ResourceListPropertiesTabbedPane(ResourceList resourceList) {
        this.resourceList_ = resourceList;
        this.presentation_ = resourceList.getPresentation();
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(RESOURCE_SELECTION_TAB_, this.createSelectionComponent());
        if (resourceList.getSortMetaData().length > 0) {
            jTabbedPane.addTab(RESOURCE_SORT_TAB_, this.createSortComponent());
        }
        this.setLayout(new BorderLayout());
        this.add("Center", jTabbedPane);
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (changeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.changeEventSupport_.addChangeListener(changeListener);
    }

    public void addErrorListener(ErrorListener errorListener) {
        if (errorListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void applyChanges() {
        this.applyChanges(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyChanges(boolean bl) {
        Hashtable hashtable = this.changes_;
        synchronized (hashtable) {
            try {
                Enumeration enumeration = this.changes_.keys();
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    Object v = this.changes_.get(k);
                    this.resourceList_.setSelectionValue(k, v);
                }
                this.changes_.clear();
                if (this.currentSortsModel_ != null) {
                    this.resourceList_.setSortValue(this.currentSortsModel_.toArray());
                }
                if (bl) {
                    this.resourceList_.refreshContents();
                }
            }
            catch (Exception exception) {
                if (Trace.isTraceOn()) {
                    Trace.log(2, "Error applying changes", (Throwable)exception);
                }
                this.errorEventSupport_.fireError(exception);
            }
        }
    }

    private Component createSelectionComponent(ResourceMetaData resourceMetaData) throws ResourceException {
        JComponent jComponent;
        Object object = resourceMetaData.getID();
        Object object2 = this.resourceList_.getSelectionValue(object);
        boolean bl = !resourceMetaData.isReadOnly();
        JComponent jComponent2 = null;
        Class clazz = resourceMetaData.getType();
        Object[] objectArray = resourceMetaData.getPossibleValues();
        if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = ResourceListPropertiesTabbedPane.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            jComponent = new JCheckBox("", (boolean)((Boolean)object2));
            ((AbstractButton)jComponent).setEnabled(bl);
            ((AbstractButton)jComponent).addActionListener(new ChangeListener_(object));
            jComponent2 = jComponent;
        } else if (objectArray != null && objectArray.length > 0) {
            if (bl) {
                jComponent = new JComboBox();
                if (object2.getClass().isArray()) {
                    object2 = ((Object[])object2)[0];
                }
                boolean bl2 = false;
                for (int i = 0; i < objectArray.length; ++i) {
                    ((JComboBox)jComponent).addItem(objectArray[i]);
                    if (objectArray[i] != object2) continue;
                    bl2 = true;
                }
                if (!bl2) {
                    ((JComboBox)jComponent).addItem(object2);
                }
                ((JComboBox)jComponent).setRenderer(new JComboBoxRenderer(resourceMetaData));
                ((JComboBox)jComponent).setEditor(new JComboBoxEditor(resourceMetaData));
                ((JComboBox)jComponent).setEditable(!resourceMetaData.isValueLimited());
                ChangeListener_ changeListener_ = new ChangeListener_(object, ((JComboBox)jComponent).getEditor());
                ((JComboBox)jComponent).addItemListener(changeListener_);
                ((JComboBox)jComponent).getEditor().getEditorComponent().addKeyListener(changeListener_);
                ((JComboBox)jComponent).setSelectedItem(object2);
                jComponent2 = jComponent;
            } else {
                jComponent2 = new JLabel(resourceMetaData.getPossibleValuePresentation(object2).getFullName());
            }
        }
        if (jComponent2 == null) {
            if (bl) {
                jComponent = new JTextField(object2.toString());
                jComponent.addKeyListener(new ChangeListener_(object));
                jComponent2 = jComponent;
            } else {
                jComponent2 = new JLabel(object2.toString());
            }
        }
        return jComponent2;
    }

    private Component createSelectionBox() {
        Box box = new Box(1);
        Box box2 = new Box(1);
        Box box3 = new Box(0);
        box3.add(box);
        box3.add(Box.createRigidArea(new Dimension(10, 0)));
        box3.add(box2);
        box3.add(Box.createHorizontalGlue());
        ResourceMetaData[] resourceMetaDataArray = this.resourceList_.getSelectionMetaData();
        for (int i = 0; i < resourceMetaDataArray.length; ++i) {
            Presentation presentation = resourceMetaDataArray[i].getPresentation();
            String string = null;
            string = presentation != null ? presentation.getFullName() : resourceMetaDataArray[i].getID().toString();
            JLabel jLabel = new JLabel(string + ':');
            box.add(jLabel);
            int n = ((Component)jLabel).getPreferredSize().height;
            int n2 = 0;
            try {
                Component component = this.createSelectionComponent(resourceMetaDataArray[i]);
                box2.add(component);
                n2 = component.getPreferredSize().height;
            }
            catch (ResourceException resourceException) {
                if (Trace.isTraceOn()) {
                    Trace.log(2, "Error creating property component for:" + resourceMetaDataArray[i].getID(), (Throwable)resourceException);
                }
                this.errorEventSupport_.fireError(resourceException);
            }
            int n3 = n - n2;
            if (n3 > 0) {
                box2.add(Box.createRigidArea(new Dimension(0, n3)));
            } else if (n3 < 0) {
                box.add(Box.createRigidArea(new Dimension(0, -n3)));
            }
            box.add(Box.createRigidArea(new Dimension(0, 3)));
            box2.add(Box.createRigidArea(new Dimension(0, 3)));
        }
        box.add(Box.createVerticalGlue());
        box2.add(Box.createVerticalGlue());
        return box3;
    }

    private Component createSelectionComponent() {
        Box box = new Box(1);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add("Center", box);
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        JLabel jLabel = new JLabel(this.presentation_.getFullName(), new ImageIcon((Image)this.presentation_.getValue("32")), 2);
        Box box2 = new Box(0);
        box2.add(jLabel);
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        JSeparator jSeparator = new JSeparator();
        jSeparator.setMaximumSize(new Dimension(jSeparator.getMaximumSize().width, jSeparator.getPreferredSize().height));
        box.add(Box.createRigidArea(new Dimension(0, 6)));
        box.add(jSeparator);
        box.add(Box.createRigidArea(new Dimension(0, 6)));
        box.add(this.createSelectionBox());
        box.add(Box.createVerticalGlue());
        return jPanel;
    }

    private Component createSortComponent() {
        Box box = new Box(0);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add("Center", box);
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add("North", new JLabel(RESOURCE_ALL_SORTS_, 2));
        DefaultListModel<Object> defaultListModel = new DefaultListModel<Object>();
        ResourceMetaData[] resourceMetaDataArray = this.resourceList_.getSortMetaData();
        for (int i = 0; i < resourceMetaDataArray.length; ++i) {
            defaultListModel.addElement(resourceMetaDataArray[i].getID());
        }
        JList<Object> jList = new JList<Object>(defaultListModel);
        jList.setBorder(new EtchedBorder());
        jList.setAlignmentX(0.0f);
        ListCellRenderer_ listCellRenderer_ = new ListCellRenderer_();
        jList.setCellRenderer(listCellRenderer_);
        jPanel2.add("Center", jList);
        box.add(jPanel2);
        box.add(Box.createRigidArea(new Dimension(6, 0)));
        Box box2 = new Box(1);
        box2.add(Box.createVerticalGlue());
        JButton jButton = new JButton(DLG_ADD_);
        jButton.setAlignmentX(0.5f);
        jButton.setEnabled(false);
        box2.add(jButton);
        box2.add(Box.createRigidArea(new Dimension(0, 6)));
        JButton jButton2 = new JButton(DLG_REMOVE_);
        jButton2.setAlignmentX(0.5f);
        jButton2.setEnabled(false);
        box2.add(jButton2);
        box2.add(Box.createVerticalGlue());
        box.add(box2);
        box.add(Box.createRigidArea(new Dimension(6, 0)));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add("North", new JLabel(RESOURCE_CURRENT_SORTS_, 2));
        this.currentSortsModel_ = new DefaultListModel();
        JList<Object> jList2 = new JList<Object>(this.currentSortsModel_);
        jList2.setBorder(new EtchedBorder());
        jList2.setAlignmentX(0.0f);
        jList2.setCellRenderer(listCellRenderer_);
        jPanel3.add("Center", jList2);
        box.add(jPanel3);
        jList.addListSelectionListener(new ListSelectionListener_(jButton));
        jList2.addListSelectionListener(new ListSelectionListener_(jButton2));
        jButton.addActionListener(new SortMover_(jList, defaultListModel, this.currentSortsModel_));
        jButton2.addActionListener(new SortMover_(jList2, this.currentSortsModel_, defaultListModel));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResourceListPropertiesTabbedPane.this.changeEventSupport_.fireStateChanged();
            }
        };
        jButton.addActionListener(actionListener);
        jButton2.addActionListener(actionListener);
        return jPanel;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SortMover_
    implements ActionListener {
        private JList fromList_;
        private DefaultListModel fromModel_;
        private DefaultListModel toModel_;

        public SortMover_(JList jList, DefaultListModel defaultListModel, DefaultListModel defaultListModel2) {
            this.fromList_ = jList;
            this.fromModel_ = defaultListModel;
            this.toModel_ = defaultListModel2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = this.fromList_.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                this.fromModel_.removeElement(objectArray[i]);
                this.toModel_.addElement(objectArray[i]);
            }
            ((JButton)actionEvent.getSource()).setEnabled(false);
        }
    }

    private class ListSelectionListener_
    implements ListSelectionListener {
        private JButton button_;

        public ListSelectionListener_(JButton jButton) {
            this.button_ = jButton;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.button_.setEnabled(((JList)listSelectionEvent.getSource()).getMinSelectionIndex() >= 0);
        }
    }

    private class ListCellRenderer_
    extends DefaultListCellRenderer {
        private ListCellRenderer_() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object object2 = object;
            ResourceMetaData resourceMetaData = ResourceListPropertiesTabbedPane.this.resourceList_.getSortMetaData(object);
            if (resourceMetaData != null) {
                object2 = resourceMetaData.getPresentation().getFullName();
            }
            return super.getListCellRendererComponent((JList<?>)jList, object2, n, bl, bl2);
        }
    }

    private class JComboBoxEditor
    extends BasicComboBoxEditor {
        private ResourceMetaData metaData_;
        private Object actualValue_ = null;
        private String fullName_ = null;

        public JComboBoxEditor(ResourceMetaData resourceMetaData) {
            this.metaData_ = resourceMetaData;
        }

        public Object getItem() {
            Object object = super.getItem();
            if (this.fullName_ != null && object.equals(this.fullName_)) {
                return this.actualValue_;
            }
            return object;
        }

        public void setItem(Object object) {
            if (object != null) {
                try {
                    Presentation presentation = this.metaData_.getPossibleValuePresentation(object);
                    this.fullName_ = presentation != null ? presentation.getFullName() : object.toString();
                    this.actualValue_ = object;
                }
                catch (Exception exception) {
                    this.fullName_ = null;
                    this.actualValue_ = null;
                }
            }
            super.setItem(this.fullName_);
        }
    }

    private class JComboBoxRenderer
    extends DefaultListCellRenderer {
        private ResourceMetaData metaData_;

        public JComboBoxRenderer(ResourceMetaData resourceMetaData) {
            this.metaData_ = resourceMetaData;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Presentation presentation;
            Object object2 = object;
            if (object != null && (presentation = this.metaData_.getPossibleValuePresentation(object)) != null) {
                object2 = presentation.getFullName();
            }
            return super.getListCellRendererComponent((JList<?>)jList, object2, n, bl, bl2);
        }
    }

    private class ChangeListener_
    extends KeyAdapter
    implements ActionListener,
    ItemListener {
        private Object selectionID_;
        private ComboBoxEditor editor_;

        public ChangeListener_(Object object) {
            this.selectionID_ = object;
        }

        public ChangeListener_(Object object, ComboBoxEditor comboBoxEditor) {
            this.selectionID_ = object;
            this.editor_ = comboBoxEditor;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.registerChange(new Boolean(((JCheckBox)actionEvent.getSource()).isSelected()));
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            this.registerChange(itemEvent.getItem());
        }

        public void keyTyped(KeyEvent keyEvent) {
            this.registerChange(this.editor_.getItem());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerChange(Object object) {
            Hashtable hashtable = ResourceListPropertiesTabbedPane.this.changes_;
            synchronized (hashtable) {
                ResourceListPropertiesTabbedPane.this.changes_.put(this.selectionID_, object);
            }
            ResourceListPropertiesTabbedPane.this.changeEventSupport_.fireStateChanged();
        }
    }
}

