/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.resource;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.PcmlException;
import com.ibm.as400.data.ProgramCallDocument;
import com.ibm.as400.resource.ProgramKeys;
import com.ibm.as400.resource.ResourceException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

class ProgramKeyAttributeSetter
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private static final String numberOfKeysDataName_ = "numberOfKeys";
    private static final String contentsDataName_ = "contents";
    private ProgramKeys attributeKeys_;
    private CharConverter charConverter_;
    private ProgramCallDocument document_;
    private String keysDataName_;
    private String programName_;
    private AS400 system_;

    public ProgramKeyAttributeSetter(AS400 aS400, ProgramCallDocument programCallDocument, String string, String string2, ProgramKeys programKeys) {
        block7: {
            this.attributeKeys_ = null;
            this.charConverter_ = null;
            this.document_ = null;
            this.keysDataName_ = null;
            this.programName_ = null;
            this.system_ = null;
            if (aS400 == null) {
                throw new NullPointerException("system");
            }
            if (programCallDocument == null) {
                throw new NullPointerException("document");
            }
            if (string == null) {
                throw new NullPointerException("programName");
            }
            if (string2 == null) {
                throw new NullPointerException("keysDataName");
            }
            if (programKeys == null) {
                throw new NullPointerException("attributeKeys");
            }
            this.document_ = programCallDocument;
            this.keysDataName_ = string2;
            this.programName_ = string;
            this.attributeKeys_ = programKeys;
            this.system_ = aS400;
            try {
                this.charConverter_ = new CharConverter(aS400.getCcsid(), aS400);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (!Trace.isTraceOn()) break block7;
                Trace.log(2, "Error setting system on program attribute setter", (Throwable)unsupportedEncodingException);
            }
        }
    }

    private static String pad(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = string.length(); i < n; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(Object[] objectArray, Object[] objectArray2, int[] nArray) throws ResourceException {
        if (objectArray == null) {
            throw new NullPointerException("attributeIDs");
        }
        if (objectArray2 == null) {
            throw new NullPointerException("values");
        }
        if (objectArray.length != objectArray2.length) {
            throw new ExtendedIllegalArgumentException("values", 2);
        }
        if (this.charConverter_ == null) {
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (objectArray.length == 0) {
            return;
        }
        try {
            ProgramKeyAttributeSetter programKeyAttributeSetter = this;
            synchronized (programKeyAttributeSetter) {
                Integer n;
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Hashtable<Integer, Object> hashtable = new Hashtable<Integer, Object>();
                Hashtable<Integer, Integer> hashtable2 = new Hashtable<Integer, Integer>();
                for (int i = 0; i < objectArray.length; ++i) {
                    object4 = this.attributeKeys_.getKeys(objectArray[i]);
                    object3 = this.attributeKeys_.getTypes(objectArray[i]);
                    int[] nArray2 = this.attributeKeys_.getLengths(objectArray[i]);
                    object2 = this.attributeKeys_.getValueMaps(objectArray[i]);
                    block10: for (int j = 0; j < ((int[])object4).length; ++j) {
                        object = objectArray2[i];
                        if (object2 != null && object2[j] != null) {
                            object = object2[j].ltop(objectArray2[i], this.system_);
                        }
                        switch (object3[j]) {
                            case 0: {
                                hashtable.put(new Integer(object4[j]), object);
                                continue block10;
                            }
                            case 1: {
                                n = new Integer(object4[j]);
                                hashtable.put(n, ProgramKeyAttributeSetter.pad((String)object, nArray2[j]));
                                hashtable2.put(n, new Integer(nArray[i]));
                                continue block10;
                            }
                            default: {
                                if (!Trace.isTraceOn()) continue block10;
                                Trace.log(2, "Error setting attribute " + objectArray[i] + ", type = " + (int)object3[i]);
                            }
                        }
                    }
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.programName_);
                stringBuffer.append('.');
                stringBuffer.append(this.keysDataName_);
                stringBuffer.append('.');
                this.document_.setIntValue(stringBuffer.toString() + numberOfKeysDataName_, hashtable.size());
                object4 = stringBuffer.toString() + contentsDataName_;
                object3 = hashtable.keys();
                int n2 = 0;
                while (object3.hasMoreElements()) {
                    object2 = (Integer)object3.nextElement();
                    int[] nArray3 = new int[]{n2};
                    object = hashtable.get(object2);
                    n = (Integer)hashtable2.get(object2);
                    this.document_.setIntValue((String)object4 + ".key", nArray3, (Integer)object2);
                    if (object instanceof Integer) {
                        this.document_.setIntValue((String)object4 + ".lengthOfAttributeInformation", nArray3, 20);
                        this.document_.setValue((String)object4 + ".type", nArray3, "B");
                        this.document_.setIntValue((String)object4 + ".length", nArray3, 4);
                        this.document_.setValue((String)object4 + ".data", nArray3, BinaryConverter.intToByteArray((Integer)object));
                    } else if (object instanceof String) {
                        int n3 = ((String)object).length();
                        this.document_.setIntValue((String)object4 + ".lengthOfAttributeInformation", nArray3, n3 + 16);
                        this.document_.setValue((String)object4 + ".type", nArray3, "C");
                        this.document_.setIntValue((String)object4 + ".length", nArray3, n3);
                        this.document_.setValue((String)object4 + ".data", nArray3, this.charConverter_.stringToByteArray((String)object, n));
                    } else if (Trace.isTraceOn()) {
                        Trace.log(2, "Error setting attribute with key " + object2 + ", value class = " + object.getClass());
                    }
                    ++n2;
                }
            }
            boolean bl = this.document_.callProgram(this.programName_);
            if (!bl) {
                throw new ResourceException(this.document_.getMessageList(this.programName_));
            }
        }
        catch (PcmlException pcmlException) {
            throw new ResourceException(pcmlException);
        }
    }
}

