/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.DBNativeDatabaseRequestDS;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.DBReturnObjectInformationRequestDS;
import com.ibm.as400.access.DBSQLAttributesDS;
import com.ibm.as400.access.DBSQLDescriptorDS;
import com.ibm.as400.access.DBSQLRPBDS;
import com.ibm.as400.access.DBSQLRequestDS;
import com.ibm.as400.access.DBSQLResultSetDS;
import com.ibm.as400.access.DBStoragePool;
import com.ibm.as400.access.DBXARequestDS;
import com.ibm.as400.access.SystemProperties;
import java.lang.ref.SoftReference;

final class DBDSPool {
    static final String copyright = "Copyright (C) 1997-2010 International Business Machines Corporation and others.";
    private static DBSQLRPBDS[] dbsqlrpbdsPool_;
    private static final Object dbsqlrpbdsPoolLock_;
    private static DBSQLDescriptorDS[] dbsqldescriptordsPool_;
    private static final Object dbsqldescriptordsPoolLock_;
    private static DBSQLResultSetDS[] dbsqlresultsetdsPool_;
    private static final Object dbsqlresultsetdsPoolLock_;
    private static DBSQLRequestDS[] dbsqlrequestdsPool_;
    private static final Object dbsqlrequestdsPoolLock_;
    private static int dbsqlrequestdsPoolHighMark_;
    private static int dbsqlrequestdsPoolAllocations_;
    private static int dbsqlrequestdsPoolReclaimThreshold;
    private static DBNativeDatabaseRequestDS[] dbnativedatabaserequestdsPool_;
    private static final Object dbnativedatabaserequestdsPoolLock_;
    private static DBReturnObjectInformationRequestDS[] dbreturnobjectinformationrequestdsPool_;
    private static final Object dbreturnobjectinformationrequestdsPoolLock_;
    private static DBSQLAttributesDS[] dbsqlattributesdsPool_;
    private static final Object dbsqlattributesdsPoolLock_;
    private static DBXARequestDS[] dbxarequestdsPool_;
    private static final Object dbxarequestdsPoolLock_;
    static SoftReference[] dbreplyrequesteddsPool_;
    private static final Object dbreplyrequesteddsPoolLock_;
    private static int dbReplyRequestedPoolSearchStart_;
    private static final int DB_REPLY_REQUEST_POOL_SEARCH_RESET = 4096;
    private static final int DB_REPLY_REQUEST_LOCALITY = 256;
    private static int dbReplyRequestedPoolSearchCount_;
    private static boolean dbReplyRequestedPoolFull_;
    static final DBStoragePool storagePool_;
    static String changeTime;
    static boolean noDBReplyPooling;
    static boolean monitor;

    private DBDSPool() {
    }

    static void returnToDBReplyRequestedPool(int n) {
        if (n >= 0) {
            if (dbReplyRequestedPoolFull_) {
                dbReplyRequestedPoolFull_ = false;
                dbReplyRequestedPoolSearchStart_ = n;
            } else if (n < dbReplyRequestedPoolSearchStart_ && n >= dbReplyRequestedPoolSearchStart_ - 256) {
                dbReplyRequestedPoolSearchStart_ = n;
            }
        }
    }

    public static int getDBReplyRequestedDSPoolSize() {
        return dbreplyrequesteddsPool_.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final DBReplyRequestedDS getDBReplyRequestedDS() {
        if (noDBReplyPooling) {
            DBReplyRequestedDS dBReplyRequestedDS = new DBReplyRequestedDS(monitor, -1);
            dBReplyRequestedDS.canUse();
            dBReplyRequestedDS.setInPool(false);
            return dBReplyRequestedDS;
        }
        Object object = dbreplyrequesteddsPoolLock_;
        synchronized (object) {
            DBReplyRequestedDS dBReplyRequestedDS;
            int n;
            SoftReference[] softReferenceArray = dbreplyrequesteddsPool_;
            int n2 = softReferenceArray.length;
            int n3 = dbReplyRequestedPoolSearchStart_;
            if (dbReplyRequestedPoolFull_) {
                n3 = softReferenceArray.length;
            }
            if (dbReplyRequestedPoolSearchCount_ > 4096) {
                dbReplyRequestedPoolFull_ = false;
                n3 = 0;
                dbReplyRequestedPoolSearchCount_ = 0;
            }
            ++dbReplyRequestedPoolSearchCount_;
            for (n = n3; n < softReferenceArray.length; ++n) {
                if (softReferenceArray[n] == null) {
                    dBReplyRequestedDS = new DBReplyRequestedDS(monitor, n);
                    dBReplyRequestedDS.canUse();
                    dBReplyRequestedDS.setInPool(true);
                    softReferenceArray[n] = new SoftReference<DBReplyRequestedDS>(dBReplyRequestedDS);
                    dbReplyRequestedPoolSearchStart_ = n + 1;
                    return dBReplyRequestedDS;
                }
                dBReplyRequestedDS = (DBReplyRequestedDS)softReferenceArray[n].get();
                if (dBReplyRequestedDS == null || dBReplyRequestedDS.storage_ == null) {
                    dBReplyRequestedDS = new DBReplyRequestedDS(monitor, n);
                    dBReplyRequestedDS.canUse();
                    dBReplyRequestedDS.setInPool(true);
                    softReferenceArray[n] = new SoftReference<DBReplyRequestedDS>(dBReplyRequestedDS);
                    dbReplyRequestedPoolSearchStart_ = n + 1;
                    return dBReplyRequestedDS;
                }
                if (dBReplyRequestedDS.inUse_ || !dBReplyRequestedDS.canUse() || dBReplyRequestedDS.storage_ == null) continue;
                dBReplyRequestedDS.initialize();
                dbReplyRequestedPoolSearchStart_ = n + 1;
                return dBReplyRequestedDS;
            }
            if (n2 * 2 < 16385) {
                if (monitor) {
                    System.out.println("Expanding DBDSPool to size " + n2 * 2);
                    for (n = 0; n < n2; ++n) {
                        dBReplyRequestedDS = (DBReplyRequestedDS)softReferenceArray[n].get();
                        if (dBReplyRequestedDS == null) {
                            System.out.println("Entry " + n + " : null");
                            continue;
                        }
                        System.out.println("Entry " + n + " : " + dBReplyRequestedDS.getAllocatedLocation());
                    }
                }
                SoftReference[] softReferenceArray2 = new SoftReference[n2 * 2];
                System.arraycopy(softReferenceArray, 0, softReferenceArray2, 0, n2);
                dBReplyRequestedDS = new DBReplyRequestedDS(monitor, n2);
                dBReplyRequestedDS.canUse();
                dBReplyRequestedDS.setInPool(true);
                softReferenceArray2[n2] = new SoftReference<DBReplyRequestedDS>(dBReplyRequestedDS);
                dbreplyrequesteddsPool_ = softReferenceArray2;
                dbReplyRequestedPoolSearchStart_ = 0;
                return dBReplyRequestedDS;
            }
            DBReplyRequestedDS dBReplyRequestedDS2 = new DBReplyRequestedDS(monitor, -1);
            dBReplyRequestedDS2.canUse();
            dBReplyRequestedDS2.setInPool(false);
            if (!dbReplyRequestedPoolFull_) {
                dbReplyRequestedPoolFull_ = true;
            }
            return dBReplyRequestedDS2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final DBXARequestDS getDBXARequestDS(int n, int n2, int n3, int n4) {
        Object object = dbxarequestdsPoolLock_;
        synchronized (object) {
            DBXARequestDS[] dBXARequestDSArray = dbxarequestdsPool_;
            int n5 = dBXARequestDSArray.length;
            for (int i = 0; i < dBXARequestDSArray.length; ++i) {
                if (dBXARequestDSArray[i] == null) {
                    DBXARequestDS dBXARequestDS = new DBXARequestDS(n, n2, n3, n4);
                    dBXARequestDS.canUse();
                    dBXARequestDSArray[i] = dBXARequestDS;
                    return dBXARequestDS;
                }
                if (dBXARequestDSArray[i].inUse_ || !dBXARequestDSArray[i].canUse()) continue;
                dBXARequestDSArray[i].initialize(n, n2, n3, n4);
                return dBXARequestDSArray[i];
            }
            DBXARequestDS[] dBXARequestDSArray2 = new DBXARequestDS[n5 * 2];
            System.arraycopy(dBXARequestDSArray, 0, dBXARequestDSArray2, 0, n5);
            DBXARequestDS dBXARequestDS = new DBXARequestDS(n, n2, n3, n4);
            dBXARequestDS.canUse();
            dBXARequestDSArray2[n5] = dBXARequestDS;
            dbxarequestdsPool_ = dBXARequestDSArray2;
            return dBXARequestDS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final DBSQLAttributesDS getDBSQLAttributesDS(int n, int n2, int n3, int n4) {
        Object object = dbsqlattributesdsPoolLock_;
        synchronized (object) {
            DBSQLAttributesDS[] dBSQLAttributesDSArray = dbsqlattributesdsPool_;
            int n5 = dBSQLAttributesDSArray.length;
            for (int i = 0; i < dBSQLAttributesDSArray.length; ++i) {
                if (dBSQLAttributesDSArray[i] == null) {
                    DBSQLAttributesDS dBSQLAttributesDS = new DBSQLAttributesDS(n, n2, n3, n4);
                    dBSQLAttributesDS.canUse();
                    dBSQLAttributesDSArray[i] = dBSQLAttributesDS;
                    return dBSQLAttributesDS;
                }
                if (dBSQLAttributesDSArray[i].inUse_ || !dBSQLAttributesDSArray[i].canUse()) continue;
                dBSQLAttributesDSArray[i].initialize(n, n2, n3, n4);
                return dBSQLAttributesDSArray[i];
            }
            DBSQLAttributesDS[] dBSQLAttributesDSArray2 = new DBSQLAttributesDS[n5 * 2];
            System.arraycopy(dBSQLAttributesDSArray, 0, dBSQLAttributesDSArray2, 0, n5);
            DBSQLAttributesDS dBSQLAttributesDS = new DBSQLAttributesDS(n, n2, n3, n4);
            dBSQLAttributesDS.canUse();
            dBSQLAttributesDSArray2[n5] = dBSQLAttributesDS;
            dbsqlattributesdsPool_ = dBSQLAttributesDSArray2;
            return dBSQLAttributesDS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final DBNativeDatabaseRequestDS getDBNativeDatabaseRequestDS(int n, int n2, int n3, int n4) {
        Object object = dbnativedatabaserequestdsPoolLock_;
        synchronized (object) {
            DBNativeDatabaseRequestDS[] dBNativeDatabaseRequestDSArray = dbnativedatabaserequestdsPool_;
            int n5 = dBNativeDatabaseRequestDSArray.length;
            for (int i = 0; i < dBNativeDatabaseRequestDSArray.length; ++i) {
                if (dBNativeDatabaseRequestDSArray[i] == null) {
                    DBNativeDatabaseRequestDS dBNativeDatabaseRequestDS = new DBNativeDatabaseRequestDS(n, n2, n3, n4);
                    dBNativeDatabaseRequestDS.canUse();
                    dBNativeDatabaseRequestDSArray[i] = dBNativeDatabaseRequestDS;
                    return dBNativeDatabaseRequestDS;
                }
                if (dBNativeDatabaseRequestDSArray[i].inUse_ || !dBNativeDatabaseRequestDSArray[i].canUse()) continue;
                dBNativeDatabaseRequestDSArray[i].initialize(n, n2, n3, n4);
                return dBNativeDatabaseRequestDSArray[i];
            }
            DBNativeDatabaseRequestDS[] dBNativeDatabaseRequestDSArray2 = new DBNativeDatabaseRequestDS[n5 * 2];
            System.arraycopy(dBNativeDatabaseRequestDSArray, 0, dBNativeDatabaseRequestDSArray2, 0, n5);
            DBNativeDatabaseRequestDS dBNativeDatabaseRequestDS = new DBNativeDatabaseRequestDS(n, n2, n3, n4);
            dBNativeDatabaseRequestDS.canUse();
            dBNativeDatabaseRequestDSArray2[n5] = dBNativeDatabaseRequestDS;
            dbnativedatabaserequestdsPool_ = dBNativeDatabaseRequestDSArray2;
            return dBNativeDatabaseRequestDS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final DBReturnObjectInformationRequestDS getDBReturnObjectInformationRequestDS(int n, int n2, int n3, int n4) {
        Object object = dbreturnobjectinformationrequestdsPoolLock_;
        synchronized (object) {
            DBReturnObjectInformationRequestDS dBReturnObjectInformationRequestDS;
            DBReturnObjectInformationRequestDS[] dBReturnObjectInformationRequestDSArray = dbreturnobjectinformationrequestdsPool_;
            int n5 = dBReturnObjectInformationRequestDSArray.length;
            for (int i = 0; i < dBReturnObjectInformationRequestDSArray.length; ++i) {
                if (dBReturnObjectInformationRequestDSArray[i] == null) {
                    dBReturnObjectInformationRequestDS = new DBReturnObjectInformationRequestDS(n, n2, n3, n4);
                    dBReturnObjectInformationRequestDS.canUse();
                    dBReturnObjectInformationRequestDSArray[i] = dBReturnObjectInformationRequestDS;
                    return dBReturnObjectInformationRequestDS;
                }
                dBReturnObjectInformationRequestDS = dBReturnObjectInformationRequestDSArray[i];
                synchronized (dBReturnObjectInformationRequestDS) {
                    if (!dBReturnObjectInformationRequestDSArray[i].inUse_ && dBReturnObjectInformationRequestDSArray[i].canUse()) {
                        dBReturnObjectInformationRequestDSArray[i].initialize(n, n2, n3, n4);
                        return dBReturnObjectInformationRequestDSArray[i];
                    }
                    continue;
                }
            }
            DBReturnObjectInformationRequestDS[] dBReturnObjectInformationRequestDSArray2 = new DBReturnObjectInformationRequestDS[n5 * 2];
            System.arraycopy(dBReturnObjectInformationRequestDSArray, 0, dBReturnObjectInformationRequestDSArray2, 0, n5);
            dBReturnObjectInformationRequestDS = new DBReturnObjectInformationRequestDS(n, n2, n3, n4);
            dBReturnObjectInformationRequestDS.canUse();
            dBReturnObjectInformationRequestDSArray2[n5] = dBReturnObjectInformationRequestDS;
            dbreturnobjectinformationrequestdsPool_ = dBReturnObjectInformationRequestDSArray2;
            return dBReturnObjectInformationRequestDS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final DBSQLDescriptorDS getDBSQLDescriptorDS(int n, int n2, int n3, int n4) {
        Object object = dbsqldescriptordsPoolLock_;
        synchronized (object) {
            DBSQLDescriptorDS dBSQLDescriptorDS;
            DBSQLDescriptorDS[] dBSQLDescriptorDSArray = dbsqldescriptordsPool_;
            int n5 = dBSQLDescriptorDSArray.length;
            for (int i = 0; i < n5; ++i) {
                if (dBSQLDescriptorDSArray[i] == null) {
                    dBSQLDescriptorDS = new DBSQLDescriptorDS(n, n2, n3, n4);
                    dBSQLDescriptorDS.canUse();
                    dBSQLDescriptorDSArray[i] = dBSQLDescriptorDS;
                    return dBSQLDescriptorDS;
                }
                dBSQLDescriptorDS = dBSQLDescriptorDSArray[i];
                synchronized (dBSQLDescriptorDS) {
                    if (!dBSQLDescriptorDSArray[i].inUse_ && dBSQLDescriptorDSArray[i].canUse()) {
                        dBSQLDescriptorDSArray[i].initialize(n, n2, n3, n4);
                        return dBSQLDescriptorDSArray[i];
                    }
                    continue;
                }
            }
            DBSQLDescriptorDS[] dBSQLDescriptorDSArray2 = new DBSQLDescriptorDS[n5 * 2];
            System.arraycopy(dBSQLDescriptorDSArray, 0, dBSQLDescriptorDSArray2, 0, n5);
            dBSQLDescriptorDS = new DBSQLDescriptorDS(n, n2, n3, n4);
            dBSQLDescriptorDS.canUse();
            dBSQLDescriptorDSArray2[n5] = dBSQLDescriptorDS;
            dbsqldescriptordsPool_ = dBSQLDescriptorDSArray2;
            return dBSQLDescriptorDS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final DBSQLRequestDS getDBSQLRequestDS(int n, int n2, int n3, int n4) {
        Object object = dbsqlrequestdsPoolLock_;
        synchronized (object) {
            int n5;
            DBSQLRequestDS[] dBSQLRequestDSArray = dbsqlrequestdsPool_;
            int n6 = dBSQLRequestDSArray.length;
            if (++dbsqlrequestdsPoolAllocations_ > dbsqlrequestdsPoolReclaimThreshold) {
                dbsqlrequestdsPoolAllocations_ = 0;
                for (n5 = dbsqlrequestdsPoolHighMark_ + 1; n5 < n6; ++n5) {
                    if (dBSQLRequestDSArray[n5] == null || dBSQLRequestDSArray[n5].inUse_ || !dBSQLRequestDSArray[n5].canUse()) continue;
                    dBSQLRequestDSArray[n5].reclaim();
                    dBSQLRequestDSArray[n5].returnToPool();
                }
                dbsqlrequestdsPoolHighMark_ = 0;
            }
            for (n5 = 0; n5 < n6; ++n5) {
                if (dBSQLRequestDSArray[n5] == null) {
                    DBSQLRequestDS dBSQLRequestDS = new DBSQLRequestDS(n, n2, n3, n4);
                    dBSQLRequestDS.canUse();
                    dBSQLRequestDSArray[n5] = dBSQLRequestDS;
                    if (n5 > dbsqlrequestdsPoolHighMark_) {
                        dbsqlrequestdsPoolHighMark_ = n5;
                    }
                    return dBSQLRequestDS;
                }
                if (dBSQLRequestDSArray[n5].inUse_ || !dBSQLRequestDSArray[n5].canUse()) continue;
                dBSQLRequestDSArray[n5].initialize(n, n2, n3, n4);
                if (n5 > dbsqlrequestdsPoolHighMark_) {
                    dbsqlrequestdsPoolHighMark_ = n5;
                }
                return dBSQLRequestDSArray[n5];
            }
            DBSQLRequestDS[] dBSQLRequestDSArray2 = new DBSQLRequestDS[n6 * 2];
            System.arraycopy(dBSQLRequestDSArray, 0, dBSQLRequestDSArray2, 0, n6);
            DBSQLRequestDS dBSQLRequestDS = new DBSQLRequestDS(n, n2, n3, n4);
            dBSQLRequestDS.canUse();
            dBSQLRequestDSArray2[n6] = dBSQLRequestDS;
            dbsqlrequestdsPool_ = dBSQLRequestDSArray2;
            if (n6 > dbsqlrequestdsPoolHighMark_) {
                dbsqlrequestdsPoolHighMark_ = n6;
            }
            return dBSQLRequestDS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final DBSQLResultSetDS getDBSQLResultSetDS(int n, int n2, int n3, int n4) {
        Object object = dbsqlresultsetdsPoolLock_;
        synchronized (object) {
            DBSQLResultSetDS[] dBSQLResultSetDSArray = dbsqlresultsetdsPool_;
            int n5 = dBSQLResultSetDSArray.length;
            for (int i = 0; i < n5; ++i) {
                if (dBSQLResultSetDSArray[i] == null) {
                    DBSQLResultSetDS dBSQLResultSetDS = new DBSQLResultSetDS(n, n2, n3, n4);
                    dBSQLResultSetDS.canUse();
                    dBSQLResultSetDSArray[i] = dBSQLResultSetDS;
                    return dBSQLResultSetDS;
                }
                if (dBSQLResultSetDSArray[i].inUse_ || !dBSQLResultSetDSArray[i].canUse()) continue;
                dBSQLResultSetDSArray[i].initialize(n, n2, n3, n4);
                return dBSQLResultSetDSArray[i];
            }
            DBSQLResultSetDS[] dBSQLResultSetDSArray2 = new DBSQLResultSetDS[n5 * 2];
            System.arraycopy(dBSQLResultSetDSArray, 0, dBSQLResultSetDSArray2, 0, n5);
            DBSQLResultSetDS dBSQLResultSetDS = new DBSQLResultSetDS(n, n2, n3, n4);
            dBSQLResultSetDS.canUse();
            dBSQLResultSetDSArray2[n5] = dBSQLResultSetDS;
            dbsqlresultsetdsPool_ = dBSQLResultSetDSArray2;
            return dBSQLResultSetDS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final DBSQLRPBDS getDBSQLRPBDS(int n, int n2, int n3, int n4) {
        Object object = dbsqlrpbdsPoolLock_;
        synchronized (object) {
            DBSQLRPBDS[] dBSQLRPBDSArray = dbsqlrpbdsPool_;
            int n5 = dBSQLRPBDSArray.length;
            for (int i = 0; i < n5; ++i) {
                if (dBSQLRPBDSArray[i] == null) {
                    DBSQLRPBDS dBSQLRPBDS = new DBSQLRPBDS(n, n2, n3, n4);
                    dBSQLRPBDS.canUse();
                    dBSQLRPBDSArray[i] = dBSQLRPBDS;
                    return dBSQLRPBDS;
                }
                if (dBSQLRPBDSArray[i].inUse_ || !dBSQLRPBDSArray[i].canUse()) continue;
                dBSQLRPBDSArray[i].initialize(n, n2, n3, n4);
                return dBSQLRPBDSArray[i];
            }
            DBSQLRPBDS[] dBSQLRPBDSArray2 = new DBSQLRPBDS[n5 * 2];
            System.arraycopy(dBSQLRPBDSArray, 0, dBSQLRPBDSArray2, 0, n5);
            DBSQLRPBDS dBSQLRPBDS = new DBSQLRPBDS(n, n2, n3, n4);
            dBSQLRPBDS.canUse();
            dBSQLRPBDSArray2[n5] = dBSQLRPBDS;
            dbsqlrpbdsPool_ = dBSQLRPBDSArray2;
            return dBSQLRPBDS;
        }
    }

    static {
        String string;
        dbsqlrpbdsPool_ = new DBSQLRPBDS[4];
        dbsqlrpbdsPoolLock_ = new Object();
        dbsqldescriptordsPool_ = new DBSQLDescriptorDS[4];
        dbsqldescriptordsPoolLock_ = new Object();
        dbsqlresultsetdsPool_ = new DBSQLResultSetDS[4];
        dbsqlresultsetdsPoolLock_ = new Object();
        dbsqlrequestdsPool_ = new DBSQLRequestDS[4];
        dbsqlrequestdsPoolLock_ = new Object();
        dbsqlrequestdsPoolHighMark_ = 0;
        dbsqlrequestdsPoolAllocations_ = 0;
        dbsqlrequestdsPoolReclaimThreshold = 1000;
        dbnativedatabaserequestdsPool_ = new DBNativeDatabaseRequestDS[4];
        dbnativedatabaserequestdsPoolLock_ = new Object();
        dbreturnobjectinformationrequestdsPool_ = new DBReturnObjectInformationRequestDS[4];
        dbreturnobjectinformationrequestdsPoolLock_ = new Object();
        dbsqlattributesdsPool_ = new DBSQLAttributesDS[4];
        dbsqlattributesdsPoolLock_ = new Object();
        dbxarequestdsPool_ = new DBXARequestDS[4];
        dbxarequestdsPoolLock_ = new Object();
        dbreplyrequesteddsPool_ = new SoftReference[4];
        dbreplyrequesteddsPoolLock_ = new Object();
        dbReplyRequestedPoolSearchStart_ = 0;
        dbReplyRequestedPoolSearchCount_ = 0;
        dbReplyRequestedPoolFull_ = false;
        storagePool_ = new DBStoragePool();
        changeTime = "2010/06/14 08:09";
        noDBReplyPooling = false;
        monitor = false;
        String string2 = SystemProperties.getProperty("com.ibm.as400.access.noDBReplyPooling");
        if (string2 != null) {
            noDBReplyPooling = true;
        }
        if ((string = SystemProperties.getProperty("com.ibm.as400.access.DBDSPool.monitor")) != null) {
            monitor = true;
        }
    }
}

