/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.io.CharConversionException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class CharConverter
implements Serializable {
    static final long serialVersionUID = 4L;
    private static boolean faultTolerantConversion_ = false;
    private Converter table_;

    public CharConverter() {
        this.table_ = new Converter();
    }

    public CharConverter(String string) throws UnsupportedEncodingException {
        if (string == null) {
            throw new NullPointerException("encoding");
        }
        this.table_ = new Converter(string);
    }

    public CharConverter(int n) throws UnsupportedEncodingException {
        this.table_ = new Converter(n);
    }

    public CharConverter(int n, AS400 aS400) throws UnsupportedEncodingException {
        if (aS400 == null) {
            if (Trace.traceOn_) {
                Trace.log(1, "Null-valued 'system' argument specified.");
            }
            this.table_ = new Converter(n);
        } else {
            this.table_ = new Converter(n, aS400);
        }
    }

    public String byteArrayToString(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("source");
        }
        return this.table_.byteArrayToString(byArray);
    }

    public String byteArrayToString(byte[] byArray, int n) {
        if (byArray == null) {
            throw new NullPointerException("source");
        }
        return this.table_.byteArrayToString(byArray, n);
    }

    public String byteArrayToString(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException("source");
        }
        return this.table_.byteArrayToString(byArray, n, n2);
    }

    public String byteArrayToString(byte[] byArray, int n, int n2, int n3) {
        if (byArray == null) {
            throw new NullPointerException("source");
        }
        return this.byteArrayToString(byArray, n, n2, new BidiConversionProperties(n3));
    }

    public String byteArrayToString(byte[] byArray, int n, int n2, BidiConversionProperties bidiConversionProperties) {
        if (byArray == null) {
            throw new NullPointerException("source");
        }
        return this.table_.byteArrayToString(byArray, n, n2, bidiConversionProperties);
    }

    public static String byteArrayToString(AS400 aS400, byte[] byArray) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (byArray == null) {
            throw new NullPointerException("source");
        }
        try {
            return new Converter(aS400.getCcsid(), aS400).byteArrayToString(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Trace.log(2, "Unexpected UnsupportedEncodingException:", (Throwable)unsupportedEncodingException);
            throw new InternalErrorException(10);
        }
    }

    public static String byteArrayToString(int n, AS400 aS400, byte[] byArray) throws UnsupportedEncodingException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (byArray == null) {
            throw new NullPointerException("source");
        }
        return new Converter(n, aS400).byteArrayToString(byArray);
    }

    public static String byteArrayToString(int n, byte[] byArray) throws UnsupportedEncodingException {
        if (byArray == null) {
            throw new NullPointerException("source");
        }
        return new Converter(n).byteArrayToString(byArray);
    }

    public static String convertIFSQSYSPathnameToJobPathname(String string, int n) throws UnsupportedEncodingException {
        if (string == null) {
            throw new NullPointerException("qsysData");
        }
        return new Converter(n, null).byteArrayToString(new Converter(37, null).stringToByteArray(string));
    }

    public static String convertJobPathnameToIFSQSYSPathname(String string, int n) throws UnsupportedEncodingException {
        if (string == null) {
            throw new NullPointerException("jobData");
        }
        return new Converter(37, null).byteArrayToString(new Converter(n, null).stringToByteArray(string));
    }

    public int getCcsid() {
        return this.table_.getCcsid();
    }

    public String getEncoding() {
        return this.table_.getEncoding();
    }

    public static boolean isFaultTolerantConversion() {
        return faultTolerantConversion_;
    }

    public static void setFaultTolerantConversion(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(3, "Setting fault tolerant conversion:", bl);
        }
        faultTolerantConversion_ = bl;
    }

    public byte[] stringToByteArray(String string) {
        if (string == null) {
            throw new NullPointerException("source");
        }
        return this.table_.stringToByteArray(string);
    }

    public byte[] stringToByteArray(String string, int n) {
        if (string == null) {
            throw new NullPointerException("source");
        }
        return this.stringToByteArray(string, new BidiConversionProperties(n));
    }

    public byte[] stringToByteArray(String string, BidiConversionProperties bidiConversionProperties) {
        if (string == null) {
            throw new NullPointerException("source");
        }
        return this.table_.stringToByteArray(string, bidiConversionProperties);
    }

    public void stringToByteArray(String string, byte[] byArray) throws CharConversionException {
        if (string == null) {
            throw new NullPointerException("source");
        }
        if (byArray == null) {
            throw new NullPointerException("destination");
        }
        this.table_.stringToByteArray(string, byArray);
    }

    public void stringToByteArray(String string, byte[] byArray, int n) throws CharConversionException {
        if (string == null) {
            throw new NullPointerException("source");
        }
        if (byArray == null) {
            throw new NullPointerException("destination");
        }
        this.table_.stringToByteArray(string, byArray, n);
    }

    public void stringToByteArray(String string, byte[] byArray, int n, int n2) throws CharConversionException {
        if (string == null) {
            throw new NullPointerException("source");
        }
        if (byArray == null) {
            throw new NullPointerException("destination");
        }
        this.table_.stringToByteArray(string, byArray, n, n2);
    }

    public void stringToByteArray(String string, byte[] byArray, int n, int n2, int n3) throws CharConversionException {
        if (string == null) {
            throw new NullPointerException("source");
        }
        if (byArray == null) {
            throw new NullPointerException("destination");
        }
        this.table_.stringToByteArray(string, byArray, n, n2, new BidiConversionProperties(n3));
    }

    public void stringToByteArray(String string, byte[] byArray, int n, int n2, BidiConversionProperties bidiConversionProperties) throws CharConversionException {
        if (string == null) {
            throw new NullPointerException("source");
        }
        if (byArray == null) {
            throw new NullPointerException("destination");
        }
        this.table_.stringToByteArray(string, byArray, n, n2, bidiConversionProperties);
    }

    public static byte[] stringToByteArray(AS400 aS400, String string) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("source");
        }
        try {
            return new Converter(aS400.getCcsid(), aS400).stringToByteArray(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Trace.log(2, "Unexpected UnsupportedEncodingException:", (Throwable)unsupportedEncodingException);
            throw new InternalErrorException(10);
        }
    }

    public static byte[] stringToByteArray(int n, AS400 aS400, String string) throws UnsupportedEncodingException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("source");
        }
        return new Converter(n, aS400).stringToByteArray(string);
    }

    public static byte[] stringToByteArray(int n, String string) throws UnsupportedEncodingException {
        if (string == null) {
            throw new NullPointerException("source");
        }
        return new Converter(n).stringToByteArray(string);
    }
}

