/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction;

import com.google.cloud.Timestamp;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.InitialPartition;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.PartitionMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.TimestampRange;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.TimestampRangeTracker;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ReadChangeStreamPartitionRangeTracker
extends TimestampRangeTracker {
    private final @UnknownKeyFor @NonNull @Initialized PartitionMetadata partition;

    public ReadChangeStreamPartitionRangeTracker(@UnknownKeyFor @NonNull @Initialized PartitionMetadata partition, @UnknownKeyFor @NonNull @Initialized TimestampRange range) {
        super(range);
        this.partition = partition;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean tryClaim(@UnknownKeyFor @NonNull @Initialized Timestamp position) {
        if (position.equals((Object)this.lastAttemptedPosition)) {
            return true;
        }
        return super.tryClaim(position);
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized SplitResult<@UnknownKeyFor @NonNull @Initialized TimestampRange> trySplit(@UnknownKeyFor @NonNull @Initialized double fractionOfRemainder) {
        if (InitialPartition.isInitialPartition(this.partition.getPartitionToken())) {
            return null;
        }
        return super.trySplit(fractionOfRemainder);
    }
}

