/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.FailedPreconditionException;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.bigquery.storage.v1.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.cloud.bigquery.storage.v1.ReadStream;
import com.google.cloud.bigquery.storage.v1.SplitReadStreamRequest;
import com.google.cloud.bigquery.storage.v1.SplitReadStreamResponse;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.beam.runners.core.metrics.ServiceCallMetric;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageReader;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageReaderFactory;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.io.gcp.bigquery.SchemaAndRecord;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BigQueryStorageStreamSource<@UnknownKeyFor T>
extends BoundedSource<T> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(BigQueryStorageStreamSource.class);
    private final @UnknownKeyFor @NonNull @Initialized ReadSession readSession;
    private final @UnknownKeyFor @NonNull @Initialized ReadStream readStream;
    private final @UnknownKeyFor @NonNull @Initialized String jsonTableSchema;
    private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SchemaAndRecord, T> parseFn;
    private final @UnknownKeyFor @NonNull @Initialized Coder<T> outputCoder;
    private final @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices;

    public static <T> @UnknownKeyFor @NonNull @Initialized BigQueryStorageStreamSource<T> create(@UnknownKeyFor @NonNull @Initialized ReadSession readSession, @UnknownKeyFor @NonNull @Initialized ReadStream readStream, @UnknownKeyFor @NonNull @Initialized TableSchema tableSchema, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SchemaAndRecord, T> parseFn, @UnknownKeyFor @NonNull @Initialized Coder<T> outputCoder, @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices) {
        return new BigQueryStorageStreamSource<T>(readSession, readStream, BigQueryHelpers.toJsonString(org.apache.beam.sdk.util.Preconditions.checkArgumentNotNull((Object)tableSchema, (Object)"tableSchema")), parseFn, outputCoder, bqServices);
    }

    public @UnknownKeyFor @NonNull @Initialized BigQueryStorageStreamSource<T> fromExisting(@UnknownKeyFor @NonNull @Initialized ReadStream newReadStream) {
        return new BigQueryStorageStreamSource<T>(this.readSession, newReadStream, this.jsonTableSchema, this.parseFn, this.outputCoder, this.bqServices);
    }

    private BigQueryStorageStreamSource(@UnknownKeyFor @NonNull @Initialized ReadSession readSession, @UnknownKeyFor @NonNull @Initialized ReadStream readStream, @UnknownKeyFor @NonNull @Initialized String jsonTableSchema, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SchemaAndRecord, T> parseFn, @UnknownKeyFor @NonNull @Initialized Coder<T> outputCoder, @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices) {
        this.readSession = (ReadSession)org.apache.beam.sdk.util.Preconditions.checkArgumentNotNull((Object)readSession, (Object)"readSession");
        this.readStream = (ReadStream)org.apache.beam.sdk.util.Preconditions.checkArgumentNotNull((Object)readStream, (Object)"stream");
        this.jsonTableSchema = (String)org.apache.beam.sdk.util.Preconditions.checkArgumentNotNull((Object)jsonTableSchema, (Object)"jsonTableSchema");
        this.parseFn = (SerializableFunction)org.apache.beam.sdk.util.Preconditions.checkArgumentNotNull(parseFn, (Object)"parseFn");
        this.outputCoder = (Coder)org.apache.beam.sdk.util.Preconditions.checkArgumentNotNull(outputCoder, (Object)"outputCoder");
        this.bqServices = (BigQueryServices)org.apache.beam.sdk.util.Preconditions.checkArgumentNotNull((Object)bqServices, (Object)"bqServices");
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<T> getOutputCoder() {
        return this.outputCoder;
    }

    public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.add(DisplayData.item((String)"table", (String)this.readSession.getTable()).withLabel("Table")).add(DisplayData.item((String)"readSession", (String)this.readSession.getName()).withLabel("Read session")).add(DisplayData.item((String)"stream", (String)this.readStream.getName()).withLabel("Stream"));
    }

    public @UnknownKeyFor @NonNull @Initialized long getEstimatedSizeBytes(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        return 0L;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized BoundedSource<T>> split(@UnknownKeyFor @NonNull @Initialized long desiredBundleSizeBytes, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        return ImmutableList.of((Object)((Object)this));
    }

    public @UnknownKeyFor @NonNull @Initialized BigQueryStorageStreamReader<T> createReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return new BigQueryStorageStreamReader(this, (BigQueryOptions)options.as(BigQueryOptions.class));
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return this.readStream.toString();
    }

    public static class BigQueryStorageStreamReader<@UnknownKeyFor T>
    extends BoundedSource.BoundedReader<T> {
        private final @UnknownKeyFor @NonNull @Initialized BigQueryStorageReader reader;
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SchemaAndRecord, T> parseFn;
        private final @UnknownKeyFor @NonNull @Initialized BigQueryServices.StorageClient storageClient;
        private final @UnknownKeyFor @NonNull @Initialized TableSchema tableSchema;
        private @UnknownKeyFor @NonNull @Initialized BigQueryStorageStreamSource<T> source;
        private @Nullable @UnknownKeyFor @Initialized BigQueryServices.BigQueryServerStream<@UnknownKeyFor @NonNull @Initialized ReadRowsResponse> responseStream = null;
        private @Nullable @UnknownKeyFor @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized ReadRowsResponse> responseIterator = null;
        private @Nullable T current = null;
        private @UnknownKeyFor @NonNull @Initialized long currentOffset;
        private @UnknownKeyFor @NonNull @Initialized boolean splitPossible = true;
        private @UnknownKeyFor @NonNull @Initialized double fractionConsumed;
        private @UnknownKeyFor @NonNull @Initialized double progressAtResponseStart;
        private @UnknownKeyFor @NonNull @Initialized double progressAtResponseEnd;
        private @UnknownKeyFor @NonNull @Initialized long rowsConsumedFromCurrentResponse;
        private @UnknownKeyFor @NonNull @Initialized long totalRowsInCurrentResponse;
        private @Nullable @UnknownKeyFor @Initialized TableReference tableReference;
        private @Nullable @UnknownKeyFor @Initialized ServiceCallMetric serviceCallMetric;
        private final @UnknownKeyFor @NonNull @Initialized Counter totalSplitCalls = Metrics.counter(BigQueryStorageStreamReader.class, (String)"split-at-fraction-calls");
        private final @UnknownKeyFor @NonNull @Initialized Counter impossibleSplitPointCalls = Metrics.counter(BigQueryStorageStreamReader.class, (String)"split-at-fraction-calls-failed-due-to-impossible-split-point");
        private final @UnknownKeyFor @NonNull @Initialized Counter badSplitPointCalls = Metrics.counter(BigQueryStorageStreamReader.class, (String)"split-at-fraction-calls-failed-due-to-bad-split-point");
        private final @UnknownKeyFor @NonNull @Initialized Counter otherFailedSplitCalls = Metrics.counter(BigQueryStorageStreamReader.class, (String)"split-at-fraction-calls-failed-due-to-other-reasons");
        private final @UnknownKeyFor @NonNull @Initialized Counter successfulSplitCalls = Metrics.counter(BigQueryStorageStreamReader.class, (String)"split-at-fraction-calls-successful");

        private BigQueryStorageStreamReader(@UnknownKeyFor @NonNull @Initialized BigQueryStorageStreamSource<T> source, @UnknownKeyFor @NonNull @Initialized BigQueryOptions options) throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.source = source;
            this.reader = BigQueryStorageReaderFactory.getReader(((BigQueryStorageStreamSource)source).readSession);
            this.parseFn = ((BigQueryStorageStreamSource)source).parseFn;
            this.storageClient = ((BigQueryStorageStreamSource)source).bqServices.getStorageClient(options);
            this.tableSchema = BigQueryHelpers.fromJsonString(((BigQueryStorageStreamSource)source).jsonTableSchema, TableSchema.class);
            this.fractionConsumed = 0.0;
            this.progressAtResponseStart = 0.0;
            this.progressAtResponseEnd = 0.0;
            this.rowsConsumedFromCurrentResponse = 0L;
            this.totalRowsInCurrentResponse = 0L;
        }

        public synchronized @UnknownKeyFor @NonNull @Initialized boolean start() throws @UnknownKeyFor @NonNull @Initialized IOException {
            BoundedSource source = this.getCurrentSource();
            ReadRowsRequest request = ReadRowsRequest.newBuilder().setReadStream(((BigQueryStorageStreamSource)source).readStream.getName()).setOffset(this.currentOffset).build();
            this.tableReference = BigQueryUtils.toTableReference(((BigQueryStorageStreamSource)source).readSession.getTable());
            this.serviceCallMetric = BigQueryUtils.readCallMetric(this.tableReference);
            LOG.info("Started BigQuery Storage API read from stream {}.", (Object)((BigQueryStorageStreamSource)source).readStream.getName());
            this.responseStream = this.storageClient.readRows(request, ((BigQueryStorageStreamSource)source).readSession.getTable());
            this.responseIterator = this.responseStream.iterator();
            return this.readNextRecord();
        }

        public synchronized @UnknownKeyFor @NonNull @Initialized boolean advance() throws @UnknownKeyFor @NonNull @Initialized IOException {
            org.apache.beam.sdk.util.Preconditions.checkStateNotNull(this.responseIterator);
            ++this.currentOffset;
            return this.readNextRecord();
        }

        @RequiresNonNull(value={"responseIterator"})
        private synchronized @UnknownKeyFor @NonNull @Initialized boolean readNextRecord() throws @UnknownKeyFor @NonNull @Initialized IOException {
            Iterator<ReadRowsResponse> responseIterator = this.responseIterator;
            while (this.reader.readyForNextReadResponse()) {
                ReadRowsResponse response;
                if (!responseIterator.hasNext()) {
                    this.fractionConsumed = 1.0;
                    return false;
                }
                try {
                    response = responseIterator.next();
                    if (this.serviceCallMetric != null) {
                        this.serviceCallMetric.call("ok");
                    }
                }
                catch (ApiException e) {
                    if (this.serviceCallMetric != null) {
                        this.serviceCallMetric.call(e.getStatusCode().getCode().name());
                    }
                    throw e;
                }
                this.progressAtResponseStart = response.getStats().getProgress().getAtResponseStart();
                this.progressAtResponseEnd = response.getStats().getProgress().getAtResponseEnd();
                this.totalRowsInCurrentResponse = response.getRowCount();
                this.rowsConsumedFromCurrentResponse = 0L;
                Preconditions.checkArgument((this.totalRowsInCurrentResponse >= 0L ? 1 : 0) != 0, (String)"Row count from current response (%s) must be non-negative.", (long)this.totalRowsInCurrentResponse);
                Preconditions.checkArgument((0.0 <= this.progressAtResponseStart && this.progressAtResponseStart <= 1.0 ? 1 : 0) != 0, (String)"Progress at response start (%s) is not in the range [0.0, 1.0].", (Object)this.progressAtResponseStart);
                Preconditions.checkArgument((0.0 <= this.progressAtResponseEnd && this.progressAtResponseEnd <= 1.0 ? 1 : 0) != 0, (String)"Progress at response end (%s) is not in the range [0.0, 1.0].", (Object)this.progressAtResponseEnd);
                this.reader.processReadRowsResponse(response);
            }
            SchemaAndRecord schemaAndRecord = new SchemaAndRecord(this.reader.readSingleRecord(), this.tableSchema);
            this.current = this.parseFn.apply((Object)schemaAndRecord);
            ++this.rowsConsumedFromCurrentResponse;
            this.fractionConsumed = this.progressAtResponseStart + (this.progressAtResponseEnd - this.progressAtResponseStart) * (double)this.rowsConsumedFromCurrentResponse * 1.0 / (double)this.totalRowsInCurrentResponse;
            return true;
        }

        public T getCurrent() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            return this.current;
        }

        public synchronized void close() {
            org.apache.beam.sdk.util.Preconditions.checkStateNotNull((Object)this.storageClient);
            org.apache.beam.sdk.util.Preconditions.checkStateNotNull((Object)this.reader);
            this.storageClient.close();
            this.reader.close();
        }

        public synchronized @UnknownKeyFor @NonNull @Initialized BigQueryStorageStreamSource<T> getCurrentSource() {
            return this.source;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public @Nullable @UnknownKeyFor @Initialized BoundedSource<T> splitAtFraction(@UnknownKeyFor @NonNull @Initialized double fraction) {
            org.apache.beam.sdk.util.Preconditions.checkStateNotNull(this.responseStream);
            BigQueryServices.BigQueryServerStream<ReadRowsResponse> responseStream = this.responseStream;
            this.totalSplitCalls.inc();
            LOG.debug("Received BigQuery Storage API split request for stream {} at fraction {}.", (Object)((BigQueryStorageStreamSource)this.source).readStream.getName(), (Object)fraction);
            if (fraction <= 0.0 || fraction >= 1.0) {
                LOG.info("BigQuery Storage API does not support splitting at fraction {}", (Object)fraction);
                return null;
            }
            if (!this.splitPossible) {
                return null;
            }
            SplitReadStreamRequest splitRequest = SplitReadStreamRequest.newBuilder().setName(((BigQueryStorageStreamSource)this.source).readStream.getName()).setFraction((double)((float)fraction)).build();
            SplitReadStreamResponse splitResponse = this.storageClient.splitReadStream(splitRequest);
            if (!splitResponse.hasPrimaryStream() || !splitResponse.hasRemainderStream()) {
                this.impossibleSplitPointCalls.inc();
                LOG.info("BigQuery Storage API stream {} cannot be split at {}.", (Object)((BigQueryStorageStreamSource)this.source).readStream.getName(), (Object)fraction);
                this.splitPossible = false;
                return null;
            }
            BigQueryStorageStreamReader bigQueryStorageStreamReader = this;
            synchronized (bigQueryStorageStreamReader) {
                Iterator newResponseIterator;
                BigQueryServices.BigQueryServerStream<ReadRowsResponse> newResponseStream;
                try {
                    newResponseStream = this.storageClient.readRows(ReadRowsRequest.newBuilder().setReadStream(splitResponse.getPrimaryStream().getName()).setOffset(this.currentOffset + 1L).build(), ((BigQueryStorageStreamSource)this.source).readSession.getTable());
                    newResponseIterator = newResponseStream.iterator();
                    newResponseIterator.hasNext();
                }
                catch (FailedPreconditionException e) {
                    this.badSplitPointCalls.inc();
                    LOG.info("BigQuery Storage API split of stream {} abandoned because the primary stream is to the left of the split fraction {}.", (Object)((BigQueryStorageStreamSource)this.source).readStream.getName(), (Object)fraction);
                    return null;
                }
                catch (Exception e) {
                    this.otherFailedSplitCalls.inc();
                    LOG.error("BigQuery Storage API stream split failed.", (Throwable)e);
                    return null;
                }
                responseStream.cancel();
                this.source = this.source.fromExisting(splitResponse.getPrimaryStream());
                responseStream = newResponseStream;
                this.responseIterator = newResponseIterator;
                this.reader.resetBuffer();
            }
            this.successfulSplitCalls.inc();
            LOG.info("Successfully split BigQuery Storage API stream at {}. Split response: {}", (Object)fraction, (Object)splitResponse);
            return this.source.fromExisting(splitResponse.getRemainderStream());
        }

        public synchronized @UnknownKeyFor @NonNull @Initialized Double getFractionConsumed() {
            return this.fractionConsumed;
        }
    }
}

