/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.vendor.grpc.v1p48p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class FlinkKeyUtils {
    public static <K> @UnknownKeyFor @NonNull @Initialized ByteBuffer encodeKey(K key, @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder) {
        byte[] keyBytes;
        Preconditions.checkNotNull(keyCoder, (Object)"Provided coder must not be null");
        try {
            keyBytes = CoderUtils.encodeToByteArray(keyCoder, key, (Coder.Context)Coder.Context.NESTED);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format(Locale.ENGLISH, "Failed to encode key: %s", key), e);
        }
        return ByteBuffer.wrap(keyBytes);
    }

    public static <K> K decodeKey(@UnknownKeyFor @NonNull @Initialized ByteBuffer byteBuffer, @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder) {
        Preconditions.checkNotNull((Object)byteBuffer, (Object)"Provided ByteBuffer must not be null");
        Preconditions.checkNotNull(keyCoder, (Object)"Provided coder must not be null");
        Preconditions.checkState((boolean)byteBuffer.hasArray(), (Object)"ByteBuffer key must contain an array.");
        byte[] keyBytes = byteBuffer.array();
        try {
            return (K)CoderUtils.decodeFromByteArray(keyCoder, (byte[])keyBytes, (Coder.Context)Coder.Context.NESTED);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format(Locale.ENGLISH, "Failed to decode encoded key: %s", Arrays.toString(keyBytes)), e);
        }
    }

    static @UnknownKeyFor @NonNull @Initialized ByteBuffer fromEncodedKey(@UnknownKeyFor @NonNull @Initialized ByteString encodedKey) {
        return ByteBuffer.wrap(encodedKey.toByteArray());
    }

    static class ByteBufferCoder
    extends StructuredCoder<ByteBuffer> {
        private static final @UnknownKeyFor @NonNull @Initialized ByteBufferCoder INSTANCE = new ByteBufferCoder();

        public static @UnknownKeyFor @NonNull @Initialized ByteBufferCoder of() {
            return INSTANCE;
        }

        private ByteBufferCoder() {
        }

        public void encode(@UnknownKeyFor @NonNull @Initialized ByteBuffer value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            byte[] array = value.array();
            ByteArrayCoder.of().encode(array, outStream);
        }

        public @UnknownKeyFor @NonNull @Initialized ByteBuffer decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
            byte[] decode = ByteArrayCoder.of().decode(inStream);
            return ByteBuffer.wrap(decode);
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
            return Collections.emptyList();
        }

        public void verifyDeterministic() {
        }
    }
}

