/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.action.validator;

import java.io.IOException;
import java.util.List;
import org.apache.commons.validator.util.ValidatorUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.ValidatorContext;

public class FileDoesNotExistValidator
extends AbstractFileValidator {
    private static final String KEY_FAIL_IF_EXISTS = "org.apache.hop.workflow.actions.createfile.failIfExists";
    public static final FileDoesNotExistValidator INSTANCE = new FileDoesNotExistValidator();
    static final String VALIDATOR_NAME = "fileDoesNotExist";

    @Override
    public boolean validate(ICheckResultSource source, String propertyName, List<ICheckResult> remarks, ValidatorContext context) {
        String filename = ValidatorUtils.getValueAsString((Object)source, (String)propertyName);
        IVariables variables = this.getVariableSpace(source, propertyName, remarks, context);
        boolean failIfExists = this.getFailIfExists(source, propertyName, remarks, context);
        if (null == variables) {
            return false;
        }
        String realFileName = variables.resolve(filename);
        FileObject fileObject = null;
        try {
            fileObject = HopVfs.getFileObject((String)realFileName);
            if (fileObject.exists() && failIfExists) {
                ActionValidatorUtils.addFailureRemark(source, propertyName, VALIDATOR_NAME, remarks, ActionValidatorUtils.getLevelOnFail(context, VALIDATOR_NAME));
                return false;
            }
            try {
                fileObject.close();
            }
            catch (IOException iOException) {}
        }
        catch (Exception e) {
            ActionValidatorUtils.addExceptionRemark(source, propertyName, VALIDATOR_NAME, remarks, e);
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        return VALIDATOR_NAME;
    }

    public static ValidatorContext putFailIfExists(boolean failIfExists) {
        ValidatorContext context = new ValidatorContext();
        context.put(KEY_FAIL_IF_EXISTS, failIfExists);
        return context;
    }

    protected boolean getFailIfExists(ICheckResultSource source, String propertyName, List<ICheckResult> remarks, ValidatorContext context) {
        Object obj = context.get(KEY_FAIL_IF_EXISTS);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return false;
    }

    public static void putFailIfExists(ValidatorContext context, boolean failIfExists) {
        context.put(KEY_FAIL_IF_EXISTS, failIfExists);
    }
}

