/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transform.stream;

import org.apache.hop.core.Const;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transform.stream.StreamIcon;

public class Stream
implements IStream {
    private String description;
    private IStream.StreamType streamType;
    private TransformMeta transformMeta;
    private StreamIcon streamIcon;
    private String subject;

    public Stream(IStream.StreamType streamType, TransformMeta transformMeta, String description, StreamIcon streamIcon, String subject) {
        this.streamType = streamType;
        this.transformMeta = transformMeta;
        this.description = description;
        this.streamIcon = streamIcon;
        this.subject = subject;
    }

    public Stream(IStream stream) {
        this(stream.getStreamType(), stream.getTransformMeta(), stream.getDescription(), stream.getStreamIcon(), stream.getSubject());
    }

    public String toString() {
        if (this.transformMeta == null) {
            return "Stream type " + this.streamType + Const.CR + this.description;
        }
        return "Stream type " + this.streamType + " for transform '" + this.transformMeta.getName() + "'" + Const.CR + this.description;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IStream)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        IStream stream = (IStream)obj;
        return this.description.equals(stream.getDescription());
    }

    public int hashCode() {
        return this.description.hashCode();
    }

    @Override
    public String getTransformName() {
        if (this.transformMeta == null) {
            return null;
        }
        return this.transformMeta.getName();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public IStream.StreamType getStreamType() {
        return this.streamType;
    }

    @Override
    public void setStreamType(IStream.StreamType streamType) {
        this.streamType = streamType;
    }

    @Override
    public TransformMeta getTransformMeta() {
        return this.transformMeta;
    }

    @Override
    public void setTransformMeta(TransformMeta transformMeta) {
        this.transformMeta = transformMeta;
    }

    @Override
    public StreamIcon getStreamIcon() {
        return this.streamIcon;
    }

    @Override
    public void setStreamIcon(StreamIcon streamIcon) {
        this.streamIcon = streamIcon;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public void setSubject(String subject) {
        this.subject = subject;
    }
}

