/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.imp;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.HopEnvironment;
import org.apache.hop.core.HopVersionProvider;
import org.apache.hop.core.IProgressMonitor;
import org.apache.hop.core.LogProgressMonitor;
import org.apache.hop.core.config.plugin.ConfigPluginType;
import org.apache.hop.core.config.plugin.IConfigOptions;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.imp.IHopImport;
import org.apache.hop.imp.ImportPluginType;
import org.apache.hop.metadata.api.IHasHopMetadataProvider;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import picocli.CommandLine;

@CommandLine.Command(versionProvider=HopVersionProvider.class)
public class HopImport
implements Runnable,
IHasHopMetadataProvider {
    @CommandLine.Option(names={"-t", "--type"}, description={"The type of import plugin to use (e.g. kettle)"}, defaultValue="kettle")
    private String type;
    @CommandLine.Option(names={"-i", "--input"}, description={"The input folder to read from"})
    private String inputFolderName;
    @CommandLine.Option(names={"-o", "--output"}, description={"The output folder to write to"})
    private String outputFolderName;
    @CommandLine.Option(names={"-s", "--shared-xml"}, description={"The shared.xml file to read from"})
    private String sharedXmlFilename;
    @CommandLine.Option(names={"-k", "--kettle-properties"}, description={"The kettle.properties file to read from"})
    private String kettlePropertiesFilename;
    @CommandLine.Option(names={"-j", "--jdbc-properties"}, description={"The jdbc.properties file to read from"})
    private String jdbcPropertiesFilename;
    @CommandLine.Option(names={"-c", "--target-config-file"}, description={"The target config file to write variable to"})
    private String targetConfigFilename;
    @CommandLine.Option(names={"-e", "--skip-existing"}, description={"Skip existing files in the target folders "}, defaultValue="true")
    private Boolean skippingExistingTargetFiles = true;
    @CommandLine.Option(names={"-p", "--skip-hidden"}, description={"Skip import of hidden files and folders"}, defaultValue="true")
    private Boolean skippingHiddenFilesAndFolders = true;
    @CommandLine.Option(names={"-f", "--skip-folders"}, description={"Skip import of sub-folders"}, defaultValue="false")
    private Boolean skippingFolders = false;
    @CommandLine.Option(names={"-l", "--list-plugins"}, description={"List the available import plugins"})
    private Boolean listPluginTypes;
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Displays this help message and quits."})
    private boolean helpRequested;
    @CommandLine.Option(names={"-v", "--version"}, versionHelp=true, description={"Print version information and exit"})
    private boolean versionRequested;
    private IVariables variables = new Variables();
    private CommandLine cmd;
    private ILogChannel log;
    private boolean finishedWithoutError;
    private IHopImport hopImport;

    @Override
    public void run() {
        try {
            this.log = new LogChannel((Object)"HopImport");
            if (this.listPluginTypes != null && this.listPluginTypes.booleanValue()) {
                this.printPluginTypes();
                return;
            }
            if (!this.validateOptions()) {
                this.cmd.usage(System.err);
                return;
            }
            this.hopImport = this.loadImportPlugin();
            if (this.hopImport == null) {
                return;
            }
            this.log.logDetailed("Start of Hop Import");
            this.hopImport.setValidateInputFolder(this.inputFolderName);
            this.hopImport.setValidateOutputFolder(this.outputFolderName);
            this.hopImport.setKettlePropertiesFilename(this.kettlePropertiesFilename);
            this.hopImport.setJdbcPropertiesFilename(this.jdbcPropertiesFilename);
            this.hopImport.setSharedXmlFilename(this.sharedXmlFilename);
            if (this.skippingExistingTargetFiles != null) {
                this.log.logBasic("Import is " + (this.skippingExistingTargetFiles != false ? "" : "not ") + "skipping existing target files");
                this.hopImport.setSkippingExistingTargetFiles(this.skippingExistingTargetFiles);
            }
            if (this.skippingHiddenFilesAndFolders != null) {
                this.log.logBasic("Import is " + (this.skippingHiddenFilesAndFolders != false ? "" : "not ") + "skipping hidden files and folders");
                this.hopImport.setSkippingHiddenFilesAndFolders(this.skippingHiddenFilesAndFolders);
            }
            if (this.skippingFolders != null) {
                this.log.logBasic("Import is " + (this.skippingFolders != false ? "" : "not ") + "skipping sub-folders");
                this.hopImport.setSkippingFolders(this.skippingFolders);
            }
            this.hopImport.setTargetConfigFilename(this.targetConfigFilename);
            ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this.variables, (String)HopExtensionPoint.HopImportStart.id, (Object)this);
            Map mixins = this.cmd.getMixins();
            for (String key : mixins.keySet()) {
                Object mixin = mixins.get(key);
                if (!(mixin instanceof IConfigOptions)) continue;
                IConfigOptions configOptions = (IConfigOptions)mixin;
                configOptions.handleOption(this.log, (IHasHopMetadataProvider)this, this.variables);
            }
            LogProgressMonitor monitor = new LogProgressMonitor(this.log);
            this.hopImport.runImport((IProgressMonitor)monitor);
            this.log.logBasic(Const.CR);
            this.log.logBasic(this.hopImport.getImportReport());
            ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this.variables, (String)HopExtensionPoint.HopImportEnd.id, (Object)this);
        }
        catch (Exception e) {
            throw new CommandLine.ExecutionException(this.cmd, "There was an error during import", (Throwable)e);
        }
    }

    private IHopImport loadImportPlugin() throws HopException {
        PluginRegistry registry = PluginRegistry.getInstance();
        IPlugin plugin = registry.getPlugin(ImportPluginType.class, this.type);
        if (plugin == null) {
            System.err.println("Import plugin type '" + this.type + "' could not be found.");
            this.printPluginTypes();
            return null;
        }
        IHopImport hi = (IHopImport)registry.loadClass(plugin, IHopImport.class);
        hi.init(this.variables, this.log);
        return hi;
    }

    private void printPluginTypes() {
        System.err.println("Here are the available import plugins:");
        for (IPlugin importPlugin : PluginRegistry.getInstance().getPlugins(ImportPluginType.class)) {
            System.err.println("  - " + importPlugin.getIds()[0]);
            System.err.println("    Name: " + importPlugin.getName());
            System.err.println("    Description: " + importPlugin.getDescription());
            System.err.println("    Documentation URL: " + importPlugin.getDocumentationUrl());
        }
    }

    private void buildVariableSpace() throws IOException {
        this.variables = Variables.getADefaultVariableSpace();
    }

    private boolean validateOptions() throws HopException {
        boolean ok = true;
        if (StringUtils.isEmpty((String)this.inputFolderName)) {
            this.log.logBasic("Please specify an input folder to read from");
            ok = false;
        }
        if (StringUtils.isEmpty((String)this.outputFolderName)) {
            this.log.logBasic("Please specify an output folder to write to");
            ok = false;
        }
        if (StringUtils.isEmpty((String)this.type)) {
            this.log.logBasic("You need to specify the type of import plugin to use");
            this.printPluginTypes();
            ok = false;
        }
        return ok;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Boolean getSkippingExistingTargetFiles() {
        return this.skippingExistingTargetFiles;
    }

    public void setSkippingExistingTargetFiles(Boolean skippingExistingTargetFiles) {
        this.skippingExistingTargetFiles = skippingExistingTargetFiles;
    }

    public Boolean getSkippingHiddenFilesAndFolders() {
        return this.skippingHiddenFilesAndFolders;
    }

    public void setSkippingHiddenFilesAndFolders(Boolean skippingHiddenFilesAndFolders) {
        this.skippingHiddenFilesAndFolders = skippingHiddenFilesAndFolders;
    }

    public Boolean getSkippingFolders() {
        return this.skippingFolders;
    }

    public void setSkippingFolders(Boolean skippingFolders) {
        this.skippingFolders = skippingFolders;
    }

    public IHopImport getHopImport() {
        return this.hopImport;
    }

    public void setHopImport(IHopImport hopImport) {
        this.hopImport = hopImport;
    }

    public String getInputFolderName() {
        return this.inputFolderName;
    }

    public void setInputFolderName(String inputFolderName) {
        this.inputFolderName = inputFolderName;
    }

    public String getOutputFolderName() {
        return this.outputFolderName;
    }

    public void setOutputFolderName(String outputFolderName) {
        this.outputFolderName = outputFolderName;
    }

    public String getSharedXmlFilename() {
        return this.sharedXmlFilename;
    }

    public void setSharedXmlFilename(String sharedXmlFilename) {
        this.sharedXmlFilename = sharedXmlFilename;
    }

    public String getKettlePropertiesFilename() {
        return this.kettlePropertiesFilename;
    }

    public void setKettlePropertiesFilename(String kettlePropertiesFilename) {
        this.kettlePropertiesFilename = kettlePropertiesFilename;
    }

    public String getJdbcPropertiesFilename() {
        return this.jdbcPropertiesFilename;
    }

    public void setJdbcPropertiesFilename(String jdbcPropertiesFilename) {
        this.jdbcPropertiesFilename = jdbcPropertiesFilename;
    }

    public String getTargetConfigFilename() {
        return this.targetConfigFilename;
    }

    public void setTargetConfigFilename(String targetConfigFilename) {
        this.targetConfigFilename = targetConfigFilename;
    }

    public boolean isSkippingExistingTargetFiles() {
        return this.skippingExistingTargetFiles;
    }

    public void setSkippingExistingTargetFiles(boolean skippingExistingTargetFiles) {
        this.skippingExistingTargetFiles = skippingExistingTargetFiles;
    }

    public boolean isSkippingHiddenFilesAndFolders() {
        return this.skippingHiddenFilesAndFolders;
    }

    public void setSkippingHiddenFilesAndFolders(boolean skippingHiddenFilesAndFolders) {
        this.skippingHiddenFilesAndFolders = skippingHiddenFilesAndFolders;
    }

    public boolean isSkippingFolders() {
        return this.skippingFolders;
    }

    public void setSkippingFolders(boolean skippingFolders) {
        this.skippingFolders = skippingFolders;
    }

    public boolean isHelpRequested() {
        return this.helpRequested;
    }

    public void setHelpRequested(boolean helpRequested) {
        this.helpRequested = helpRequested;
    }

    public IVariables getVariables() {
        return this.variables;
    }

    public void setVariables(IVariables variables) {
        this.variables = variables;
    }

    public CommandLine getCmd() {
        return this.cmd;
    }

    public void setCmd(CommandLine cmd) {
        this.cmd = cmd;
    }

    public ILogChannel getLog() {
        return this.log;
    }

    public void setLog(ILogChannel log) {
        this.log = log;
    }

    public MultiMetadataProvider getMetadataProvider() {
        return this.hopImport.getMetadataProvider();
    }

    public void setMetadataProvider(MultiMetadataProvider metadataProvider) {
        this.hopImport.setMetadataProvider(metadataProvider);
    }

    public boolean isFinishedWithoutError() {
        return this.finishedWithoutError;
    }

    public void setFinishedWithoutError(boolean finishedWithoutError) {
        this.finishedWithoutError = finishedWithoutError;
    }

    public Boolean getListPluginTypes() {
        return this.listPluginTypes;
    }

    public void setListPluginTypes(Boolean listPluginTypes) {
        this.listPluginTypes = listPluginTypes;
    }

    public static void main(String[] args) {
        HopImport hopImport = new HopImport();
        try {
            CommandLine cmd = new CommandLine((Object)hopImport);
            HopEnvironment.init();
            hopImport.buildVariableSpace();
            List configPlugins = PluginRegistry.getInstance().getPlugins(ConfigPluginType.class);
            for (IPlugin configPlugin : configPlugins) {
                if (!"import".equals(configPlugin.getCategory())) continue;
                IConfigOptions configOptions = (IConfigOptions)PluginRegistry.getInstance().loadClass(configPlugin, IConfigOptions.class);
                cmd.addMixin(configPlugin.getIds()[0], (Object)configOptions);
            }
            hopImport.setCmd(cmd);
            CommandLine.ParseResult parseResult = cmd.parseArgs(args);
            if (CommandLine.printHelpIfRequested((CommandLine.ParseResult)parseResult)) {
                System.exit(1);
            } else {
                hopImport.run();
                if (hopImport != null && hopImport.isFinishedWithoutError()) {
                    System.exit(0);
                } else {
                    System.exit(1);
                }
            }
        }
        catch (CommandLine.ParameterException e) {
            System.err.println(e.getMessage());
            hopImport.cmd.usage(System.err);
            System.exit(9);
        }
        catch (CommandLine.ExecutionException e) {
            System.err.println("Error found during execution!");
            System.err.println(Const.getStackTracker((Throwable)e));
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("General error found, something went horribly wrong!");
            System.err.println(Const.getStackTracker((Throwable)e));
            System.exit(2);
        }
    }
}

