/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.history;

import java.io.Serializable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.deploy.history.EventLogFileReader;
import org.apache.spark.deploy.history.EventLogFileWriter$;
import org.apache.spark.deploy.history.RollingEventLogFilesWriter$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.NumericRange;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a!\u0002\n\u0014\u0001Mi\u0002\"\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0013,\u0011%i\u0003A!A!\u0002\u0013q\u0013\u0007C\u00034\u0001\u0011\u0005A\u0007\u0003\u00059\u0001!\u0015\r\u0011\"\u0003:\u0011!Y\u0005\u0001#b\u0001\n\u0013a\u0005\u0002C'\u0001\u0011\u000b\u0007I\u0011B\u001d\t\u000b9\u0003A\u0011I(\t\u000b]\u0003A\u0011\t-\t\u000be\u0003A\u0011\t.\t\u000by\u0003A\u0011I(\t\u000b}\u0003A\u0011\t-\t\u000b\u0001\u0004A\u0011I1\t\u000bE\u0004A\u0011I\u001d\t\u000bI\u0004A\u0011I:\t\u000bu\u0004A\u0011\t-\t\u000by\u0004A\u0011\u0002'\t\r}\u0004A\u0011BA\u0001\u0005y\u0011v\u000e\u001c7j]\u001e,e/\u001a8u\u0019><g)\u001b7fg\u001aKG.\u001a*fC\u0012,'O\u0003\u0002\u0015+\u00059\u0001.[:u_JL(B\u0001\f\u0018\u0003\u0019!W\r\u001d7ps*\u0011\u0001$G\u0001\u0006gB\f'o\u001b\u0006\u00035m\ta!\u00199bG\",'\"\u0001\u000f\u0002\u0007=\u0014xm\u0005\u0002\u0001=A\u0011q\u0004I\u0007\u0002'%\u0011\u0011e\u0005\u0002\u0013\u000bZ,g\u000e\u001e'pO\u001aKG.\u001a*fC\u0012,'/\u0001\u0002gg\u000e\u0001\u0001CA\u0013*\u001b\u00051#B\u0001\u0012(\u0015\tA\u0013$\u0001\u0004iC\u0012|w\u000e]\u0005\u0003U\u0019\u0012!BR5mKNK8\u000f^3n\u0013\ta\u0003%\u0001\u0006gS2,7+_:uK6\fA\u0001]1uQB\u0011QeL\u0005\u0003a\u0019\u0012A\u0001U1uQ&\u0011!\u0007I\u0001\te>|G\u000fU1uQ\u00061A(\u001b8jiz\"2!\u000e\u001c8!\ty\u0002\u0001C\u0003#\u0007\u0001\u0007A\u0005C\u0003.\u0007\u0001\u0007a&A\u0003gS2,7/F\u0001;!\rYT\t\u0013\b\u0003y\ts!!\u0010!\u000e\u0003yR!aP\u0012\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0015!B:dC2\f\u0017BA\"E\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011!Q\u0005\u0003\r\u001e\u00131aU3r\u0015\t\u0019E\t\u0005\u0002&\u0013&\u0011!J\n\u0002\u000b\r&dWm\u0015;biV\u001c\u0018!D1qaN#\u0018\r^;t\r&dW-F\u0001I\u00035)g/\u001a8u\u0019><g)\u001b7fg\u0006IA.Y:u\u0013:$W\r_\u000b\u0002!B\u0019\u0011K\u0015+\u000e\u0003\u0011K!a\u0015#\u0003\r=\u0003H/[8o!\t\tV+\u0003\u0002W\t\n!Aj\u001c8h\u0003Q1\u0017\u000e\\3TSj,gi\u001c:MCN$\u0018J\u001c3fqV\tA+A\u0005d_6\u0004H.\u001a;fIV\t1\f\u0005\u0002R9&\u0011Q\f\u0012\u0002\b\u0005>|G.Z1o\u0003i1\u0017\u000e\\3TSj,gi\u001c:MCN$\u0018J\u001c3fq\u001a{'\u000f\u0012$T\u0003Aiw\u000eZ5gS\u000e\fG/[8o)&lW-\u0001\t{SB,e/\u001a8u\u0019><g)\u001b7fgR\u0011!-\u001a\t\u0003#\u000eL!\u0001\u001a#\u0003\tUs\u0017\u000e\u001e\u0005\u0006M2\u0001\raZ\u0001\nu&\u00048\u000b\u001e:fC6\u0004\"\u0001[8\u000e\u0003%T!A[6\u0002\u0007iL\u0007O\u0003\u0002m[\u0006!Q\u000f^5m\u0015\u0005q\u0017\u0001\u00026bm\u0006L!\u0001]5\u0003\u001fiK\u0007oT;uaV$8\u000b\u001e:fC6\f\u0011\u0003\\5ti\u00163XM\u001c;M_\u001e4\u0015\u000e\\3t\u0003A\u0019w.\u001c9sKN\u001c\u0018n\u001c8D_\u0012,7-F\u0001u!\r\t&+\u001e\t\u0003mjt!a\u001e=\u0011\u0005u\"\u0015BA=E\u0003\u0019\u0001&/\u001a3fM&\u00111\u0010 \u0002\u0007'R\u0014\u0018N\\4\u000b\u0005e$\u0015!\u0003;pi\u0006d7+\u001b>f\u0003Aa\u0017m\u001d;Fm\u0016tG\u000fT8h\r&dW-A\ree>\u0004()\u001a4pe\u0016d\u0015m\u001d;D_6\u0004\u0018m\u0019;GS2,Gc\u0001\u001e\u0002\u0004!)Q*\u0005a\u0001u\u0001")
public class RollingEventLogFilesFileReader
extends EventLogFileReader {
    private Seq<FileStatus> files;
    private FileStatus appStatusFile;
    private Seq<FileStatus> eventLogFiles;
    private volatile byte bitmap$0;

    /*
     * WARNING - void declaration
     */
    private Seq<FileStatus> files$lzycompute() {
        RollingEventLogFilesFileReader rollingEventLogFilesFileReader = this;
        synchronized (rollingEventLogFilesFileReader) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_2;
                Seq ret = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])super.fileSystem().listStatus(this.rootPath()))).toSeq();
                Predef$.MODULE$.require(ret.exists((Function1 & Serializable & scala.Serializable)status -> BoxesRunTime.boxToBoolean((boolean)RollingEventLogFilesWriter$.MODULE$.isEventLogFile(status))), (Function0 & Serializable & scala.Serializable)() -> "Log directory must contain at least one event log file!");
                Predef$.MODULE$.require(ret.exists((Function1 & Serializable & scala.Serializable)status -> BoxesRunTime.boxToBoolean((boolean)RollingEventLogFilesWriter$.MODULE$.isAppStatusFile(status))), (Function0 & Serializable & scala.Serializable)() -> "Log directory must contain an appstatus file!");
                this.files = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.files;
    }

    private Seq<FileStatus> files() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.files$lzycompute() : this.files;
    }

    private FileStatus appStatusFile$lzycompute() {
        RollingEventLogFilesFileReader rollingEventLogFilesFileReader = this;
        synchronized (rollingEventLogFilesFileReader) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.appStatusFile = (FileStatus)this.files().find((Function1 & Serializable & scala.Serializable)status -> BoxesRunTime.boxToBoolean((boolean)RollingEventLogFilesWriter$.MODULE$.isAppStatusFile(status))).get();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.appStatusFile;
    }

    private FileStatus appStatusFile() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.appStatusFile$lzycompute() : this.appStatusFile;
    }

    /*
     * WARNING - void declaration
     */
    private Seq<FileStatus> eventLogFiles$lzycompute() {
        RollingEventLogFilesFileReader rollingEventLogFilesFileReader = this;
        synchronized (rollingEventLogFilesFileReader) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                void var3_3;
                Seq eventLogFiles = (Seq)((SeqLike)this.files().filter((Function1 & Serializable & scala.Serializable)status -> BoxesRunTime.boxToBoolean((boolean)RollingEventLogFilesWriter$.MODULE$.isEventLogFile(status)))).sortBy((Function1 & Serializable & scala.Serializable)status -> BoxesRunTime.boxToDouble((double)RollingEventLogFilesFileReader.$anonfun$eventLogFiles$2(status)), (Ordering)Ordering.Double$.MODULE$);
                Seq<FileStatus> filesToRead = this.dropBeforeLastCompactFile((Seq<FileStatus>)eventLogFiles);
                Seq indices = (Seq)filesToRead.map((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToLong((long)RollingEventLogFilesWriter$.MODULE$.getEventLogFileIndex(file.getPath().getName())), Seq$.MODULE$.canBuildFrom());
                NumericRange.Inclusive inclusive = new RichLong(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)indices.head()))).to(indices.last());
                Seq seq = indices;
                Predef$.MODULE$.require(!(inclusive != null ? !inclusive.equals(seq) : seq != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Found missing event log file, expected").append(" indices: ").append(new RichLong(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)indices.head()))).to(indices.last())).append(", actual: ").append(indices).toString());
                this.eventLogFiles = var3_3;
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.eventLogFiles;
    }

    private Seq<FileStatus> eventLogFiles() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.eventLogFiles$lzycompute() : this.eventLogFiles;
    }

    @Override
    public Option<Object> lastIndex() {
        return new Some((Object)BoxesRunTime.boxToLong((long)RollingEventLogFilesWriter$.MODULE$.getEventLogFileIndex(this.lastEventLogFile().getPath().getName())));
    }

    @Override
    public long fileSizeForLastIndex() {
        return this.lastEventLogFile().getLen();
    }

    @Override
    public boolean completed() {
        return !this.appStatusFile().getPath().getName().endsWith(EventLogFileWriter$.MODULE$.IN_PROGRESS());
    }

    @Override
    public Option<Object> fileSizeForLastIndexForDFS() {
        return this.completed() ? new Some((Object)BoxesRunTime.boxToLong((long)this.fileSizeForLastIndex())) : this.fileSizeForDFS(this.lastEventLogFile().getPath());
    }

    @Override
    public long modificationTime() {
        return this.lastEventLogFile().getModificationTime();
    }

    @Override
    public void zipEventLogFiles(ZipOutputStream zipStream) {
        String dirEntryName = new StringBuilder(1).append(this.rootPath().getName()).append("/").toString();
        zipStream.putNextEntry(new ZipEntry(dirEntryName));
        this.files().foreach((Function1 & Serializable & scala.Serializable)file -> {
            this.addFileAsZipEntry(zipStream, file.getPath(), new StringBuilder(0).append(dirEntryName).append(file.getPath().getName()).toString());
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Seq<FileStatus> listEventLogFiles() {
        return this.eventLogFiles();
    }

    @Override
    public Option<String> compressionCodec() {
        return EventLogFileWriter$.MODULE$.codecName(((FileStatus)this.eventLogFiles().head()).getPath());
    }

    @Override
    public long totalSize() {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.eventLogFiles().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.getLen()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    private FileStatus lastEventLogFile() {
        return (FileStatus)this.eventLogFiles().last();
    }

    private Seq<FileStatus> dropBeforeLastCompactFile(Seq<FileStatus> eventLogFiles) {
        int lastCompactedFileIdx = eventLogFiles.lastIndexWhere((Function1 & Serializable & scala.Serializable)fs -> BoxesRunTime.boxToBoolean((boolean)EventLogFileWriter$.MODULE$.isCompacted(fs.getPath())));
        return (Seq)eventLogFiles.drop(lastCompactedFileIdx);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ double $anonfun$eventLogFiles$2(FileStatus status) {
        void var2_2;
        block0: {
            Path filePath = status.getPath();
            double idx = RollingEventLogFilesWriter$.MODULE$.getEventLogFileIndex(filePath.getName());
            if (!EventLogFileWriter$.MODULE$.isCompacted(filePath)) break block0;
            idx += 0.1;
        }
        return (double)var2_2;
    }

    public RollingEventLogFilesFileReader(FileSystem fs, Path path) {
        super(fs, path);
    }
}

