/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.test;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.beam.vendor.grpc.v1p48p1.io.grpc.stub.CallStreamObserver;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class TestStreams {
    public static <T> @UnknownKeyFor @NonNull @Initialized Builder<T> withOnNext(@UnknownKeyFor @NonNull @Initialized Consumer<T> onNext) {
        return new Builder(new ForwardingCallStreamObserver<T>(onNext, TestStreams.throwingErrorHandler(), TestStreams.noopRunnable(), TestStreams.alwaysTrueSupplier()));
    }

    private static @UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized Throwable> throwingErrorHandler() {
        return item -> {
            throw new RuntimeException((Throwable)item);
        };
    }

    private static @UnknownKeyFor @NonNull @Initialized Runnable noopRunnable() {
        return () -> {};
    }

    private static @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Boolean> alwaysTrueSupplier() {
        return () -> true;
    }

    private static class ForwardingCallStreamObserver<@UnknownKeyFor T>
    extends CallStreamObserver<T> {
        private final @UnknownKeyFor @NonNull @Initialized Consumer<T> onNext;
        private final @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Boolean> isReady;
        private final @UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized Throwable> onError;
        private final @UnknownKeyFor @NonNull @Initialized Runnable onCompleted;

        public ForwardingCallStreamObserver(@UnknownKeyFor @NonNull @Initialized Consumer<T> onNext, @UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized Throwable> onError, @UnknownKeyFor @NonNull @Initialized Runnable onCompleted, @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Boolean> isReady) {
            this.onNext = onNext;
            this.onError = onError;
            this.onCompleted = onCompleted;
            this.isReady = isReady;
        }

        public void onNext(T value) {
            this.onNext.accept(value);
        }

        public void onError(@UnknownKeyFor @NonNull @Initialized Throwable t) {
            this.onError.accept(t);
        }

        public void onCompleted() {
            this.onCompleted.run();
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isReady() {
            return this.isReady.get();
        }

        public void setOnReadyHandler(@UnknownKeyFor @NonNull @Initialized Runnable onReadyHandler) {
        }

        public void disableAutoInboundFlowControl() {
        }

        public void request(@UnknownKeyFor @NonNull @Initialized int count) {
        }

        public void setMessageCompression(@UnknownKeyFor @NonNull @Initialized boolean enable) {
        }
    }

    public static class Builder<@UnknownKeyFor T> {
        private final @UnknownKeyFor @NonNull @Initialized ForwardingCallStreamObserver<T> observer;

        private Builder(@UnknownKeyFor @NonNull @Initialized ForwardingCallStreamObserver<T> observer) {
            this.observer = observer;
        }

        public @UnknownKeyFor @NonNull @Initialized Builder<T> withIsReady(@UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized Boolean> isReady) {
            return new Builder(new ForwardingCallStreamObserver(((ForwardingCallStreamObserver)this.observer).onNext, ((ForwardingCallStreamObserver)this.observer).onError, ((ForwardingCallStreamObserver)this.observer).onCompleted, isReady));
        }

        public @UnknownKeyFor @NonNull @Initialized Builder<T> withOnCompleted(@UnknownKeyFor @NonNull @Initialized Runnable onCompleted) {
            return new Builder(new ForwardingCallStreamObserver(((ForwardingCallStreamObserver)this.observer).onNext, ((ForwardingCallStreamObserver)this.observer).onError, onCompleted, ((ForwardingCallStreamObserver)this.observer).isReady));
        }

        public @UnknownKeyFor @NonNull @Initialized Builder<T> withOnError(@UnknownKeyFor @NonNull @Initialized Runnable onError) {
            return new Builder(new ForwardingCallStreamObserver(((ForwardingCallStreamObserver)this.observer).onNext, t -> onError.run(), ((ForwardingCallStreamObserver)this.observer).onCompleted, ((ForwardingCallStreamObserver)this.observer).isReady));
        }

        public @UnknownKeyFor @NonNull @Initialized Builder<T> withOnError(@UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized Throwable> onError) {
            return new Builder(new ForwardingCallStreamObserver(((ForwardingCallStreamObserver)this.observer).onNext, onError, ((ForwardingCallStreamObserver)this.observer).onCompleted, ((ForwardingCallStreamObserver)this.observer).isReady));
        }

        public @UnknownKeyFor @NonNull @Initialized CallStreamObserver<T> build() {
            return this.observer;
        }
    }
}

