/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn;

import org.apache.beam.sdk.harness.JvmInitializer;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JvmInitializers {
    public static void runOnStartup() {
        for (JvmInitializer initializer : ReflectHelpers.loadServicesOrdered(JvmInitializer.class)) {
            System.out.format("Running JvmInitializer#onStartup for %s%n", initializer);
            initializer.onStartup();
        }
    }

    public static void runBeforeProcessing(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        Logger logger = LoggerFactory.getLogger(JvmInitializers.class);
        for (JvmInitializer initializer : ReflectHelpers.loadServicesOrdered(JvmInitializer.class)) {
            logger.info("Running JvmInitializer#beforeProcessing for {}", (Object)initializer);
            initializer.beforeProcessing(options);
        }
    }
}

