/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerUtil;
import org.apache.flink.api.common.typeutils.NestedSerializersSnapshotDelegate;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.GenericArraySerializer;
import org.apache.flink.api.common.typeutils.base.GenericArraySerializerSnapshot;
import org.apache.flink.api.java.typeutils.runtime.DataInputViewStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;

@Deprecated
@Internal
public final class GenericArraySerializerConfigSnapshot<C>
implements TypeSerializerSnapshot<C[]> {
    private static final int CURRENT_VERSION = 2;
    @Nullable
    private Class<C> componentClass;
    @Nullable
    private NestedSerializersSnapshotDelegate nestedSnapshot;

    public GenericArraySerializerConfigSnapshot() {
    }

    public GenericArraySerializerConfigSnapshot(GenericArraySerializer<C> serializer) {
        this.componentClass = serializer.getComponentClass();
        this.nestedSnapshot = new NestedSerializersSnapshotDelegate(serializer.getComponentSerializer());
    }

    @Override
    public int getCurrentVersion() {
        return 2;
    }

    @Override
    public void writeSnapshot(DataOutputView out) throws IOException {
        Preconditions.checkState(this.componentClass != null && this.nestedSnapshot != null);
        out.writeUTF(this.componentClass.getName());
        this.nestedSnapshot.writeNestedSerializerSnapshots(out);
    }

    @Override
    public void readSnapshot(int readVersion, DataInputView in, ClassLoader classLoader) throws IOException {
        switch (readVersion) {
            case 1: {
                this.readV1(in, classLoader);
                break;
            }
            case 2: {
                this.readV2(in, classLoader);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized version: " + readVersion);
            }
        }
    }

    private void readV1(DataInputView in, ClassLoader classLoader) throws IOException {
        this.nestedSnapshot = NestedSerializersSnapshotDelegate.legacyReadNestedSerializerSnapshots(in, classLoader);
        try (DataInputViewStream inViewWrapper = new DataInputViewStream(in);){
            this.componentClass = (Class)InstantiationUtil.deserializeObject(inViewWrapper, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Could not find requested element class in classpath.", e);
        }
    }

    private void readV2(DataInputView in, ClassLoader classLoader) throws IOException {
        this.componentClass = InstantiationUtil.resolveClassByName(in, classLoader);
        this.nestedSnapshot = NestedSerializersSnapshotDelegate.readNestedSerializerSnapshots(in, classLoader);
    }

    @Override
    public GenericArraySerializer<C> restoreSerializer() {
        Preconditions.checkState(this.componentClass != null && this.nestedSnapshot != null);
        return new GenericArraySerializer<C>(this.componentClass, this.nestedSnapshot.getRestoredNestedSerializer(0));
    }

    @Override
    public TypeSerializerSchemaCompatibility<C[]> resolveSchemaCompatibility(TypeSerializer<C[]> newSerializer) {
        Preconditions.checkState(this.nestedSnapshot != null);
        if (!(newSerializer instanceof GenericArraySerializer)) {
            return TypeSerializerSchemaCompatibility.incompatible();
        }
        return CompositeTypeSerializerUtil.delegateCompatibilityCheckToNewSnapshot(newSerializer, new GenericArraySerializerSnapshot<C>(this.componentClass), this.nestedSnapshot.getNestedSerializerSnapshots());
    }
}

