/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.logging;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hop.core.Const;
import org.apache.hop.core.logging.BufferLine;
import org.apache.hop.core.logging.HopLogLayout;
import org.apache.hop.core.logging.HopLoggingEvent;
import org.apache.hop.core.logging.IHopLoggingEventListener;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogMessage;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.logging.LoggingRegistry;

public class LoggingBuffer {
    private String name;
    private List<BufferLine> buffer;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private int bufferSize;
    private HopLogLayout layout;
    private List<IHopLoggingEventListener> eventListeners;
    private LoggingRegistry loggingRegistry = LoggingRegistry.getInstance();

    public LoggingBuffer(int bufferSize) {
        this.bufferSize = bufferSize;
        this.buffer = new ArrayList<BufferLine>((int)((double)bufferSize * 1.1));
        this.layout = new HopLogLayout(true);
        this.eventListeners = new CopyOnWriteArrayList<IHopLoggingEventListener>();
    }

    public int getLastBufferLineNr() {
        this.lock.readLock().lock();
        try {
            if (this.buffer.size() > 0) {
                int n = this.buffer.get(this.buffer.size() - 1).getNr();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HopLoggingEvent> getLogBufferFromTo(List<String> channelId, boolean includeGeneral, int from, int to) {
        this.lock.readLock().lock();
        try {
            Stream<BufferLine> bufferStream = this.buffer.stream().filter(line -> line.getNr() > from && line.getNr() <= to);
            if (channelId != null) {
                bufferStream = bufferStream.filter(line -> {
                    String logChannelId = LoggingBuffer.getLogChId(line);
                    return includeGeneral ? this.isGeneral(logChannelId) || channelId.contains(logChannelId) : channelId.contains(logChannelId);
                });
            }
            List<HopLoggingEvent> list = bufferStream.map(BufferLine::getEvent).collect(Collectors.toList());
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<HopLoggingEvent> getLogBufferFromTo(String parentLogChannelId, boolean includeGeneral, int from, int to) {
        List<String> childIds = this.loggingRegistry.getLogChannelChildren(parentLogChannelId);
        return this.getLogBufferFromTo(childIds, includeGeneral, from, to);
    }

    public StringBuffer getBuffer(String parentLogChannelId, boolean includeGeneral, int startLineNr, int endLineNr) {
        StringBuilder eventBuffer = new StringBuilder(10000);
        List<HopLoggingEvent> events = this.getLogBufferFromTo(parentLogChannelId, includeGeneral, startLineNr, endLineNr);
        for (HopLoggingEvent event : events) {
            eventBuffer.append(this.layout.format(event)).append(Const.CR);
        }
        return new StringBuffer(eventBuffer);
    }

    public StringBuffer getBuffer(String parentLogChannelId, boolean includeGeneral) {
        return this.getBuffer(parentLogChannelId, includeGeneral, 0);
    }

    public StringBuffer getBuffer(String parentLogChannelId, boolean includeGeneral, int startLineNr) {
        return this.getBuffer(parentLogChannelId, includeGeneral, startLineNr, this.getLastBufferLineNr());
    }

    public StringBuffer getBuffer() {
        return this.getBuffer(null, true);
    }

    public void close() {
    }

    public void doAppend(HopLoggingEvent event) {
        if (event.getMessage() instanceof LogMessage) {
            this.lock.writeLock().lock();
            try {
                this.buffer.add(new BufferLine(event));
                while (this.bufferSize > 0 && this.buffer.size() > this.bufferSize) {
                    this.buffer.remove(0);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setLayout(HopLogLayout layout) {
        this.layout = layout;
    }

    public HopLogLayout getLayout() {
        return this.layout;
    }

    public boolean requiresLayout() {
        return true;
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.buffer.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public int getMaxNrLines() {
        return this.bufferSize;
    }

    public void setMaxNrLines(int maxNrLines) {
        this.bufferSize = maxNrLines;
    }

    public int getNrLines() {
        return this.buffer.size();
    }

    public void removeChannelFromBuffer(String id) {
        this.lock.writeLock().lock();
        try {
            this.buffer.removeIf(line -> id.equals(LoggingBuffer.getLogChId(line)));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public int size() {
        return this.buffer.size();
    }

    public void removeGeneralMessages() {
        this.lock.writeLock().lock();
        try {
            this.buffer.removeIf(line -> this.isGeneral(LoggingBuffer.getLogChId(line)));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBufferLinesBefore(long minTimeBoundary) {
        HashSet<BufferLine> linesToRemove = new HashSet<BufferLine>();
        this.lock.writeLock().lock();
        try {
            for (BufferLine bufferLine : this.buffer) {
                if (bufferLine.getEvent().timeStamp >= minTimeBoundary) break;
                linesToRemove.add(bufferLine);
            }
            this.buffer.removeAll(linesToRemove);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void addLogggingEvent(HopLoggingEvent loggingEvent) {
        this.doAppend(loggingEvent);
        this.eventListeners.forEach(event -> event.eventAdded(loggingEvent));
    }

    public void addLoggingEventListener(IHopLoggingEventListener listener) {
        this.eventListeners.add(listener);
    }

    public void removeLoggingEventListener(IHopLoggingEventListener listener) {
        this.eventListeners.remove(listener);
    }

    private boolean isGeneral(String logChannelId) {
        ILoggingObject loggingObject = this.loggingRegistry.getLoggingObject(logChannelId);
        return loggingObject != null && LoggingObjectType.GENERAL.equals((Object)loggingObject.getObjectType());
    }

    private static String getLogChId(BufferLine bufferLine) {
        return ((LogMessage)bufferLine.getEvent().getMessage()).getLogChannelId();
    }
}

