/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import java.io.Serializable;
import java.util.Map;
import org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.runners.dataflow.util.CloudObject;
import org.apache.beam.runners.dataflow.util.CloudObjectTranslator;
import org.apache.beam.runners.dataflow.util.Structs;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class SerializableCoderCloudObjectTranslator
implements CloudObjectTranslator<SerializableCoder> {
    private static final @UnknownKeyFor @NonNull @Initialized String TYPE_FIELD = "type";

    SerializableCoderCloudObjectTranslator() {
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized CloudObject toCloudObject(@UnknownKeyFor @NonNull @Initialized SerializableCoder target, @UnknownKeyFor @NonNull @Initialized SdkComponents sdkComponents) {
        CloudObject base = CloudObject.forClass(SerializableCoder.class);
        Structs.addString((Map<String, Object>)((Object)base), TYPE_FIELD, target.getRecordType().getName());
        return base;
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SerializableCoder<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> fromCloudObject(@UnknownKeyFor @NonNull @Initialized CloudObject cloudObject) {
        String className = Structs.getString((Map<String, Object>)((Object)cloudObject), TYPE_FIELD);
        try {
            Class<?> targetClass = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
            Preconditions.checkArgument((boolean)Serializable.class.isAssignableFrom(targetClass), (String)"Target class %s does not extend %s", (Object)targetClass.getName(), (Object)Serializable.class.getSimpleName());
            return SerializableCoder.of(targetClass);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized SerializableCoder> getSupportedClass() {
        return SerializableCoder.class;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String cloudObjectClassName() {
        return CloudObject.forClass(SerializableCoder.class).getClassName();
    }
}

