/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.beam.sdk.util.ReleaseInfo;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataflowRunnerInfo
extends ReleaseInfo {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(DataflowRunnerInfo.class);
    private static final @UnknownKeyFor @NonNull @Initialized String APACHE_BEAM_DISTRIBUTION_PROPERTIES_PATH = "/org/apache/beam/runners/dataflow/dataflow.properties";
    private static final @UnknownKeyFor @NonNull @Initialized String FNAPI_ENVIRONMENT_MAJOR_VERSION_KEY = "fnapi.environment.major.version";
    private static final @UnknownKeyFor @NonNull @Initialized String LEGACY_ENVIRONMENT_MAJOR_VERSION_KEY = "legacy.environment.major.version";
    private static final @UnknownKeyFor @NonNull @Initialized String CONTAINER_FNAPI_VERSION_KEY = "fnapi.container.version";
    private static final @UnknownKeyFor @NonNull @Initialized String CONTAINER_LEGACY_VERSION_KEY = "legacy.container.version";
    private static final @UnknownKeyFor @NonNull @Initialized String CONTAINER_BASE_REPOSITORY_KEY = "container.base_repository";
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> properties;

    public static @UnknownKeyFor @NonNull @Initialized DataflowRunnerInfo getDataflowRunnerInfo() {
        return LazyInit.INSTANCE;
    }

    public @UnknownKeyFor @NonNull @Initialized String getLegacyEnvironmentMajorVersion() {
        Preconditions.checkState((boolean)this.properties.containsKey(LEGACY_ENVIRONMENT_MAJOR_VERSION_KEY), (Object)"Unknown legacy environment major version");
        return this.properties.get(LEGACY_ENVIRONMENT_MAJOR_VERSION_KEY);
    }

    public @UnknownKeyFor @NonNull @Initialized String getFnApiEnvironmentMajorVersion() {
        Preconditions.checkState((boolean)this.properties.containsKey(FNAPI_ENVIRONMENT_MAJOR_VERSION_KEY), (Object)"Unknown FnAPI environment major version");
        return this.properties.get(FNAPI_ENVIRONMENT_MAJOR_VERSION_KEY);
    }

    public @UnknownKeyFor @NonNull @Initialized String getFnApiDevContainerVersion() {
        Preconditions.checkState((boolean)this.properties.containsKey(CONTAINER_FNAPI_VERSION_KEY), (Object)"Unknown FnAPI container version");
        return this.properties.get(CONTAINER_FNAPI_VERSION_KEY);
    }

    public @UnknownKeyFor @NonNull @Initialized String getLegacyDevContainerVersion() {
        Preconditions.checkState((boolean)this.properties.containsKey(CONTAINER_LEGACY_VERSION_KEY), (Object)"Unknown legacy container version");
        return this.properties.get(CONTAINER_LEGACY_VERSION_KEY);
    }

    public @UnknownKeyFor @NonNull @Initialized String getContainerImageBaseRepository() {
        Preconditions.checkState((boolean)this.properties.containsKey(CONTAINER_BASE_REPOSITORY_KEY), (Object)"Unknown container base repository");
        return this.properties.get(CONTAINER_BASE_REPOSITORY_KEY);
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getProperties() {
        return ImmutableMap.copyOf(this.properties);
    }

    private DataflowRunnerInfo(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> properties) {
        this.properties = properties;
    }

    private static @UnknownKeyFor @NonNull @Initialized Properties load(@UnknownKeyFor @NonNull @Initialized String path) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Properties properties = new Properties();
        try (InputStream in = DataflowRunnerInfo.class.getResourceAsStream(path);){
            if (in == null) {
                Properties properties2 = null;
                return properties2;
            }
            properties.load(in);
        }
        return properties;
    }

    private static void copyFromSystemProperties(@UnknownKeyFor @NonNull @Initialized String property, @UnknownKeyFor @NonNull @Initialized Properties properties) {
        String value = System.getProperty(property);
        if (value != null) {
            properties.setProperty(property, value);
        }
    }

    private static class LazyInit {
        private static final @UnknownKeyFor @NonNull @Initialized DataflowRunnerInfo INSTANCE;

        private LazyInit() {
        }

        static {
            Properties properties;
            try {
                properties = DataflowRunnerInfo.load(DataflowRunnerInfo.APACHE_BEAM_DISTRIBUTION_PROPERTIES_PATH);
                if (properties == null) {
                    LOG.warn("Dataflow runner properties resource not found.");
                    properties = new Properties();
                }
            }
            catch (IOException e) {
                LOG.warn("Error loading Dataflow runner properties resource: ", (Throwable)e);
                properties = new Properties();
            }
            if (!properties.containsKey("name")) {
                properties.setProperty("name", ReleaseInfo.getReleaseInfo().getName());
            }
            if (!properties.containsKey("version")) {
                properties.setProperty("version", ReleaseInfo.getReleaseInfo().getVersion());
            }
            DataflowRunnerInfo.copyFromSystemProperties("java.vendor", properties);
            DataflowRunnerInfo.copyFromSystemProperties("java.version", properties);
            DataflowRunnerInfo.copyFromSystemProperties("os.arch", properties);
            DataflowRunnerInfo.copyFromSystemProperties("os.name", properties);
            DataflowRunnerInfo.copyFromSystemProperties("os.version", properties);
            INSTANCE = new DataflowRunnerInfo((Map)ImmutableMap.copyOf((Map)properties));
        }
    }
}

