/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.auth.Credentials;
import com.google.cloud.hadoop.gcsio.MetricsRecorder;
import com.google.cloud.hadoop.gcsio.NoOpMetricsRecorder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.flogger.GoogleLogger;
import io.opencensus.common.Duration;
import io.opencensus.common.Scope;
import io.opencensus.contrib.grpc.metrics.RpcViews;
import io.opencensus.exporter.stats.stackdriver.StackdriverStatsConfiguration;
import io.opencensus.exporter.stats.stackdriver.StackdriverStatsExporter;
import io.opencensus.stats.Aggregation;
import io.opencensus.stats.BucketBoundaries;
import io.opencensus.stats.Measure;
import io.opencensus.stats.Stats;
import io.opencensus.stats.StatsRecorder;
import io.opencensus.stats.View;
import io.opencensus.stats.ViewManager;
import io.opencensus.tags.TagContext;
import io.opencensus.tags.TagContextBuilder;
import io.opencensus.tags.TagKey;
import io.opencensus.tags.TagMetadata;
import io.opencensus.tags.TagValue;
import io.opencensus.tags.Tagger;
import io.opencensus.tags.Tags;
import java.io.IOException;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;

class CloudMonitoringMetricsRecorder
implements MetricsRecorder {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    @VisibleForTesting
    static final Object monitor = new Object();
    private static final int EXPORT_INTERVAL = 5000;
    @GuardedBy(value="monitor")
    private static boolean initialized = false;
    private static final TagMetadata TAG_METADATA_NO_PROPAGATION = TagMetadata.create((TagMetadata.TagTtl)TagMetadata.TagTtl.NO_PROPAGATION);
    static final String MS = "ms";
    static final String BY = "By";
    static final Measure.MeasureLong LATENCY_MS = Measure.MeasureLong.create((String)"gcsio/latency", (String)"The latency in milliseconds ", (String)"ms");
    static final Measure.MeasureLong MESSAGE_LATENCY_MS = Measure.MeasureLong.create((String)"gcsio/message/latency", (String)"The latency in milliseconds per gcs message loop", (String)"ms");
    static final Measure.MeasureLong REQUESTS = Measure.MeasureLong.create((String)"gcsio/requests", (String)"The distribution of retry attempts for gcs calls", (String)"By");
    static final Measure.MeasureLong REQUEST_RETRIES = Measure.MeasureLong.create((String)"gcsio/retries", (String)"The distribution of retry attempts for gcs calls", (String)"By");
    static final TagKey METHOD = TagKey.create((String)"method");
    static final TagKey STATUS = TagKey.create((String)"status");
    static final TagKey ERROR = TagKey.create((String)"error");
    static final TagKey THREAD = TagKey.create((String)"thread");
    static final TagKey PROTOCOL = TagKey.create((String)"protocol");
    static final List<TagKey> TAG_KEYS = ImmutableList.of((Object)METHOD, (Object)STATUS, (Object)ERROR, (Object)THREAD, (Object)PROTOCOL);
    static final List<Double> RPC_MILLIS_BUCKET_BOUNDARIES = ImmutableList.of((Object)0.0, (Object)0.01, (Object)0.05, (Object)0.1, (Object)0.3, (Object)0.6, (Object)0.8, (Object)1.0, (Object)2.0, (Object)3.0, (Object)4.0, (Object)5.0, (Object[])new Double[]{6.0, 8.0, 10.0, 13.0, 16.0, 20.0, 25.0, 30.0, 40.0, 50.0, 65.0, 80.0, 100.0, 130.0, 160.0, 200.0, 250.0, 300.0, 400.0, 500.0, 650.0, 800.0, 1000.0, 2000.0, 5000.0, 10000.0, 20000.0, 50000.0, 100000.0});
    static final Aggregation AGGREGATION_WITH_MILLIS_HISTOGRAM = Aggregation.Distribution.create((BucketBoundaries)BucketBoundaries.create(RPC_MILLIS_BUCKET_BOUNDARIES));
    static final Aggregation COUNT = Aggregation.Count.create();
    private static final Tagger tagger = Tags.getTagger();
    private static final StatsRecorder statsRecorder = Stats.getStatsRecorder();

    CloudMonitoringMetricsRecorder() {
    }

    public static MetricsRecorder create(String projectId, Credentials credentials) {
        try {
            CloudMonitoringMetricsRecorder.registerAllViews();
            CloudMonitoringMetricsRecorder.setupCloudMonitoringExporter(projectId, credentials);
        }
        catch (Exception e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause((Throwable)e)).log("Exception while registering metrics publisher");
            return new NoOpMetricsRecorder();
        }
        return new CloudMonitoringMetricsRecorder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setupCloudMonitoringExporter(String projectId, Credentials credentials) throws IOException {
        Object object = monitor;
        synchronized (object) {
            if (!initialized) {
                StackdriverStatsExporter.createAndRegister((StackdriverStatsConfiguration)StackdriverStatsConfiguration.builder().setCredentials(credentials).setProjectId(projectId).setExportInterval(Duration.fromMillis((long)5000L)).build());
                Runtime.getRuntime().addShutdownHook(new Thread(StackdriverStatsExporter::unregister));
                initialized = true;
            }
        }
    }

    private static void registerAllViews() {
        View[] views = new View[]{View.create((View.Name)View.Name.create((String)"gcsio/latency"), (String)"The distribution of latencies for a  method", (Measure)LATENCY_MS, (Aggregation)AGGREGATION_WITH_MILLIS_HISTOGRAM, TAG_KEYS), View.create((View.Name)View.Name.create((String)"gcsio/message/latency"), (String)"The distribution of latencies at a message level in a streaming context", (Measure)MESSAGE_LATENCY_MS, (Aggregation)AGGREGATION_WITH_MILLIS_HISTOGRAM, TAG_KEYS), View.create((View.Name)View.Name.create((String)"gcsio/retries"), (String)"The distribution of retry attempts for a method", (Measure)REQUEST_RETRIES, (Aggregation)COUNT, TAG_KEYS), View.create((View.Name)View.Name.create((String)"gcsio/requests"), (String)"The distribution of request counts for a method", (Measure)REQUESTS, (Aggregation)COUNT, TAG_KEYS)};
        ViewManager viewManager = Stats.getViewManager();
        for (View view : views) {
            viewManager.registerView(view);
        }
        RpcViews.registerAllGrpcViews();
        RpcViews.registerRealTimeMetricsViews();
    }

    @Override
    public void recordTaggedStat(TagKey key, String value, Measure.MeasureLong ml, Long n) {
        TagContext tagContext = tagger.emptyBuilder().put(THREAD, TagValue.create((String)String.valueOf(Thread.currentThread().getId())), TAG_METADATA_NO_PROPAGATION).put(key, TagValue.create((String)value), TAG_METADATA_NO_PROPAGATION).build();
        try (Scope ignored = tagger.withTagContext(tagContext);){
            statsRecorder.newMeasureMap().put(ml, n.longValue()).record();
        }
    }

    @Override
    public void recordLong(TagKey[] keys, String[] values, Measure.MeasureLong ml, Long n) {
        TagContextBuilder builder = tagger.emptyBuilder();
        for (int i = 0; i < keys.length; ++i) {
            builder.put(keys[i], TagValue.create((String)values[i]), TAG_METADATA_NO_PROPAGATION);
        }
        builder.put(THREAD, TagValue.create((String)String.valueOf(Thread.currentThread().getId())), TAG_METADATA_NO_PROPAGATION);
        TagContext tagContext = builder.build();
        try (Scope ignored = tagger.withTagContext(tagContext);){
            statsRecorder.newMeasureMap().put(ml, n.longValue()).record();
        }
    }
}

