/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.cli;

import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.flink.annotation.Internal;
import org.apache.flink.client.cli.CustomCommandLine;
import org.apache.flink.client.cli.DynamicPropertiesUtil;
import org.apache.flink.client.deployment.DefaultClusterClientServiceLoader;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.DeploymentOptionsInternal;
import org.apache.flink.configuration.UnmodifiableConfiguration;
import org.apache.flink.core.execution.DefaultExecutorServiceLoader;
import org.apache.flink.util.Preconditions;

@Internal
public class GenericCLI
implements CustomCommandLine {
    private static final String ID = "Generic CLI";
    private final Option executorOption = new Option("e", "executor", true, "DEPRECATED: Please use the -t option instead which is also available with the \"Application Mode\".\nThe name of the executor to be used for executing the given job, which is equivalent to the \"" + DeploymentOptions.TARGET.key() + "\" config option. The currently available executors are: " + GenericCLI.getExecutorFactoryNames() + ".");
    private final Option targetOption = new Option("t", "target", true, "The deployment target for the given application, which is equivalent to the \"" + DeploymentOptions.TARGET.key() + "\" config option. For the \"run\" action the currently available targets are: " + GenericCLI.getExecutorFactoryNames() + ". For the \"run-application\" action the currently available targets are: " + GenericCLI.getApplicationModeTargetNames() + ".");
    private final Configuration configuration;
    private final String configurationDir;

    public GenericCLI(Configuration configuration, String configDir) {
        this.configuration = new UnmodifiableConfiguration((Configuration)Preconditions.checkNotNull((Object)configuration));
        this.configurationDir = (String)Preconditions.checkNotNull((Object)configDir);
    }

    @Override
    public boolean isActive(CommandLine commandLine) {
        return this.configuration.getOptional(DeploymentOptions.TARGET).isPresent() || commandLine.hasOption(this.executorOption.getOpt()) || commandLine.hasOption(this.targetOption.getOpt());
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void addRunOptions(Options baseOptions) {
    }

    @Override
    public void addGeneralOptions(Options baseOptions) {
        baseOptions.addOption(this.executorOption);
        baseOptions.addOption(this.targetOption);
        baseOptions.addOption(DynamicPropertiesUtil.DYNAMIC_PROPERTIES);
    }

    @Override
    public Configuration toConfiguration(CommandLine commandLine) {
        String targetName;
        Configuration resultConfiguration = new Configuration();
        String executorName = commandLine.getOptionValue(this.executorOption.getOpt());
        if (executorName != null) {
            resultConfiguration.setString(DeploymentOptions.TARGET, executorName);
        }
        if ((targetName = commandLine.getOptionValue(this.targetOption.getOpt())) != null) {
            resultConfiguration.setString(DeploymentOptions.TARGET, targetName);
        }
        DynamicPropertiesUtil.encodeDynamicProperties(commandLine, resultConfiguration);
        resultConfiguration.set(DeploymentOptionsInternal.CONF_DIR, (Object)this.configurationDir);
        return resultConfiguration;
    }

    private static String getExecutorFactoryNames() {
        return new DefaultExecutorServiceLoader().getExecutorNames().map(name -> String.format("\"%s\"", name)).map(name -> GenericCLI.addDeprecationNoticeToYarnPerJobMode(name)).collect(Collectors.joining(", "));
    }

    private static String addDeprecationNoticeToYarnPerJobMode(String name) {
        if (name.contains("yarn-per-job")) {
            return name + " (deprecated)";
        }
        return name;
    }

    private static String getApplicationModeTargetNames() {
        return new DefaultClusterClientServiceLoader().getApplicationModeTargetNames().map(name -> String.format("\"%s\"", name)).collect(Collectors.joining(", "));
    }
}

