/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

class LegalHoldsPolicyUpdateArg {
    protected final String id;
    protected final String name;
    protected final String description;
    protected final List<String> members;

    public LegalHoldsPolicyUpdateArg(String id, String name, String description, List<String> members) {
        if (id == null) {
            throw new IllegalArgumentException("Required value for 'id' is null");
        }
        if (!Pattern.matches("^pid_dbhid:.+", id)) {
            throw new IllegalArgumentException("String 'id' does not match pattern");
        }
        this.id = id;
        if (name != null && name.length() > 140) {
            throw new IllegalArgumentException("String 'name' is longer than 140");
        }
        this.name = name;
        if (description != null && description.length() > 501) {
            throw new IllegalArgumentException("String 'description' is longer than 501");
        }
        this.description = description;
        if (members != null) {
            for (String x : members) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'members' is null");
            }
        }
        this.members = members;
    }

    public LegalHoldsPolicyUpdateArg(String id) {
        this(id, null, null, null);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getMembers() {
        return this.members;
    }

    public static Builder newBuilder(String id) {
        return new Builder(id);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.id, this.name, this.description, this.members});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            LegalHoldsPolicyUpdateArg other = (LegalHoldsPolicyUpdateArg)obj;
            return (this.id == other.id || this.id.equals(other.id)) && (this.name == other.name || this.name != null && this.name.equals(other.name)) && (this.description == other.description || this.description != null && this.description.equals(other.description)) && (this.members == other.members || this.members != null && this.members.equals(other.members));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<LegalHoldsPolicyUpdateArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(LegalHoldsPolicyUpdateArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("id");
            StoneSerializers.string().serialize(value.id, g);
            if (value.name != null) {
                g.writeFieldName("name");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.name, g);
            }
            if (value.description != null) {
                g.writeFieldName("description");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.description, g);
            }
            if (value.members != null) {
                g.writeFieldName("members");
                StoneSerializers.nullable(StoneSerializers.list(StoneSerializers.string())).serialize(value.members, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public LegalHoldsPolicyUpdateArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            List<String> f_members;
            String f_description;
            String f_name;
            String f_id;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_id = null;
                f_name = null;
                f_description = null;
                f_members = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("id".equals(field)) {
                        f_id = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("name".equals(field)) {
                        f_name = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("description".equals(field)) {
                        f_description = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("members".equals(field)) {
                        f_members = StoneSerializers.nullable(StoneSerializers.list(StoneSerializers.string())).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_id == null) {
                    throw new JsonParseException(p, "Required field \"id\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            LegalHoldsPolicyUpdateArg value = new LegalHoldsPolicyUpdateArg(f_id, f_name, f_description, f_members);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final String id;
        protected String name;
        protected String description;
        protected List<String> members;

        protected Builder(String id) {
            if (id == null) {
                throw new IllegalArgumentException("Required value for 'id' is null");
            }
            if (!Pattern.matches("^pid_dbhid:.+", id)) {
                throw new IllegalArgumentException("String 'id' does not match pattern");
            }
            this.id = id;
            this.name = null;
            this.description = null;
            this.members = null;
        }

        public Builder withName(String name) {
            if (name != null && name.length() > 140) {
                throw new IllegalArgumentException("String 'name' is longer than 140");
            }
            this.name = name;
            return this;
        }

        public Builder withDescription(String description) {
            if (description != null && description.length() > 501) {
                throw new IllegalArgumentException("String 'description' is longer than 501");
            }
            this.description = description;
            return this;
        }

        public Builder withMembers(List<String> members) {
            if (members != null) {
                for (String x : members) {
                    if (x != null) continue;
                    throw new IllegalArgumentException("An item in list 'members' is null");
                }
            }
            this.members = members;
            return this;
        }

        public LegalHoldsPolicyUpdateArg build() {
            return new LegalHoldsPolicyUpdateArg(this.id, this.name, this.description, this.members);
        }
    }
}

