/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.teamcommon.GroupManagementType;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

class GroupCreateArg {
    protected final String groupName;
    protected final boolean addCreatorAsOwner;
    protected final String groupExternalId;
    protected final GroupManagementType groupManagementType;

    public GroupCreateArg(String groupName, boolean addCreatorAsOwner, String groupExternalId, GroupManagementType groupManagementType) {
        if (groupName == null) {
            throw new IllegalArgumentException("Required value for 'groupName' is null");
        }
        this.groupName = groupName;
        this.addCreatorAsOwner = addCreatorAsOwner;
        this.groupExternalId = groupExternalId;
        this.groupManagementType = groupManagementType;
    }

    public GroupCreateArg(String groupName) {
        this(groupName, false, null, null);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public boolean getAddCreatorAsOwner() {
        return this.addCreatorAsOwner;
    }

    public String getGroupExternalId() {
        return this.groupExternalId;
    }

    public GroupManagementType getGroupManagementType() {
        return this.groupManagementType;
    }

    public static Builder newBuilder(String groupName) {
        return new Builder(groupName);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.groupName, this.addCreatorAsOwner, this.groupExternalId, this.groupManagementType});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            GroupCreateArg other = (GroupCreateArg)obj;
            return (this.groupName == other.groupName || this.groupName.equals(other.groupName)) && this.addCreatorAsOwner == other.addCreatorAsOwner && (this.groupExternalId == other.groupExternalId || this.groupExternalId != null && this.groupExternalId.equals(other.groupExternalId)) && (this.groupManagementType == other.groupManagementType || this.groupManagementType != null && this.groupManagementType.equals((Object)other.groupManagementType));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<GroupCreateArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(GroupCreateArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("group_name");
            StoneSerializers.string().serialize(value.groupName, g);
            g.writeFieldName("add_creator_as_owner");
            StoneSerializers.boolean_().serialize((Boolean)value.addCreatorAsOwner, g);
            if (value.groupExternalId != null) {
                g.writeFieldName("group_external_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.groupExternalId, g);
            }
            if (value.groupManagementType != null) {
                g.writeFieldName("group_management_type");
                StoneSerializers.nullable(GroupManagementType.Serializer.INSTANCE).serialize(value.groupManagementType, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public GroupCreateArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            GroupManagementType f_groupManagementType;
            String f_groupExternalId;
            Boolean f_addCreatorAsOwner;
            String f_groupName;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_groupName = null;
                f_addCreatorAsOwner = false;
                f_groupExternalId = null;
                f_groupManagementType = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("group_name".equals(field)) {
                        f_groupName = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("add_creator_as_owner".equals(field)) {
                        f_addCreatorAsOwner = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("group_external_id".equals(field)) {
                        f_groupExternalId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("group_management_type".equals(field)) {
                        f_groupManagementType = StoneSerializers.nullable(GroupManagementType.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_groupName == null) {
                    throw new JsonParseException(p, "Required field \"group_name\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            GroupCreateArg value = new GroupCreateArg(f_groupName, f_addCreatorAsOwner, f_groupExternalId, f_groupManagementType);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final String groupName;
        protected boolean addCreatorAsOwner;
        protected String groupExternalId;
        protected GroupManagementType groupManagementType;

        protected Builder(String groupName) {
            if (groupName == null) {
                throw new IllegalArgumentException("Required value for 'groupName' is null");
            }
            this.groupName = groupName;
            this.addCreatorAsOwner = false;
            this.groupExternalId = null;
            this.groupManagementType = null;
        }

        public Builder withAddCreatorAsOwner(Boolean addCreatorAsOwner) {
            this.addCreatorAsOwner = addCreatorAsOwner != null ? addCreatorAsOwner : false;
            return this;
        }

        public Builder withGroupExternalId(String groupExternalId) {
            this.groupExternalId = groupExternalId;
            return this;
        }

        public Builder withGroupManagementType(GroupManagementType groupManagementType) {
            this.groupManagementType = groupManagementType;
            return this;
        }

        public GroupCreateArg build() {
            return new GroupCreateArg(this.groupName, this.addCreatorAsOwner, this.groupExternalId, this.groupManagementType);
        }
    }
}

