/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.gcp.storage;

import java.io.IOException;
import org.apache.beam.sdk.extensions.gcp.options.GcsOptions;
import org.apache.beam.sdk.extensions.gcp.storage.PathValidator;
import org.apache.beam.sdk.extensions.gcp.util.gcsfs.GcsPath;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class GcsPathValidator
implements PathValidator {
    private @UnknownKeyFor @NonNull @Initialized GcsOptions gcpOptions;

    private GcsPathValidator(@UnknownKeyFor @NonNull @Initialized GcsOptions options) {
        this.gcpOptions = options;
    }

    public static @UnknownKeyFor @NonNull @Initialized GcsPathValidator fromOptions(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        return new GcsPathValidator((GcsOptions)options.as(GcsOptions.class));
    }

    @Override
    public void validateInputFilePatternSupported(@UnknownKeyFor @NonNull @Initialized String filepattern) {
        this.getGcsPath(filepattern);
        this.verifyPath(filepattern);
        this.verifyPathIsAccessible(filepattern, "Could not find file %s");
    }

    @Override
    public void validateOutputFilePrefixSupported(@UnknownKeyFor @NonNull @Initialized String filePrefix) {
        this.verifyPath(filePrefix);
        this.verifyPathIsAccessible(filePrefix, "Output path does not exist or is not writeable: %s");
    }

    @Override
    public void validateOutputResourceSupported(@UnknownKeyFor @NonNull @Initialized ResourceId resourceId) {
        Preconditions.checkArgument((boolean)"gs".equals(resourceId.getScheme()), (String)"Expected a valid 'gs://' path but was given: '%s'", (Object)resourceId);
        this.verifyPath(resourceId.toString());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String verifyPath(@UnknownKeyFor @NonNull @Initialized String path) {
        GcsPath gcsPath = this.getGcsPath(path);
        Preconditions.checkArgument((boolean)gcsPath.isAbsolute(), (Object)"Must provide absolute paths for Dataflow");
        Preconditions.checkArgument((!gcsPath.getObject().isEmpty() ? 1 : 0) != 0, (String)"Missing object or bucket in path: '%s', did you mean: 'gs://some-bucket/%s'?", (Object)gcsPath, (Object)gcsPath.getBucket());
        Preconditions.checkArgument((!gcsPath.getObject().contains("//") ? 1 : 0) != 0, (Object)"Dataflow Service does not allow objects with consecutive slashes");
        return gcsPath.toResourceName();
    }

    private void verifyPathIsAccessible(@UnknownKeyFor @NonNull @Initialized String path, @UnknownKeyFor @NonNull @Initialized String errorMessage) {
        GcsPath gcsPath = this.getGcsPath(path);
        try {
            this.gcpOptions.getGcsUtil().verifyBucketAccessible(gcsPath);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format(errorMessage, path), e);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized GcsPath getGcsPath(@UnknownKeyFor @NonNull @Initialized String path) {
        try {
            return GcsPath.fromUri(path);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Expected a valid 'gs://' path but was given '%s'", path), e);
        }
    }
}

