/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.saxon.functions.FormatNumber2;
import net.sf.saxon.trans.DecimalSymbols;
import net.sf.saxon.trans.StaticError;

public class DecimalFormatManager
implements Serializable {
    private DecimalSymbols defaultDFS;
    private HashMap formatTable = new HashMap(10);
    private boolean usingOriginalDefault = true;

    public DecimalFormatManager() {
        DecimalSymbols decimalSymbols = new DecimalSymbols();
        DecimalFormatManager.setDefaults(decimalSymbols);
        this.defaultDFS = decimalSymbols;
    }

    public static void setDefaults(DecimalSymbols decimalSymbols) {
        decimalSymbols.decimalSeparator = 46;
        decimalSymbols.groupingSeparator = 44;
        decimalSymbols.infinity = "Infinity";
        decimalSymbols.minusSign = 45;
        decimalSymbols.NaN = "NaN";
        decimalSymbols.percent = 37;
        decimalSymbols.permill = 8240;
        decimalSymbols.zeroDigit = 48;
        decimalSymbols.digit = 35;
        decimalSymbols.patternSeparator = 59;
    }

    public void setDefaultDecimalFormat(DecimalSymbols decimalSymbols, int n) throws StaticError {
        if (!this.usingOriginalDefault && !decimalSymbols.equals(this.defaultDFS)) {
            StaticError staticError = new StaticError("There are two conflicting definitions of the default decimal format");
            staticError.setErrorCode("XTSE1290");
            throw staticError;
        }
        this.defaultDFS = decimalSymbols;
        this.usingOriginalDefault = false;
        this.setNamedDecimalFormat("", "", decimalSymbols, n);
    }

    public void fixupDefaultDefault() throws StaticError {
        if (this.usingOriginalDefault) {
            this.setNamedDecimalFormat("", "", this.defaultDFS, -1000);
        }
    }

    public DecimalSymbols getDefaultDecimalFormat() {
        return this.defaultDFS;
    }

    public void setNamedDecimalFormat(String string, String string2, DecimalSymbols decimalSymbols, int n) throws StaticError {
        Object object;
        String string3 = string2 + '#' + string;
        Object v = this.formatTable.get(string3);
        if (v != null) {
            if (v instanceof List) {
                object = ((List)v).iterator();
                while (object.hasNext()) {
                    FormatNumber2 formatNumber2 = (FormatNumber2)object.next();
                    formatNumber2.fixup(decimalSymbols);
                }
            } else {
                object = (DecimalFormatInfo)v;
                DecimalSymbols decimalSymbols2 = ((DecimalFormatInfo)object).dfs;
                int n2 = ((DecimalFormatInfo)object).precedence;
                if (n < n2) {
                    return;
                }
                if (n == n2 && !decimalSymbols.equals(decimalSymbols2)) {
                    StaticError staticError = new StaticError("There are two conflicting definitions of the named decimal-format");
                    staticError.setErrorCode("XTSE1290");
                    throw staticError;
                }
            }
        }
        object = new DecimalFormatInfo();
        ((DecimalFormatInfo)object).dfs = decimalSymbols;
        ((DecimalFormatInfo)object).precedence = n;
        this.formatTable.put(string3, object);
    }

    public void registerUsage(String string, String string2, FormatNumber2 formatNumber2) {
        String string3 = string2 + '#' + string;
        Object v = this.formatTable.get(string3);
        if (v == null) {
            ArrayList<FormatNumber2> arrayList = new ArrayList<FormatNumber2>(10);
            arrayList.add(formatNumber2);
            this.formatTable.put(string3, arrayList);
        } else if (v instanceof List) {
            List list = (List)v;
            list.add(formatNumber2);
        } else {
            DecimalFormatInfo decimalFormatInfo = (DecimalFormatInfo)v;
            formatNumber2.fixup(decimalFormatInfo.dfs);
        }
    }

    public DecimalSymbols getNamedDecimalFormat(String string, String string2) {
        String string3 = string2 + '#' + string;
        DecimalFormatInfo decimalFormatInfo = (DecimalFormatInfo)this.formatTable.get(string3);
        if (decimalFormatInfo == null) {
            return null;
        }
        return decimalFormatInfo.dfs;
    }

    private static class DecimalFormatInfo
    implements Serializable {
        public DecimalSymbols dfs;
        public int precedence;

        private DecimalFormatInfo() {
        }
    }
}

