/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.spi.v1;

import com.google.api.core.InternalApi;
import com.google.api.gax.grpc.GrpcInterceptorProvider;
import com.google.cloud.spanner.spi.v1.EncodingInterceptor;
import com.google.cloud.spanner.spi.v1.GapicSpannerRpc;
import com.google.cloud.spanner.spi.v1.HeaderInterceptor;
import com.google.cloud.spanner.spi.v1.LoggingInterceptor;
import com.google.cloud.spanner.spi.v1.SpannerErrorInterceptor;
import com.google.common.collect.ImmutableList;
import io.grpc.ClientInterceptor;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi(value="Exposed for testing")
public class SpannerInterceptorProvider
implements GrpcInterceptorProvider {
    private static final List<ClientInterceptor> defaultInterceptors = ImmutableList.of((Object)new SpannerErrorInterceptor(), (Object)new LoggingInterceptor(Logger.getLogger(GapicSpannerRpc.class.getName()), Level.FINER), (Object)new HeaderInterceptor());
    private final List<ClientInterceptor> clientInterceptors;

    private SpannerInterceptorProvider(List<ClientInterceptor> clientInterceptors) {
        this.clientInterceptors = clientInterceptors;
    }

    public static SpannerInterceptorProvider createDefault() {
        return new SpannerInterceptorProvider(defaultInterceptors);
    }

    static SpannerInterceptorProvider create(GrpcInterceptorProvider provider) {
        return new SpannerInterceptorProvider((List<ClientInterceptor>)ImmutableList.copyOf((Collection)provider.getInterceptors()));
    }

    public SpannerInterceptorProvider with(ClientInterceptor clientInterceptor) {
        ImmutableList interceptors = ImmutableList.builder().addAll(this.clientInterceptors).add((Object)clientInterceptor).build();
        return new SpannerInterceptorProvider((List<ClientInterceptor>)interceptors);
    }

    SpannerInterceptorProvider withEncoding(String encoding) {
        if (encoding != null) {
            return this.with(new EncodingInterceptor(encoding));
        }
        return this;
    }

    public List<ClientInterceptor> getInterceptors() {
        return this.clientInterceptors;
    }
}

