/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.randomvalue;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaNone;
import org.apache.hop.core.row.value.ValueMetaNumber;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IEnumHasCode;
import org.apache.hop.metadata.api.IEnumHasCodeAndDescription;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.randomvalue.RandomValue;
import org.apache.hop.pipeline.transforms.randomvalue.RandomValueData;

@Transform(id="RandomValue", image="randomvalue.svg", name="i18n::RandomValue.Name", description="i18n::RandomValue.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", keywords={"i18n::RandomValueMeta.keyword"}, documentationUrl="/pipeline/transforms/generaterandomvalue.html")
public class RandomValueMeta
extends BaseTransformMeta<RandomValue, RandomValueData> {
    private static final Class<?> PKG = RandomValueMeta.class;
    @HopMetadataProperty(key="seed")
    private String seed;
    @HopMetadataProperty(groupKey="fields", key="field")
    private List<RVField> fields = new ArrayList<RVField>();

    public RandomValueMeta() {
    }

    public RandomValueMeta(RandomValueMeta m) {
        this();
        this.seed = m.seed;
        m.fields.forEach(f -> this.fields.add(new RVField((RVField)f)));
    }

    public RandomValueMeta clone() {
        return new RandomValueMeta(this);
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) {
        for (RVField field : this.fields) {
            ValueMetaNone v;
            switch (field.getType()) {
                case NUMBER: {
                    v = new ValueMetaNumber(field.getName(), 10, 5);
                    break;
                }
                case INTEGER: {
                    v = new ValueMetaInteger(field.getName(), 10, 0);
                    break;
                }
                case STRING: {
                    v = new ValueMetaString(field.getName(), 13, 0);
                    break;
                }
                case UUID: 
                case UUID4: {
                    v = new ValueMetaString(field.getName(), 36, 0);
                    break;
                }
                case HMAC_MD5: 
                case HMAC_SHA1: {
                    v = new ValueMetaString(field.getName(), 100, 0);
                    break;
                }
                default: {
                    v = new ValueMetaNone(field.getName());
                }
            }
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        int nrRemarks = remarks.size();
        for (RVField field : this.fields) {
            if (field.getType() != null && field.getType() != RandomType.NONE) continue;
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"RandomValueMeta.CheckResult.FieldHasNoType", (String[])new String[]{field.getName()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (remarks.size() == nrRemarks) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"RandomValueMeta.CheckResult.AllTypesSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public List<RVField> getFields() {
        return this.fields;
    }

    public void setFields(List<RVField> fields) {
        this.fields = fields;
    }

    public String getSeed() {
        return this.seed;
    }

    public void setSeed(String seed) {
        this.seed = seed;
    }

    public static final class RVField {
        @HopMetadataProperty(key="name")
        private String name;
        @HopMetadataProperty(key="type", storeWithCode=true)
        private RandomType type = RandomType.NONE;

        public RVField() {
        }

        public RVField(RVField f) {
            this();
            this.name = f.name;
            this.type = f.type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public RandomType getType() {
            return this.type;
        }

        public void setType(RandomType type) {
            this.type = type;
        }
    }

    public static enum RandomType implements IEnumHasCodeAndDescription
    {
        NONE("", ""),
        NUMBER("random number", BaseMessages.getString(PKG, (String)"RandomValueMeta.TypeDesc.RandomNumber", (String[])new String[0])),
        INTEGER("random integer", BaseMessages.getString(PKG, (String)"RandomValueMeta.TypeDesc.RandomInteger", (String[])new String[0])),
        STRING("random string", BaseMessages.getString(PKG, (String)"RandomValueMeta.TypeDesc.RandomString", (String[])new String[0])),
        UUID("random uuid", BaseMessages.getString(PKG, (String)"RandomValueMeta.TypeDesc.RandomUUID", (String[])new String[0])),
        UUID4("random uuid4", BaseMessages.getString(PKG, (String)"RandomValueMeta.TypeDesc.RandomUUID4", (String[])new String[0])),
        HMAC_MD5("random machmacmd5", BaseMessages.getString(PKG, (String)"RandomValueMeta.TypeDesc.RandomHMACMD5", (String[])new String[0])),
        HMAC_SHA1("random machmacsha1", BaseMessages.getString(PKG, (String)"RandomValueMeta.TypeDesc.RandomHMACSHA1", (String[])new String[0]));

        private final String code;
        private final String description;

        private RandomType(String code, String description) {
            this.code = code;
            this.description = description;
        }

        public static String[] getDescriptions() {
            return IEnumHasCodeAndDescription.getDescriptions(RandomType.class);
        }

        public static RandomType lookupDescription(String description) {
            return (RandomType)IEnumHasCodeAndDescription.lookupDescription(RandomType.class, (String)description, (IEnumHasCodeAndDescription)NONE);
        }

        public static RandomType lookupCode(String code) {
            return (RandomType)IEnumHasCode.lookupCode(RandomType.class, (String)code, (IEnumHasCode)NONE);
        }

        public String getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

