/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.teamlog.FileRequestDetails;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

public class FileRequestChangeDetails {
    protected final String fileRequestId;
    protected final FileRequestDetails previousDetails;
    protected final FileRequestDetails newDetails;

    public FileRequestChangeDetails(FileRequestDetails newDetails, String fileRequestId, FileRequestDetails previousDetails) {
        if (fileRequestId != null) {
            if (fileRequestId.length() < 1) {
                throw new IllegalArgumentException("String 'fileRequestId' is shorter than 1");
            }
            if (!Pattern.matches("[-_0-9a-zA-Z]+", fileRequestId)) {
                throw new IllegalArgumentException("String 'fileRequestId' does not match pattern");
            }
        }
        this.fileRequestId = fileRequestId;
        this.previousDetails = previousDetails;
        if (newDetails == null) {
            throw new IllegalArgumentException("Required value for 'newDetails' is null");
        }
        this.newDetails = newDetails;
    }

    public FileRequestChangeDetails(FileRequestDetails newDetails) {
        this(newDetails, null, null);
    }

    public FileRequestDetails getNewDetails() {
        return this.newDetails;
    }

    public String getFileRequestId() {
        return this.fileRequestId;
    }

    public FileRequestDetails getPreviousDetails() {
        return this.previousDetails;
    }

    public static Builder newBuilder(FileRequestDetails newDetails) {
        return new Builder(newDetails);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.fileRequestId, this.previousDetails, this.newDetails});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            FileRequestChangeDetails other = (FileRequestChangeDetails)obj;
            return (this.newDetails == other.newDetails || this.newDetails.equals(other.newDetails)) && (this.fileRequestId == other.fileRequestId || this.fileRequestId != null && this.fileRequestId.equals(other.fileRequestId)) && (this.previousDetails == other.previousDetails || this.previousDetails != null && this.previousDetails.equals(other.previousDetails));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<FileRequestChangeDetails> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(FileRequestChangeDetails value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("new_details");
            FileRequestDetails.Serializer.INSTANCE.serialize(value.newDetails, g);
            if (value.fileRequestId != null) {
                g.writeFieldName("file_request_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.fileRequestId, g);
            }
            if (value.previousDetails != null) {
                g.writeFieldName("previous_details");
                StoneSerializers.nullableStruct(FileRequestDetails.Serializer.INSTANCE).serialize(value.previousDetails, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public FileRequestChangeDetails deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            FileRequestDetails f_previousDetails;
            String f_fileRequestId;
            FileRequestDetails f_newDetails;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_newDetails = null;
                f_fileRequestId = null;
                f_previousDetails = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("new_details".equals(field)) {
                        f_newDetails = (FileRequestDetails)FileRequestDetails.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("file_request_id".equals(field)) {
                        f_fileRequestId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("previous_details".equals(field)) {
                        f_previousDetails = StoneSerializers.nullableStruct(FileRequestDetails.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_newDetails == null) {
                    throw new JsonParseException(p, "Required field \"new_details\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            FileRequestChangeDetails value = new FileRequestChangeDetails(f_newDetails, f_fileRequestId, f_previousDetails);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final FileRequestDetails newDetails;
        protected String fileRequestId;
        protected FileRequestDetails previousDetails;

        protected Builder(FileRequestDetails newDetails) {
            if (newDetails == null) {
                throw new IllegalArgumentException("Required value for 'newDetails' is null");
            }
            this.newDetails = newDetails;
            this.fileRequestId = null;
            this.previousDetails = null;
        }

        public Builder withFileRequestId(String fileRequestId) {
            if (fileRequestId != null) {
                if (fileRequestId.length() < 1) {
                    throw new IllegalArgumentException("String 'fileRequestId' is shorter than 1");
                }
                if (!Pattern.matches("[-_0-9a-zA-Z]+", fileRequestId)) {
                    throw new IllegalArgumentException("String 'fileRequestId' does not match pattern");
                }
            }
            this.fileRequestId = fileRequestId;
            return this;
        }

        public Builder withPreviousDetails(FileRequestDetails previousDetails) {
            this.previousDetails = previousDetails;
            return this;
        }

        public FileRequestChangeDetails build() {
            return new FileRequestChangeDetails(this.newDetails, this.fileRequestId, this.previousDetails);
        }
    }
}

