/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.contacts;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

class DeleteManualContactsArg {
    protected final List<String> emailAddresses;

    public DeleteManualContactsArg(List<String> emailAddresses) {
        if (emailAddresses == null) {
            throw new IllegalArgumentException("Required value for 'emailAddresses' is null");
        }
        for (String x : emailAddresses) {
            if (x == null) {
                throw new IllegalArgumentException("An item in list 'emailAddresses' is null");
            }
            if (x.length() > 255) {
                throw new IllegalArgumentException("Stringan item in list 'emailAddresses' is longer than 255");
            }
            if (Pattern.matches("^['&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*\\.[A-Za-z]{2,15}$", x)) continue;
            throw new IllegalArgumentException("Stringan item in list 'emailAddresses' does not match pattern");
        }
        this.emailAddresses = emailAddresses;
    }

    public List<String> getEmailAddresses() {
        return this.emailAddresses;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.emailAddresses});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            DeleteManualContactsArg other = (DeleteManualContactsArg)obj;
            return this.emailAddresses == other.emailAddresses || this.emailAddresses.equals(other.emailAddresses);
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<DeleteManualContactsArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(DeleteManualContactsArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("email_addresses");
            StoneSerializers.list(StoneSerializers.string()).serialize(value.emailAddresses, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public DeleteManualContactsArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            List<String> f_emailAddresses;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_emailAddresses = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("email_addresses".equals(field)) {
                        f_emailAddresses = StoneSerializers.list(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_emailAddresses == null) {
                    throw new JsonParseException(p, "Required field \"email_addresses\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            DeleteManualContactsArg value = new DeleteManualContactsArg(f_emailAddresses);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

