/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.clouddocs;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class UserPermissions {
    protected final boolean canEdit;
    protected final boolean canRename;
    protected final boolean canComment;
    protected final boolean canDownload;

    public UserPermissions(boolean canEdit, boolean canRename, boolean canComment, boolean canDownload) {
        this.canEdit = canEdit;
        this.canRename = canRename;
        this.canComment = canComment;
        this.canDownload = canDownload;
    }

    public UserPermissions() {
        this(false, false, false, false);
    }

    public boolean getCanEdit() {
        return this.canEdit;
    }

    public boolean getCanRename() {
        return this.canRename;
    }

    public boolean getCanComment() {
        return this.canComment;
    }

    public boolean getCanDownload() {
        return this.canDownload;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.canEdit, this.canRename, this.canComment, this.canDownload});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            UserPermissions other = (UserPermissions)obj;
            return this.canEdit == other.canEdit && this.canRename == other.canRename && this.canComment == other.canComment && this.canDownload == other.canDownload;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<UserPermissions> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(UserPermissions value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("can_edit");
            StoneSerializers.boolean_().serialize((Boolean)value.canEdit, g);
            g.writeFieldName("can_rename");
            StoneSerializers.boolean_().serialize((Boolean)value.canRename, g);
            g.writeFieldName("can_comment");
            StoneSerializers.boolean_().serialize((Boolean)value.canComment, g);
            g.writeFieldName("can_download");
            StoneSerializers.boolean_().serialize((Boolean)value.canDownload, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public UserPermissions deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_canDownload;
            Boolean f_canComment;
            Boolean f_canRename;
            Boolean f_canEdit;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_canEdit = false;
                f_canRename = false;
                f_canComment = false;
                f_canDownload = false;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("can_edit".equals(field)) {
                        f_canEdit = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("can_rename".equals(field)) {
                        f_canRename = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("can_comment".equals(field)) {
                        f_canComment = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("can_download".equals(field)) {
                        f_canDownload = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            UserPermissions value = new UserPermissions(f_canEdit, f_canRename, f_canComment, f_canDownload);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected boolean canEdit = false;
        protected boolean canRename = false;
        protected boolean canComment = false;
        protected boolean canDownload = false;

        protected Builder() {
        }

        public Builder withCanEdit(Boolean canEdit) {
            this.canEdit = canEdit != null ? canEdit : false;
            return this;
        }

        public Builder withCanRename(Boolean canRename) {
            this.canRename = canRename != null ? canRename : false;
            return this;
        }

        public Builder withCanComment(Boolean canComment) {
            this.canComment = canComment != null ? canComment : false;
            return this;
        }

        public Builder withCanDownload(Boolean canDownload) {
            this.canDownload = canDownload != null ? canDownload : false;
            return this;
        }

        public UserPermissions build() {
            return new UserPermissions(this.canEdit, this.canRename, this.canComment, this.canDownload);
        }
    }
}

