/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc.testing;

import com.google.api.core.BetaApi;
import io.grpc.BindableService;
import io.grpc.Metadata;
import io.grpc.Server;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.IOException;

@BetaApi
public class InProcessServer<T extends BindableService> {
    private T serverImpl;
    private String name;
    private ServerInterceptor interceptor;
    private Server server;

    public InProcessServer(T serverImpl, String name) {
        this(serverImpl, name, new ServerInterceptor(){

            public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
                return next.startCall(call, headers);
            }
        });
    }

    public InProcessServer(T serverImpl, String name, ServerInterceptor interceptor) {
        this.serverImpl = serverImpl;
        this.name = name;
        this.interceptor = interceptor;
    }

    public void start() throws IOException, InstantiationException, IllegalAccessException {
        this.server = ((InProcessServerBuilder)((InProcessServerBuilder)((InProcessServerBuilder)InProcessServerBuilder.forName((String)this.name).directExecutor()).addService(this.serverImpl)).intercept(this.interceptor)).build().start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                InProcessServer.this.stop();
            }
        });
    }

    public void stop() {
        if (this.server != null) {
            this.server.shutdown();
        }
    }

    public void blockUntilShutdown() throws InterruptedException {
        if (this.server != null) {
            this.server.awaitTermination();
        }
    }
}

