/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.util.ExposedByteArrayInputStream;

@Internal
public class StreamUtils {
    private static final int BUF_SIZE = 8192;
    private static ThreadLocal<SoftReference<byte[]>> threadLocalBuffer = new ThreadLocal();

    private StreamUtils() {
    }

    public static byte[] getBytesWithoutClosing(InputStream stream) throws IOException {
        int r;
        byte[] buffer;
        if (stream instanceof ExposedByteArrayInputStream) {
            return ((ExposedByteArrayInputStream)stream).readAll();
        }
        if (stream instanceof ByteArrayInputStream) {
            byte[] ret = new byte[stream.available()];
            stream.read(ret);
            return ret;
        }
        SoftReference<byte[]> refBuffer = threadLocalBuffer.get();
        byte[] byArray = buffer = refBuffer == null ? null : refBuffer.get();
        if (buffer == null) {
            buffer = new byte[8192];
            threadLocalBuffer.set(new SoftReference<byte[]>(buffer));
        }
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        while ((r = stream.read(buffer)) != -1) {
            outStream.write(buffer, 0, r);
        }
        return outStream.toByteArray();
    }
}

