/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class SerializableThrowable
implements Serializable {
    private final @Nullable Throwable throwable;
    private final StackTraceElement @Nullable [] stackTrace;

    public SerializableThrowable(@Nullable Throwable t) {
        this.throwable = t;
        this.stackTrace = t == null ? null : t.getStackTrace();
    }

    public @Nullable Throwable getThrowable() {
        return this.throwable;
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
        if (this.throwable != null) {
            this.throwable.setStackTrace(this.stackTrace);
        }
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerializableThrowable that = (SerializableThrowable)o;
        return Arrays.equals(this.stackTrace, that.stackTrace);
    }

    public int hashCode() {
        return Arrays.hashCode(this.stackTrace);
    }
}

