/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.resourcehints;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.resourcehints.ResourceHint;
import org.apache.beam.sdk.transforms.resourcehints.ResourceHintsOptions;
import org.apache.beam.vendor.grpc.v1p48p1.com.google.protobuf.ProtocolMessageEnum;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Charsets;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Splitter;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ResourceHints {
    private static final String MIN_RAM_URN = "beam:resources:min_ram_bytes:v1";
    private static final String ACCELERATOR_URN = "beam:resources:accelerator:v1";
    private static ImmutableMap<String, String> hintNameToUrn;
    private static ImmutableMap<String, Function<String, ResourceHint>> parsers;
    private static final ResourceHints EMPTY;
    private final ImmutableMap<String, ResourceHint> hints;

    private static String getUrn(ProtocolMessageEnum value) {
        return (String)value.getValueDescriptor().getOptions().getExtension(RunnerApi.beamUrn);
    }

    private ResourceHints(ImmutableMap<String, ResourceHint> hints) {
        this.hints = hints;
    }

    public static ResourceHints create() {
        return EMPTY;
    }

    public static ResourceHints fromOptions(PipelineOptions options) {
        ResourceHintsOptions resourceHintsOptions = options.as(ResourceHintsOptions.class);
        ResourceHints result = ResourceHints.create();
        List<String> hints = resourceHintsOptions.getResourceHints();
        Splitter splitter = Splitter.on((char)'=').limit(2);
        for (String hint : hints) {
            String urn;
            List parts = splitter.splitToList((CharSequence)hint);
            if (parts.size() != 2) {
                throw new IllegalArgumentException("Unparsable resource hint: " + hint);
            }
            String nameOrUrn = (String)parts.get(0);
            String stringValue = (String)parts.get(1);
            if (hintNameToUrn.containsKey((Object)nameOrUrn)) {
                urn = (String)hintNameToUrn.get((Object)nameOrUrn);
            } else {
                if (!nameOrUrn.startsWith("beam:resources:")) {
                    throw new IllegalArgumentException("Unknown resource hint: " + hint);
                }
                urn = nameOrUrn;
            }
            ResourceHint value = (ResourceHint)((Function)parsers.getOrDefault((Object)urn, s -> new StringHint((String)s))).apply(stringValue);
            result = result.withHint(urn, value);
        }
        return result;
    }

    public ResourceHints withMinRam(long ramBytes) {
        return this.withHint(MIN_RAM_URN, new BytesHint(ramBytes));
    }

    public ResourceHints withMinRam(String ramBytes) {
        return this.withMinRam(BytesHint.parse(ramBytes));
    }

    public ResourceHints withAccelerator(String accelerator) {
        return this.withHint(ACCELERATOR_URN, new StringHint(accelerator));
    }

    public ResourceHints withHint(String urn, ResourceHint hint) {
        ImmutableMap.Builder newHints = ImmutableMap.builder();
        newHints.put((Object)urn, (Object)hint);
        for (Map.Entry oldHint : this.hints.entrySet()) {
            if (((String)oldHint.getKey()).equals(urn)) continue;
            newHints.put((Object)((String)oldHint.getKey()), (Object)((ResourceHint)oldHint.getValue()));
        }
        return new ResourceHints((ImmutableMap<String, ResourceHint>)newHints.build());
    }

    public Map<String, ResourceHint> hints() {
        return this.hints;
    }

    public ResourceHints mergeWithOuter(ResourceHints outer) {
        if (outer.hints.isEmpty()) {
            return this;
        }
        if (this.hints.isEmpty()) {
            return outer;
        }
        ImmutableMap.Builder newHints = ImmutableMap.builder();
        for (Map.Entry<String, ResourceHint> outerHint : outer.hints().entrySet()) {
            if (this.hints.containsKey((Object)outerHint.getKey())) {
                newHints.put((Object)outerHint.getKey(), (Object)((ResourceHint)this.hints.get((Object)outerHint.getKey())).mergeWithOuter(outerHint.getValue()));
                continue;
            }
            newHints.put(outerHint);
        }
        for (Map.Entry hint : this.hints.entrySet()) {
            if (outer.hints.containsKey(hint.getKey())) continue;
            newHints.put(hint);
        }
        return new ResourceHints((ImmutableMap<String, ResourceHint>)newHints.build());
    }

    public boolean equals(@Nullable Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof ResourceHints) {
            return ((ResourceHints)other).hints.equals(this.hints);
        }
        return false;
    }

    public int hashCode() {
        return this.hints.hashCode();
    }

    static {
        Preconditions.checkState((boolean)MIN_RAM_URN.equals(ResourceHints.getUrn(RunnerApi.StandardResourceHints.Enum.MIN_RAM_BYTES)));
        Preconditions.checkState((boolean)ACCELERATOR_URN.equals(ResourceHints.getUrn(RunnerApi.StandardResourceHints.Enum.ACCELERATOR)));
        hintNameToUrn = ImmutableMap.builder().put((Object)"minRam", (Object)MIN_RAM_URN).put((Object)"min_ram", (Object)MIN_RAM_URN).put((Object)"accelerator", (Object)ACCELERATOR_URN).build();
        parsers = ImmutableMap.builder().put((Object)MIN_RAM_URN, s -> new BytesHint(BytesHint.parse(s))).put((Object)ACCELERATOR_URN, s -> new StringHint((String)s)).build();
        EMPTY = new ResourceHints((ImmutableMap<String, ResourceHint>)ImmutableMap.of());
    }

    static class StringHint
    extends ResourceHint {
        private final String value;

        public StringHint(String value) {
            this.value = value;
        }

        public static String parse(String s) {
            return s;
        }

        @Override
        public byte[] toBytes() {
            return this.value.getBytes(Charsets.US_ASCII);
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (other instanceof StringHint) {
                return ((StringHint)other).value.equals(this.value);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.value.hashCode();
        }
    }

    static class BytesHint
    extends ResourceHint {
        private static Map<String, Long> suffixes = ImmutableMap.builder().put((Object)"B", (Object)1L).put((Object)"KB", (Object)1000L).put((Object)"MB", (Object)1000000L).put((Object)"GB", (Object)1000000000L).put((Object)"TB", (Object)1000000000000L).put((Object)"PB", (Object)1000000000000000L).put((Object)"KiB", (Object)1024L).put((Object)"MiB", (Object)0x100000L).put((Object)"GiB", (Object)0x40000000L).put((Object)"TiB", (Object)0x10000000000L).put((Object)"PiB", (Object)0x4000000000000L).build();
        private final long value;

        @Override
        public boolean equals(@Nullable Object other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (other instanceof BytesHint) {
                return ((BytesHint)other).value == this.value;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Long.hashCode(this.value);
        }

        public BytesHint(long value) {
            this.value = value;
        }

        public static long parse(String s) {
            Matcher m = Pattern.compile("([\\d.]+)[\\s]?([\\D]+$)").matcher(s);
            if (m.find()) {
                String number = m.group(1);
                String suffix = m.group(2);
                if (number != null && suffix != null && suffixes.containsKey(suffix)) {
                    return (long)(Double.valueOf(number) * (double)suffixes.get(suffix).longValue());
                }
            }
            throw new IllegalArgumentException("Unable to parse '" + s + "' as a byte value.");
        }

        @Override
        public ResourceHint mergeWithOuter(ResourceHint outer) {
            return new BytesHint(Math.max(this.value, ((BytesHint)outer).value));
        }

        @Override
        public byte[] toBytes() {
            return String.valueOf(this.value).getBytes(Charsets.US_ASCII);
        }
    }
}

