/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.ProcessFunction;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.PCollection;

public class Filter<T>
extends PTransform<PCollection<T>, PCollection<T>> {
    private ProcessFunction<T, Boolean> predicate;
    private String predicateDescription;

    public static <T, PredicateT extends ProcessFunction<T, Boolean>> Filter<T> by(PredicateT predicate) {
        return new Filter<T>(predicate);
    }

    public static <T, PredicateT extends SerializableFunction<T, Boolean>> Filter<T> by(PredicateT predicate) {
        return Filter.by(predicate);
    }

    public static <T extends Comparable<T>> Filter<T> lessThan(T value) {
        return Filter.by(input -> input.compareTo(value) < 0).described(String.format("x < %s", value));
    }

    public static <T extends Comparable<T>> Filter<T> greaterThan(T value) {
        return Filter.by(input -> input.compareTo(value) > 0).described(String.format("x > %s", value));
    }

    public static <T extends Comparable<T>> Filter<T> lessThanEq(T value) {
        return Filter.by(input -> input.compareTo(value) <= 0).described(String.format("x \u2264 %s", value));
    }

    public static <T extends Comparable<T>> Filter<T> greaterThanEq(T value) {
        return Filter.by(input -> input.compareTo(value) >= 0).described(String.format("x \u2265 %s", value));
    }

    public static <T extends Comparable<T>> Filter<T> equal(T value) {
        return Filter.by(input -> input.compareTo(value) == 0).described(String.format("x == %s", value));
    }

    private Filter(ProcessFunction<T, Boolean> predicate) {
        this(predicate, "Filter.predicate");
    }

    private Filter(ProcessFunction<T, Boolean> predicate, String predicateDescription) {
        this.predicate = predicate;
        this.predicateDescription = predicateDescription;
    }

    Filter<T> described(String description) {
        return new Filter<T>(this.predicate, description);
    }

    @Override
    public PCollection<T> expand(PCollection<T> input) {
        return ((PCollection)input.apply(ParDo.of(new DoFn<T, T>(){

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element T element, DoFn.OutputReceiver<T> r) throws Exception {
                if (((Boolean)Filter.this.predicate.apply(element)).booleanValue()) {
                    r.output(element);
                }
            }
        }))).setCoder(input.getCoder());
    }

    @Override
    public void populateDisplayData(DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.add(DisplayData.item("predicate", this.predicateDescription).withLabel("Filter Predicate"));
    }
}

