/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.options;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public interface ValueProvider<T>
extends Serializable {
    public T get();

    public boolean isAccessible();

    @Internal
    public static class Deserializer
    extends JsonDeserializer<ValueProvider<?>>
    implements ContextualDeserializer {
        private final JavaType innerType;

        Deserializer() {
            this.innerType = null;
        }

        Deserializer(JavaType innerType) {
            this.innerType = innerType;
        }

        public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
            Preconditions.checkNotNull((Object)ctxt, (Object)"Null DeserializationContext.");
            JavaType type = (JavaType)Preconditions.checkNotNull((Object)ctxt.getContextualType(), (String)"Invalid type: %s", ((Object)((Object)this)).getClass());
            JavaType[] params = type.findTypeParameters(ValueProvider.class);
            if (params.length != 1) {
                throw new RuntimeException("Unable to derive type for ValueProvider: " + type.toString());
            }
            JavaType param = params[0];
            return new Deserializer(param);
        }

        public ValueProvider<?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonDeserializer dser = ctxt.findRootValueDeserializer((JavaType)Preconditions.checkNotNull((Object)this.innerType, (String)"Invalid %s: innerType is null. Serialization error?", ((Object)((Object)this)).getClass()));
            Object o = dser.deserialize(jp, ctxt);
            return StaticValueProvider.of(o);
        }
    }

    @Internal
    public static class Serializer
    extends JsonSerializer<ValueProvider<?>> {
        public void serialize(ValueProvider<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            if (value.isAccessible()) {
                jgen.writeObject(value.get());
            } else {
                jgen.writeNull();
            }
        }
    }

    public static class RuntimeValueProvider<T>
    implements ValueProvider<T>,
    Serializable {
        private static ConcurrentHashMap<Long, PipelineOptions> optionsMap = new ConcurrentHashMap();
        private final Class<? extends PipelineOptions> klass;
        private final String methodName;
        private final String propertyName;
        private final @Nullable T defaultValue;
        private final Long optionsId;

        RuntimeValueProvider(String methodName, String propertyName, Class<? extends PipelineOptions> klass, Long optionsId) {
            this.methodName = methodName;
            this.propertyName = propertyName;
            this.klass = klass;
            this.defaultValue = null;
            this.optionsId = optionsId;
        }

        RuntimeValueProvider(String methodName, String propertyName, Class<? extends PipelineOptions> klass, T defaultValue, Long optionsId) {
            this.methodName = methodName;
            this.propertyName = propertyName;
            this.klass = klass;
            this.defaultValue = defaultValue;
            this.optionsId = optionsId;
        }

        static void setRuntimeOptions(PipelineOptions runtimeOptions) {
            optionsMap.put(runtimeOptions.getOptionsId(), runtimeOptions);
        }

        @Override
        public T get() {
            PipelineOptions options = optionsMap.get(this.optionsId);
            if (options == null) {
                throw new IllegalStateException("Value only available at runtime, but accessed from a non-runtime context: " + this);
            }
            try {
                Method method = this.klass.getMethod(this.methodName, new Class[0]);
                PipelineOptions methodOptions = options.as(this.klass);
                InvocationHandler handler = Proxy.getInvocationHandler(methodOptions);
                ValueProvider result = (ValueProvider)handler.invoke(methodOptions, method, null);
                if (result instanceof StaticValueProvider) {
                    return result.get();
                }
                return this.defaultValue;
            }
            catch (Throwable e) {
                throw new RuntimeException("Unable to load runtime value.", e);
            }
        }

        @Override
        public boolean isAccessible() {
            return optionsMap.get(this.optionsId) != null;
        }

        public String propertyName() {
            return this.propertyName;
        }

        public String toString() {
            if (this.isAccessible()) {
                return String.valueOf(this.get());
            }
            return MoreObjects.toStringHelper((Object)this).add("propertyName", (Object)this.propertyName).add("default", this.defaultValue).toString();
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof RuntimeValueProvider && Objects.equals(this.klass, ((RuntimeValueProvider)other).klass) && Objects.equals(this.methodName, ((RuntimeValueProvider)other).methodName) && Objects.equals(this.propertyName, ((RuntimeValueProvider)other).propertyName) && Objects.equals(this.defaultValue, ((RuntimeValueProvider)other).defaultValue) && Objects.equals(this.optionsId, ((RuntimeValueProvider)other).optionsId);
        }

        public int hashCode() {
            return Objects.hash(this.klass, this.methodName, this.propertyName, this.defaultValue, this.optionsId);
        }
    }

    public static class NestedValueProvider<T, X>
    implements ValueProvider<T>,
    Serializable {
        private final ValueProvider<X> value;
        private final SerializableFunction<X, T> translator;
        private volatile transient T cachedValue;

        NestedValueProvider(ValueProvider<X> value, SerializableFunction<X, T> translator) {
            this.value = (ValueProvider)Preconditions.checkNotNull(value);
            this.translator = (SerializableFunction)Preconditions.checkNotNull(translator);
        }

        public static <T, X> NestedValueProvider<T, X> of(ValueProvider<X> value, SerializableFunction<X, T> translator) {
            return new NestedValueProvider<T, X>(value, translator);
        }

        @Override
        public T get() {
            if (this.cachedValue == null) {
                this.cachedValue = this.translator.apply(this.value.get());
            }
            return this.cachedValue;
        }

        @Override
        public boolean isAccessible() {
            return this.value.isAccessible();
        }

        public String propertyName() {
            if (this.value instanceof RuntimeValueProvider) {
                return ((RuntimeValueProvider)this.value).propertyName();
            }
            if (this.value instanceof NestedValueProvider) {
                return ((NestedValueProvider)this.value).propertyName();
            }
            throw new RuntimeException("Only a RuntimeValueProvider or a NestedValueProvider can supply a property name.");
        }

        public String toString() {
            if (this.isAccessible()) {
                return String.valueOf(this.get());
            }
            return MoreObjects.toStringHelper((Object)this).add("value", this.value).add("translator", (Object)this.translator.getClass().getSimpleName()).toString();
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof NestedValueProvider && Objects.equals(this.value, ((NestedValueProvider)other).value) && Objects.equals(this.translator, ((NestedValueProvider)other).translator);
        }

        public int hashCode() {
            return Objects.hash(this.value, this.translator);
        }
    }

    public static class StaticValueProvider<T>
    implements ValueProvider<T>,
    Serializable {
        private final @Nullable T value;

        StaticValueProvider(@Nullable T value) {
            this.value = value;
        }

        public static <T> StaticValueProvider<T> of(T value) {
            return new StaticValueProvider<T>(value);
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public boolean isAccessible() {
            return true;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof StaticValueProvider && Objects.equals(this.value, ((StaticValueProvider)other).value);
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }
    }
}

