/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.metrics;

import java.io.Serializable;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metric;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsEnvironment;

@Internal
public class DelegatingCounter
implements Metric,
Counter,
Serializable {
    private final MetricName name;
    private final boolean processWideContainer;

    public DelegatingCounter(MetricName name) {
        this(name, false);
    }

    public DelegatingCounter(MetricName name, boolean processWideContainer) {
        this.name = name;
        this.processWideContainer = processWideContainer;
    }

    @Override
    public void inc() {
        this.inc(1L);
    }

    @Override
    public void inc(long n) {
        MetricsContainer container;
        MetricsContainer metricsContainer = container = this.processWideContainer ? MetricsEnvironment.getProcessWideContainer() : MetricsEnvironment.getCurrentContainer();
        if (container != null) {
            container.getCounter(this.name).inc(n);
        }
    }

    @Override
    public void dec() {
        this.inc(-1L);
    }

    @Override
    public void dec(long n) {
        this.inc(-1L * n);
    }

    @Override
    public MetricName getName() {
        return this.name;
    }
}

