/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.Page;
import com.google.cloud.Policy;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Backup;
import com.google.cloud.spanner.BackupId;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.DatabaseRole;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.Restore;
import com.google.cloud.spanner.SpannerException;
import com.google.longrunning.Operation;
import com.google.spanner.admin.database.v1.CopyBackupMetadata;
import com.google.spanner.admin.database.v1.CreateBackupMetadata;
import com.google.spanner.admin.database.v1.CreateDatabaseMetadata;
import com.google.spanner.admin.database.v1.RestoreDatabaseMetadata;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata;
import java.util.List;
import javax.annotation.Nullable;

public interface DatabaseAdminClient {
    public OperationFuture<Database, CreateDatabaseMetadata> createDatabase(String var1, String var2, Iterable<String> var3) throws SpannerException;

    default public OperationFuture<Database, CreateDatabaseMetadata> createDatabase(String instanceId, String createDatabaseStatement, Dialect dialect, Iterable<String> statements) throws SpannerException {
        throw new UnsupportedOperationException("Unimplemented");
    }

    public OperationFuture<Database, CreateDatabaseMetadata> createDatabase(Database var1, Iterable<String> var2) throws SpannerException;

    public Database.Builder newDatabaseBuilder(DatabaseId var1);

    public Backup.Builder newBackupBuilder(BackupId var1);

    public Restore.Builder newRestoreBuilder(BackupId var1, DatabaseId var2);

    public OperationFuture<Backup, CreateBackupMetadata> createBackup(String var1, String var2, String var3, Timestamp var4) throws SpannerException;

    public OperationFuture<Backup, CreateBackupMetadata> createBackup(Backup var1) throws SpannerException;

    default public OperationFuture<Backup, CopyBackupMetadata> copyBackup(String instanceId, String sourceBackupId, String destinationBackupId, Timestamp expireTime) {
        throw new UnsupportedOperationException("Unimplemented");
    }

    default public OperationFuture<Backup, CopyBackupMetadata> copyBackup(BackupId sourceBackupId, Backup destinationBackup) {
        throw new UnsupportedOperationException("Unimplemented");
    }

    public OperationFuture<Database, RestoreDatabaseMetadata> restoreDatabase(String var1, String var2, String var3, String var4) throws SpannerException;

    public OperationFuture<Database, RestoreDatabaseMetadata> restoreDatabase(Restore var1) throws SpannerException;

    public Page<Operation> listDatabaseOperations(String var1, Options.ListOption ... var2);

    public Page<DatabaseRole> listDatabaseRoles(String var1, String var2, Options.ListOption ... var3);

    public Page<Operation> listBackupOperations(String var1, Options.ListOption ... var2);

    public Database getDatabase(String var1, String var2) throws SpannerException;

    public Backup getBackup(String var1, String var2) throws SpannerException;

    public OperationFuture<Void, UpdateDatabaseDdlMetadata> updateDatabaseDdl(String var1, String var2, Iterable<String> var3, @Nullable String var4) throws SpannerException;

    public void dropDatabase(String var1, String var2) throws SpannerException;

    public List<String> getDatabaseDdl(String var1, String var2);

    public Page<Database> listDatabases(String var1, Options.ListOption ... var2);

    public Page<Backup> listBackups(String var1, Options.ListOption ... var2);

    public Backup updateBackup(String var1, String var2, Timestamp var3);

    public void deleteBackup(String var1, String var2);

    public void cancelOperation(String var1);

    public Operation getOperation(String var1);

    public Policy getDatabaseIAMPolicy(String var1, String var2, int var3);

    public Policy setDatabaseIAMPolicy(String var1, String var2, Policy var3);

    public Iterable<String> testDatabaseIAMPermissions(String var1, String var2, Iterable<String> var3);

    public Policy getBackupIAMPolicy(String var1, String var2);

    public Policy setBackupIAMPolicy(String var1, String var2, Policy var3);

    public Iterable<String> testBackupIAMPermissions(String var1, String var2, Iterable<String> var3);
}

