/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.client.ChunkReceivedCallback;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.StreamCallback;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.server.OneForOneStreamManager;
import org.apache.spark.network.shuffle.BlockFetchingListener;
import org.apache.spark.network.shuffle.DownloadFile;
import org.apache.spark.network.shuffle.DownloadFileManager;
import org.apache.spark.network.shuffle.DownloadFileWritableChannel;
import org.apache.spark.network.shuffle.protocol.AbstractFetchShuffleBlocks;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;
import org.apache.spark.network.shuffle.protocol.FetchShuffleBlockChunks;
import org.apache.spark.network.shuffle.protocol.FetchShuffleBlocks;
import org.apache.spark.network.shuffle.protocol.OpenBlocks;
import org.apache.spark.network.shuffle.protocol.StreamHandle;
import org.apache.spark.network.util.TransportConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.guava.primitives.Ints;
import org.sparkproject.guava.primitives.Longs;

public class OneForOneBlockFetcher {
    private static final Logger logger = LoggerFactory.getLogger(OneForOneBlockFetcher.class);
    private static final String SHUFFLE_BLOCK_PREFIX = "shuffle_";
    private static final String SHUFFLE_CHUNK_PREFIX = "shuffleChunk_";
    private static final String SHUFFLE_BLOCK_SPLIT = "shuffle";
    private static final String SHUFFLE_CHUNK_SPLIT = "shuffleChunk";
    private final TransportClient client;
    private final BlockTransferMessage message;
    private final String[] blockIds;
    private final BlockFetchingListener listener;
    private final ChunkReceivedCallback chunkCallback;
    private final TransportConf transportConf;
    private final DownloadFileManager downloadFileManager;
    private StreamHandle streamHandle = null;

    public OneForOneBlockFetcher(TransportClient client, String appId, String execId, String[] blockIds, BlockFetchingListener listener, TransportConf transportConf) {
        this(client, appId, execId, blockIds, listener, transportConf, null);
    }

    public OneForOneBlockFetcher(TransportClient client, String appId, String execId, String[] blockIds, BlockFetchingListener listener, TransportConf transportConf, DownloadFileManager downloadFileManager) {
        this.client = client;
        this.listener = listener;
        this.chunkCallback = new ChunkCallback();
        this.transportConf = transportConf;
        this.downloadFileManager = downloadFileManager;
        if (blockIds.length == 0) {
            throw new IllegalArgumentException("Zero-sized blockIds array");
        }
        if (!transportConf.useOldFetchProtocol() && this.areShuffleBlocksOrChunks(blockIds)) {
            this.blockIds = new String[blockIds.length];
            this.message = this.createFetchShuffleBlocksOrChunksMsg(appId, execId, blockIds);
        } else {
            this.blockIds = blockIds;
            this.message = new OpenBlocks(appId, execId, blockIds);
        }
    }

    private boolean areShuffleBlocksOrChunks(String[] blockIds) {
        if (Arrays.stream(blockIds).anyMatch(blockId -> !blockId.startsWith(SHUFFLE_BLOCK_PREFIX))) {
            return Arrays.stream(blockIds).allMatch(blockId -> blockId.startsWith(SHUFFLE_CHUNK_PREFIX));
        }
        return true;
    }

    private AbstractFetchShuffleBlocks createFetchShuffleBlocksOrChunksMsg(String appId, String execId, String[] blockIds) {
        if (blockIds[0].startsWith(SHUFFLE_CHUNK_PREFIX)) {
            return this.createFetchShuffleChunksMsg(appId, execId, blockIds);
        }
        return this.createFetchShuffleBlocksMsg(appId, execId, blockIds);
    }

    private AbstractFetchShuffleBlocks createFetchShuffleBlocksMsg(String appId, String execId, String[] blockIds) {
        String[] firstBlock = this.splitBlockId(blockIds[0]);
        int shuffleId = Integer.parseInt(firstBlock[1]);
        boolean batchFetchEnabled = firstBlock.length == 5;
        LinkedHashMap<Long, BlocksInfo> mapIdToBlocksInfo = new LinkedHashMap<Long, BlocksInfo>();
        for (String blockId : blockIds) {
            String[] blockIdParts = this.splitBlockId(blockId);
            if (Integer.parseInt(blockIdParts[1]) != shuffleId) {
                throw new IllegalArgumentException("Expected shuffleId=" + shuffleId + ", got:" + blockId);
            }
            long mapId = Long.parseLong(blockIdParts[2]);
            BlocksInfo blocksInfoByMapId = mapIdToBlocksInfo.computeIfAbsent(mapId, id -> new BlocksInfo());
            blocksInfoByMapId.blockIds.add(blockId);
            blocksInfoByMapId.ids.add(Integer.parseInt(blockIdParts[3]));
            if (!batchFetchEnabled) continue;
            assert (blockIdParts.length == 5);
            blocksInfoByMapId.ids.add(Integer.parseInt(blockIdParts[4]));
        }
        int[][] reduceIdsArray = this.getSecondaryIds(mapIdToBlocksInfo);
        long[] mapIds = Longs.toArray(mapIdToBlocksInfo.keySet());
        return new FetchShuffleBlocks(appId, execId, shuffleId, mapIds, reduceIdsArray, batchFetchEnabled);
    }

    private AbstractFetchShuffleBlocks createFetchShuffleChunksMsg(String appId, String execId, String[] blockIds) {
        String[] firstBlock = this.splitBlockId(blockIds[0]);
        int shuffleId = Integer.parseInt(firstBlock[1]);
        int shuffleMergeId = Integer.parseInt(firstBlock[2]);
        LinkedHashMap<Integer, BlocksInfo> reduceIdToBlocksInfo = new LinkedHashMap<Integer, BlocksInfo>();
        for (String blockId : blockIds) {
            String[] blockIdParts = this.splitBlockId(blockId);
            if (Integer.parseInt(blockIdParts[1]) != shuffleId || Integer.parseInt(blockIdParts[2]) != shuffleMergeId) {
                throw new IllegalArgumentException(String.format("Expected shuffleId = %s and shuffleMergeId = %s but got %s", shuffleId, shuffleMergeId, blockId));
            }
            int reduceId = Integer.parseInt(blockIdParts[3]);
            BlocksInfo blocksInfoByReduceId = reduceIdToBlocksInfo.computeIfAbsent(reduceId, id -> new BlocksInfo());
            blocksInfoByReduceId.blockIds.add(blockId);
            blocksInfoByReduceId.ids.add(Integer.parseInt(blockIdParts[4]));
        }
        int[][] chunkIdsArray = this.getSecondaryIds(reduceIdToBlocksInfo);
        int[] reduceIds = Ints.toArray(reduceIdToBlocksInfo.keySet());
        return new FetchShuffleBlockChunks(appId, execId, shuffleId, shuffleMergeId, reduceIds, chunkIdsArray);
    }

    private int[][] getSecondaryIds(Map<? extends Number, BlocksInfo> primaryIdsToBlockInfo) {
        int[][] secondaryIds = new int[primaryIdsToBlockInfo.size()][];
        int blockIdIndex = 0;
        int secIndex = 0;
        for (BlocksInfo blocksInfo : primaryIdsToBlockInfo.values()) {
            secondaryIds[secIndex++] = Ints.toArray(blocksInfo.ids);
            for (String blockId : blocksInfo.blockIds) {
                this.blockIds[blockIdIndex++] = blockId;
            }
        }
        assert (blockIdIndex == this.blockIds.length);
        return secondaryIds;
    }

    private String[] splitBlockId(String blockId) {
        String[] blockIdParts = blockId.split("_");
        if (blockIdParts.length < 4 || blockIdParts.length > 5) {
            throw new IllegalArgumentException("Unexpected shuffle block id format: " + blockId);
        }
        if (blockIdParts.length == 4 && !blockIdParts[0].equals(SHUFFLE_BLOCK_SPLIT)) {
            throw new IllegalArgumentException("Unexpected shuffle block id format: " + blockId);
        }
        if (blockIdParts.length == 5 && !blockIdParts[0].equals(SHUFFLE_BLOCK_SPLIT) && !blockIdParts[0].equals(SHUFFLE_CHUNK_SPLIT)) {
            throw new IllegalArgumentException("Unexpected shuffle block id format: " + blockId);
        }
        return blockIdParts;
    }

    public void start() {
        this.client.sendRpc(this.message.toByteBuffer(), new RpcResponseCallback(){

            public void onSuccess(ByteBuffer response) {
                try {
                    OneForOneBlockFetcher.this.streamHandle = (StreamHandle)BlockTransferMessage.Decoder.fromByteBuffer(response);
                    logger.trace("Successfully opened blocks {}, preparing to fetch chunks.", (Object)OneForOneBlockFetcher.this.streamHandle);
                    for (int i = 0; i < ((OneForOneBlockFetcher)OneForOneBlockFetcher.this).streamHandle.numChunks; ++i) {
                        if (OneForOneBlockFetcher.this.downloadFileManager != null) {
                            OneForOneBlockFetcher.this.client.stream(OneForOneStreamManager.genStreamChunkId((long)((OneForOneBlockFetcher)OneForOneBlockFetcher.this).streamHandle.streamId, (int)i), (StreamCallback)new DownloadCallback(i));
                            continue;
                        }
                        OneForOneBlockFetcher.this.client.fetchChunk(((OneForOneBlockFetcher)OneForOneBlockFetcher.this).streamHandle.streamId, i, OneForOneBlockFetcher.this.chunkCallback);
                    }
                }
                catch (Exception e) {
                    logger.error("Failed while starting block fetches after success", (Throwable)e);
                    OneForOneBlockFetcher.this.failRemainingBlocks(OneForOneBlockFetcher.this.blockIds, e);
                }
            }

            public void onFailure(Throwable e) {
                logger.error("Failed while starting block fetches", e);
                OneForOneBlockFetcher.this.failRemainingBlocks(OneForOneBlockFetcher.this.blockIds, e);
            }
        });
    }

    private void failRemainingBlocks(String[] failedBlockIds, Throwable e) {
        for (String blockId : failedBlockIds) {
            try {
                this.listener.onBlockFetchFailure(blockId, e);
            }
            catch (Exception e2) {
                logger.error("Error in block fetch failure callback", (Throwable)e2);
            }
        }
    }

    private class DownloadCallback
    implements StreamCallback {
        private DownloadFileWritableChannel channel = null;
        private DownloadFile targetFile = null;
        private int chunkIndex;

        DownloadCallback(int chunkIndex) throws IOException {
            this.targetFile = OneForOneBlockFetcher.this.downloadFileManager.createTempFile(OneForOneBlockFetcher.this.transportConf);
            this.channel = this.targetFile.openForWriting();
            this.chunkIndex = chunkIndex;
        }

        public void onData(String streamId, ByteBuffer buf) throws IOException {
            while (buf.hasRemaining()) {
                this.channel.write(buf);
            }
        }

        public void onComplete(String streamId) throws IOException {
            OneForOneBlockFetcher.this.listener.onBlockFetchSuccess(OneForOneBlockFetcher.this.blockIds[this.chunkIndex], this.channel.closeAndRead());
            if (!OneForOneBlockFetcher.this.downloadFileManager.registerTempFileToClean(this.targetFile)) {
                this.targetFile.delete();
            }
        }

        public void onFailure(String streamId, Throwable cause) throws IOException {
            this.channel.close();
            String[] remainingBlockIds = Arrays.copyOfRange(OneForOneBlockFetcher.this.blockIds, this.chunkIndex, OneForOneBlockFetcher.this.blockIds.length);
            OneForOneBlockFetcher.this.failRemainingBlocks(remainingBlockIds, cause);
            this.targetFile.delete();
        }
    }

    private class ChunkCallback
    implements ChunkReceivedCallback {
        private ChunkCallback() {
        }

        public void onSuccess(int chunkIndex, ManagedBuffer buffer) {
            OneForOneBlockFetcher.this.listener.onBlockFetchSuccess(OneForOneBlockFetcher.this.blockIds[chunkIndex], buffer);
        }

        public void onFailure(int chunkIndex, Throwable e) {
            String[] remainingBlockIds = Arrays.copyOfRange(OneForOneBlockFetcher.this.blockIds, chunkIndex, OneForOneBlockFetcher.this.blockIds.length);
            OneForOneBlockFetcher.this.failRemainingBlocks(remainingBlockIds, e);
        }
    }

    private static class BlocksInfo {
        final ArrayList<Integer> ids = new ArrayList();
        final ArrayList<String> blockIds = new ArrayList();

        BlocksInfo() {
        }
    }
}

