/*
 * Decompiled with CFR 0.152.
 */
package org.drools.template.model;

import java.util.LinkedList;
import java.util.List;
import org.drools.template.model.AttributedDRLElement;
import org.drools.template.model.DRLJavaEmitter;
import org.drools.template.model.DRLOutput;
import org.drools.template.model.DeclaredType;
import org.drools.template.model.Functions;
import org.drools.template.model.Global;
import org.drools.template.model.Import;
import org.drools.template.model.Queries;
import org.drools.template.model.Rule;

public class Package
extends AttributedDRLElement
implements DRLJavaEmitter {
    private String name;
    private List<Import> imports;
    private List<Global> variables;
    private List<Rule> rules;
    private Functions functions;
    private Queries queries;
    private DeclaredType declaredTypes;
    private String ruleUnit;
    private String dialect;

    public Package(String name) {
        this.name = name;
        this.imports = new LinkedList<Import>();
        this.variables = new LinkedList<Global>();
        this.rules = new LinkedList<Rule>();
        this.functions = new Functions();
        this.queries = new Queries();
        this.declaredTypes = new DeclaredType();
    }

    public void addImport(Import imp) {
        this.imports.add(imp);
    }

    public void addVariable(Global varz) {
        this.variables.add(varz);
    }

    public void addRule(Rule rule) {
        this.rules.add(rule);
    }

    public void addFunctions(String listing) {
        this.functions.setFunctionsListing(listing);
    }

    public void addQueries(String listing) {
        this.queries.setQueriesListing(listing);
    }

    public void addDeclaredType(String declaration) {
        this.declaredTypes.setDeclaredTypeListing(declaration);
    }

    public String getName() {
        return this.name;
    }

    public List<Import> getImports() {
        return this.imports;
    }

    public List<Global> getVariables() {
        return this.variables;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public void setRuleUnit(String ruleUnit) {
        this.ruleUnit = ruleUnit;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    @Override
    public void renderDRL(DRLOutput out) {
        if (this.name != null) {
            out.writeLine("package " + this.name.replace(' ', '_') + ";");
        }
        if (this.ruleUnit != null) {
            out.writeLine("unit " + this.ruleUnit + ";");
        }
        if (this.dialect != null) {
            out.writeLine("dialect \"" + this.dialect + "\"");
        }
        out.writeLine("//generated from Decision Table");
        this.renderDRL(this.imports, out);
        this.renderDRL(this.variables, out);
        this.functions.renderDRL(out);
        this.queries.renderDRL(out);
        this.declaredTypes.renderDRL(out);
        super.renderDRL(out);
        this.renderDRL(this.rules, out);
    }

    private void renderDRL(List<? extends DRLJavaEmitter> list, DRLOutput out) {
        for (DRLJavaEmitter dRLJavaEmitter : list) {
            dRLJavaEmitter.renderDRL(out);
        }
    }
}

