/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressionUtils {
    static final Logger LOG = LoggerFactory.getLogger(CompressionUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tar(String parentDir, String[] inputFiles, String outputFile) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(new File(parentDir, outputFile));
            TarArchiveOutputStream tOut = new TarArchiveOutputStream((OutputStream)new GzipCompressorOutputStream((OutputStream)new BufferedOutputStream(out)));
            for (int i = 0; i < inputFiles.length; ++i) {
                File f = new File(parentDir, inputFiles[i]);
                TarArchiveEntry tarEntry = new TarArchiveEntry(f, f.getName());
                tOut.setLongFileMode(2);
                tOut.putArchiveEntry((ArchiveEntry)tarEntry);
                try (FileInputStream input = new FileInputStream(f);){
                    IOUtils.copy((InputStream)input, (OutputStream)tOut);
                }
                tOut.closeArchiveEntry();
            }
            tOut.close();
        }
        catch (Throwable throwable) {
            org.apache.hadoop.io.IOUtils.closeStream(out);
            throw throwable;
        }
        org.apache.hadoop.io.IOUtils.closeStream((Closeable)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(String parentDir, String[] inputFiles, String outputFile) throws IOException {
        ZipOutputStream output = null;
        try {
            output = new ZipOutputStream((OutputStream)new FileOutputStream(new File(parentDir, outputFile)));
            for (int i = 0; i < inputFiles.length; ++i) {
                File f = new File(parentDir, inputFiles[i]);
                output.putNextEntry(new ZipEntry(inputFiles[i]));
                try (FileInputStream input = new FileInputStream(f);){
                    IOUtils.copy((InputStream)input, (OutputStream)output);
                    continue;
                }
            }
        }
        catch (Throwable throwable) {
            org.apache.hadoop.io.IOUtils.closeStream(output);
            throw throwable;
        }
        org.apache.hadoop.io.IOUtils.closeStream((Closeable)output);
    }

    public static List<File> unTar(String inputFileName, String outputDirName) throws FileNotFoundException, IOException, ArchiveException {
        return CompressionUtils.unTar(inputFileName, outputDirName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> unTar(String inputFileName, String outputDirName, boolean flatten) throws FileNotFoundException, IOException, ArchiveException {
        File inputFile = new File(inputFileName);
        File outputDir = new File(outputDirName);
        LinkedList<File> untarredFiles = new LinkedList<File>();
        try (InputStream is = null;){
            is = inputFileName.endsWith(".gz") ? new GzipCompressorInputStream((InputStream)new FileInputStream(inputFile)) : new FileInputStream(inputFile);
            TarArchiveInputStream debInputStream = (TarArchiveInputStream)new ArchiveStreamFactory().createArchiveInputStream("tar", is);
            TarArchiveEntry entry = null;
            while ((entry = (TarArchiveEntry)debInputStream.getNextEntry()) != null) {
                File outputFile = new File(outputDir, entry.getName());
                if (!outputFile.toPath().toAbsolutePath().normalize().startsWith(outputDir.toPath().toAbsolutePath().normalize())) {
                    throw new IOException("Untarred file is not under the output directory");
                }
                if (entry.isDirectory()) {
                    if (flatten) continue;
                    LOG.debug(String.format("Attempting to write output directory %s.", outputFile.getAbsolutePath()));
                    if (!outputFile.exists()) {
                        LOG.debug(String.format("Attempting to create output directory %s.", outputFile.getAbsolutePath()));
                        if (!outputFile.mkdirs()) {
                            throw new IllegalStateException(String.format("Couldn't create directory %s.", outputFile.getAbsolutePath()));
                        }
                    }
                } else {
                    FileOutputStream outputFileStream;
                    if (flatten) {
                        File flatOutputFile = new File(outputDir, outputFile.getName());
                        LOG.debug(String.format("Creating flat output file %s.", flatOutputFile.getAbsolutePath()));
                        outputFileStream = new FileOutputStream(flatOutputFile);
                    } else if (!outputFile.getParentFile().exists()) {
                        LOG.debug(String.format("Attempting to create output directory %s.", outputFile.getParentFile().getAbsoluteFile()));
                        if (!outputFile.getParentFile().getAbsoluteFile().mkdirs()) {
                            throw new IllegalStateException(String.format("Couldn't create directory %s.", outputFile.getParentFile().getAbsolutePath()));
                        }
                        LOG.debug(String.format("Creating output file %s.", outputFile.getAbsolutePath()));
                        outputFileStream = new FileOutputStream(outputFile);
                    } else {
                        outputFileStream = new FileOutputStream(outputFile);
                    }
                    IOUtils.copy((InputStream)debInputStream, (OutputStream)outputFileStream);
                    ((OutputStream)outputFileStream).close();
                }
                untarredFiles.add(outputFile);
            }
            debInputStream.close();
            LinkedList<File> linkedList = untarredFiles;
            return linkedList;
        }
    }
}

