/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.tmpl;

import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryDisplay;
import org.apache.hadoop.hive.ql.QueryInfo;
import org.apache.hive.service.cli.operation.OperationLogManager;
import org.apache.hive.tmpl.QueryProfileTmpl;
import org.jamon.AbstractTemplateImpl;
import org.jamon.AbstractTemplateProxy;
import org.jamon.TemplateManager;
import org.jamon.emit.StandardEmitter;
import org.jamon.escaping.Escaping;

public class QueryProfileTmplImpl
extends AbstractTemplateImpl
implements QueryProfileTmpl.Intf {
    private final QueryInfo queryInfo;
    private final HiveConf hiveConf;
    private boolean showGraph = false;
    private boolean showStats = false;

    protected static QueryProfileTmpl.ImplData __jamon_setOptionalArguments(QueryProfileTmpl.ImplData p_implData) {
        return p_implData;
    }

    public QueryProfileTmplImpl(TemplateManager p_templateManager, QueryProfileTmpl.ImplData p_implData) {
        super(p_templateManager, (AbstractTemplateProxy.ImplData)QueryProfileTmplImpl.__jamon_setOptionalArguments(p_implData));
        this.queryInfo = p_implData.getQueryInfo();
        this.hiveConf = p_implData.getHiveConf();
    }

    @Override
    public void renderNoFlush(Writer jamonWriter) throws IOException {
        jamonWriter.write("<!--[if IE]>\n<!DOCTYPE html>\n<![endif]-->\n<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <title>HiveServer2</title>\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <meta name=\"description\" content=\"\">\n\n    <link href=\"/static/css/bootstrap.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/bootstrap-theme.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/hive.css\" rel=\"stylesheet\">\n\n    <script src=\"/static/js/jquery.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/bootstrap.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/tab.js\" type=\"text/javascript\"></script>\n    ");
        if (this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_SHOW_GRAPH) && this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_EXPLAIN_OUTPUT)) {
            jamonWriter.write("\n      ");
            this.showGraph = true;
            if (this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_SHOW_STATS)) {
                jamonWriter.write("\n        ");
                this.showStats = true;
            }
            jamonWriter.write("\n    ");
        }
        jamonWriter.write("\n    ");
        if (this.showGraph) {
            jamonWriter.write("\n      <script type=\"text/javascript\" src=\"/static/js/vis.min.js\"></script>\n      <link href=\"/static/css/query-plan-graph.css\" rel=\"stylesheet\">\n      <script src=\"/static/js/query-plan-graph.js\"></script>\n    ");
        }
        jamonWriter.write("\n  </head>\n\n  <body>\n  <div class=\"navbar  navbar-fixed-top navbar-default\">\n      <div class=\"container\">\n          <div class=\"navbar-header\">\n              <button type=\"button\" class=\"navbar-toggle\" data-toggle=\"collapse\" data-target=\".navbar-collapse\">\n                  <span class=\"icon-bar\"></span>\n                  <span class=\"icon-bar\"></span>\n                  <span class=\"icon-bar\"></span>\n              </button>\n              <a class=\"navbar-brand\" href=\"/hiveserver2.jsp\"><img src=\"/static/hive_logo.jpeg\" alt=\"Hive Logo\"/></a>\n          </div>\n          <div class=\"collapse navbar-collapse\">\n              <ul class=\"nav navbar-nav\">\n                <li class=\"active\"><a href=\"/\">Home</a></li>\n                <li><a href=\"/logs/\">Local logs</a></li>\n                <li><a href=\"/jmx\">Metrics Dump</a></li>\n                <li><a href=\"/conf\">Hive Configuration</a></li>\n                <li><a href=\"/stacks\">Stack Trace</a></li>\n            </ul>\n          </div><!--/.nav-collapse -->\n        </div>\n      </div>\n    </div>\n\n\n    ");
        if (this.queryInfo == null) {
            jamonWriter.write("\n         <div class=\"jumbotron\">\n           <p>Query not found.  It may have been deleted, increase <i>hive.server2.webui.max.historic.queries</i>\n              to retain more historic query information.</p>\n         </div>\n    ");
        } else {
            jamonWriter.write("\n\n\n    <div class=\"container\">\n      <div class=\"row inner_header\">\n        <div class=\"page-header\">\n          <h1>Query Information: ");
            Escaping.HTML.write(StandardEmitter.valueOf((String)(this.queryInfo.getQueryDisplay() == null ? "Unknown" : this.queryInfo.getQueryDisplay().getQueryString())), jamonWriter);
            jamonWriter.write("</h1>\n        </div>\n      </div>\n      <div class=\"row\">\n\n\n      <div class=\"tabbable\">\n          <ul class=\"nav nav-pills\">\n              <li class=\"active\"><a href=\"#tab_baseProfile\" data-toggle=\"tab\">Base Profile</a></li>\n              <li class=\"\"><a href=\"#tab_stages\" data-toggle=\"tab\">Stages</a></li>\n              <li class=\"\"><a href=\"#tab_queryPlan\" data-toggle=\"tab\">Query Plan</a></li>\n              <li class=\"\"><a href=\"#tab_perfLogging\" data-toggle=\"tab\">Performance Logging</a></li>\n              <li class=\"\"><a href=\"#tab_operationLog\" data-toggle=\"tab\">Operation Log</a></li>\n          </ul>\n          <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n              <div class=\"tab-pane active\" id=\"tab_baseProfile\">\n                  ");
            this.__jamon_innerUnit__baseProfile(jamonWriter, this.queryInfo);
            jamonWriter.write("\n              </div>\n              <div class=\"tab-pane\" id=\"tab_stages\">\n                  ");
            this.__jamon_innerUnit__stages(jamonWriter, this.queryInfo);
            jamonWriter.write("\n              </div>\n              <div class=\"tab-pane\" id=\"tab_queryPlan\">\n                  ");
            this.__jamon_innerUnit__queryPlan(jamonWriter, this.queryInfo);
            jamonWriter.write("\n              </div>\n              <div class=\"tab-pane\" id=\"tab_perfLogging\">\n                  ");
            this.__jamon_innerUnit__perfLogging(jamonWriter, this.queryInfo);
            jamonWriter.write("\n              </div>\n              <div class=\"tab-pane\" id=\"tab_operationLog\">\n                  ");
            this.__jamon_innerUnit__operationLog(jamonWriter, this.queryInfo);
            jamonWriter.write("\n              </div>\n          </div>\n      </div>\n\n   ");
        }
        jamonWriter.write("\n\n</div>\n</div>\n<script src=\"/static/js/jquery.min.js\" type=\"text/javascript\"></script>\n<script src=\"/static/js/bootstrap.min.js\" type=\"text/javascript\"></script>\n<script src=\"/static/js/tab.js\" type=\"text/javascript\"></script>\n</body>\n</html>\n\n");
        if (this.showGraph) {
            jamonWriter.write("\n  <script type=\"text/javascript\">\n    // reload network to centralize graph upon switching to \"Query Plan\" tab\n    $('a[data-toggle=\"tab\"]').on('shown.bs.tab', function (e) {\n      if (e.target.toString().includes(\"queryPlan\") && typeof network !== 'undefined') {\n        network.fit();\n      }\n    });\n  </script>\n");
        }
        jamonWriter.write("\n\n\n</div>\n</div>\n</body>\n</html>\n");
    }

    private void __jamon_innerUnit__baseProfile(Writer jamonWriter, QueryInfo queryInfo) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n        <tr>\n            <td>User Name</td>\n            <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)queryInfo.getUserName()), jamonWriter);
        jamonWriter.write("</td>\n        </tr>\n        <tr>\n            <td>Query String</td>\n            <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)(queryInfo.getQueryDisplay() == null ? "Unknown" : queryInfo.getQueryDisplay().getQueryString())), jamonWriter);
        jamonWriter.write("</td>\n        </tr>\n        <tr>\n            <td>Id</td>\n            <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)(queryInfo.getQueryDisplay() == null ? "Unknown" : queryInfo.getQueryDisplay().getQueryId())), jamonWriter);
        jamonWriter.write("</td>\n        </tr>\n        <tr>\n            <td>Execution Engine</td>\n            <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)queryInfo.getExecutionEngine()), jamonWriter);
        jamonWriter.write("\n        </tr>\n        <tr>\n            <td>State</td>\n            <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)queryInfo.getState()), jamonWriter);
        jamonWriter.write("</td>\n        </tr>\n        <tr>\n            <td>Opened Timestamp</td>\n            <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((Object)new Date(queryInfo.getBeginTime())), jamonWriter);
        jamonWriter.write("</td>\n        </tr>\n        <tr>\n            <td>Opened (s)</td>\n            <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((long)(queryInfo.getElapsedTime() / 1000L)), jamonWriter);
        jamonWriter.write("</td>\n        </tr>\n        <tr>\n            <td>Closed Timestamp</td>\n            <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((Object)(queryInfo.getEndTime() == null ? "Open" : new Date(queryInfo.getEndTime()))), jamonWriter);
        jamonWriter.write("</td>\n        </tr>\n        ");
        if (queryInfo.getQueryDisplay() != null && queryInfo.getQueryDisplay().getErrorMessage() != null) {
            jamonWriter.write("\n            <tr>\n                <td>Error</td>\n                <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)queryInfo.getQueryDisplay().getErrorMessage()), jamonWriter);
            jamonWriter.write("</td>\n            </tr>\n        ");
        }
        jamonWriter.write("\n        <tr>\n            <td>Latency (s)</td>\n            <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((Object)(queryInfo.getRuntime() == null ? "Not finished" : Long.valueOf(queryInfo.getRuntime() / 1000L))), jamonWriter);
        jamonWriter.write("</td>\n        </tr>\n    </table>\n");
    }

    private void __jamon_innerUnit__operationLog(Writer jamonWriter, QueryInfo queryInfo) throws IOException {
        jamonWriter.write("<div class=\"panel panel-default\">\n     <pre> ");
        Escaping.HTML.write(StandardEmitter.valueOf((String)OperationLogManager.getOperationLog(queryInfo)), jamonWriter);
        jamonWriter.write("</pre>\n</div>\n");
    }

    private void __jamon_innerUnit__stages(Writer jamonWriter, QueryInfo queryInfo) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n       <tr>\n           <th>Stage Id</th>\n           <th>Status</th>\n           <th>Begin Time</th>\n           <th>End Time</th>\n           <th>Elapsed Time (s)</th>\n           <th>Requires Lock</th>\n        </tr>\n\n       ");
        if (queryInfo.getQueryDisplay() != null && queryInfo.getQueryDisplay().getTaskDisplays() != null) {
            jamonWriter.write("\n           ");
            for (QueryDisplay.TaskDisplay taskDisplay : queryInfo.getQueryDisplay().getTaskDisplays()) {
                jamonWriter.write("\n               <tr>\n                   <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)(taskDisplay.getTaskId() + ":" + taskDisplay.getTaskType())), jamonWriter);
                jamonWriter.write("</td>\n                   <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)taskDisplay.getStatus()), jamonWriter);
                jamonWriter.write("</td>\n                   <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((Object)(taskDisplay.getBeginTime() == null ? "" : new Date(taskDisplay.getBeginTime()))), jamonWriter);
                jamonWriter.write("</td>\n                   <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((Object)(taskDisplay.getEndTime() == null ? "" : new Date(taskDisplay.getEndTime()))), jamonWriter);
                jamonWriter.write("</td>\n                   <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((Object)(taskDisplay.getElapsedTime() == null ? "" : Long.valueOf(taskDisplay.getElapsedTime() / 1000L))), jamonWriter);
                jamonWriter.write(" (s) </td>\n                   <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((boolean)taskDisplay.isRequireLock()), jamonWriter);
                jamonWriter.write("</td>\n               </tr>\n           ");
            }
            jamonWriter.write("\n       ");
        }
        jamonWriter.write("\n   </table>\n");
    }

    private void __jamon_innerUnit__queryPlan(Writer jamonWriter, QueryInfo queryInfo) throws IOException {
        jamonWriter.write("<div class=\"panel panel-default\">\n      <div class=\"panel-heading\">Explain plan</div>\n      <div class=\"panel-body\">\n        ");
        if (this.showGraph) {
            jamonWriter.write("\n          ");
            if (queryInfo.getQueryDisplay() != null && queryInfo.getQueryDisplay().getExplainPlan() != null && !queryInfo.getQueryDisplay().getExplainPlan().equals("UNKNOWN")) {
                jamonWriter.write("\n            <div id='plan-visualization'></div>\n            ");
                if (this.showStats) {
                    jamonWriter.write("\n              <div class=\"row\">\n                <div class=\"col-md-6\">\n                  <pre id='stage-info'></pre>\n                </div>\n                <div class=\"col-md-6\">\n                  <pre id='statistics-info'><div id='statistics-info-head'></div><div id='statistics-info-body'></div></pre>\n                </div>\n              </div>\n            ");
                } else {
                    jamonWriter.write("\n              <pre id='stage-info'></pre>\n            ");
                }
                jamonWriter.write("\n            <script type=\"text/javascript\">\n              var jsonPlan = ");
                Escaping.HTML.write(StandardEmitter.valueOf((String)queryInfo.getQueryDisplay().getExplainPlan()), jamonWriter);
                jamonWriter.write("\n              var jsonStatuses = {};\n              var jsonStatistics = {};\n              var jsonLogs = {};\n              ");
                if (queryInfo.getOperationLogLocation() != null) {
                    jamonWriter.write("\n                jsonLogs[\"Operation Log - will be deleted after query completes\"] = \"");
                    Escaping.HTML.write(StandardEmitter.valueOf((String)queryInfo.getOperationLogLocation()), jamonWriter);
                    jamonWriter.write("\"\n              ");
                }
                jamonWriter.write("\n              ");
                if (queryInfo.getQueryDisplay().getFullLogLocation() != null) {
                    jamonWriter.write("\n                jsonLogs[\"Full Log\"] = \"");
                    Escaping.HTML.write(StandardEmitter.valueOf((String)queryInfo.getQueryDisplay().getFullLogLocation()), jamonWriter);
                    jamonWriter.write("\"\n              ");
                }
                jamonWriter.write("\n              ");
                for (QueryDisplay.TaskDisplay taskDisplay : queryInfo.getQueryDisplay().getTaskDisplays()) {
                    jamonWriter.write("\n                jsonStatuses[\"");
                    Escaping.HTML.write(StandardEmitter.valueOf((String)taskDisplay.getTaskId()), jamonWriter);
                    jamonWriter.write("\"] = \"");
                    Escaping.HTML.write(StandardEmitter.valueOf((String)taskDisplay.getStatus()), jamonWriter);
                    jamonWriter.write("\";\n                ");
                    if (this.showStats && taskDisplay.getStatsJsonString() != null) {
                        jamonWriter.write("\n                  jsonStatistics[\"");
                        Escaping.HTML.write(StandardEmitter.valueOf((String)taskDisplay.getTaskId()), jamonWriter);
                        jamonWriter.write("\"] = ");
                        Escaping.HTML.write(StandardEmitter.valueOf((String)taskDisplay.getStatsJsonString()), jamonWriter);
                        jamonWriter.write(";\n                ");
                    }
                    jamonWriter.write("\n              ");
                }
                jamonWriter.write("\n              const MAP_PROGRESS = '");
                Escaping.HTML.write(StandardEmitter.valueOf((String)"Map Progress (%)"), jamonWriter);
                jamonWriter.write("';\n              const REDUCE_PROGRESS = '");
                Escaping.HTML.write(StandardEmitter.valueOf((String)"Reduce Progress (%)"), jamonWriter);
                jamonWriter.write("';\n              network = visualizeJsonPlan('plan-visualization', 'stage-info', 'statistics-info', 'statistics-info-head',\n                'statistics-info-body', jsonPlan, jsonStatuses, jsonStatistics, jsonLogs);\n            </script>\n          ");
            } else {
                jamonWriter.write("\n            <pre>Query information not available. Query may have failed or plan size may exceed value of config hive.server2.webui.max.graph.size.</pre>\n          ");
            }
            jamonWriter.write("\n        ");
        } else {
            jamonWriter.write("\n          ");
            if (this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_WEBUI_EXPLAIN_OUTPUT)) {
                jamonWriter.write("\n            <pre>\n            ");
                Escaping.HTML.write(StandardEmitter.valueOf((String)(queryInfo.getQueryDisplay() == null ? "Unknown" : queryInfo.getQueryDisplay().getExplainPlan())), jamonWriter);
                jamonWriter.write("\n            </pre>\n          ");
            } else {
                jamonWriter.write("\n            <pre>\n            Set configuration hive.server2.webui.explain.output to true to view future query plans\n            </pre>\n          ");
            }
            jamonWriter.write("\n        ");
        }
        jamonWriter.write("\n      </div>\n    </div>\n");
    }

    private void __jamon_innerUnit__perfLogging(Writer jamonWriter, QueryInfo queryInfo) throws IOException {
        jamonWriter.write("<section>\n      <h3>Compile-time metadata operations</h3>\n        <table class=\"table table-striped\">\n          <tr>\n             <th>Call Name</th>\n             <th>Time (ms)</th>\n          </tr>\n\n          ");
        if (queryInfo.getQueryDisplay() != null && queryInfo.getQueryDisplay().getHmsTimings(QueryDisplay.Phase.COMPILATION) != null) {
            jamonWriter.write("\n             ");
            for (Map.Entry time : queryInfo.getQueryDisplay().getHmsTimings(QueryDisplay.Phase.COMPILATION).entrySet()) {
                jamonWriter.write("\n                 <tr>\n                     <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)((String)time.getKey())), jamonWriter);
                jamonWriter.write("</td>\n                     <td>");
                Escaping.HTML.write(StandardEmitter.valueOf(time.getValue()), jamonWriter);
                jamonWriter.write("</td>\n                 </tr>\n             ");
            }
            jamonWriter.write("\n         ");
        }
        jamonWriter.write("\n        </table>\n      </section>\n\n    <section>\n      <h3>Execution-time metadata operations</h3>\n        <table class=\"table table-striped\">\n          <tr>\n             <th>Call Name</th>\n             <th>Time (ms)</th>\n          </tr>\n\n          ");
        if (queryInfo.getQueryDisplay() != null && queryInfo.getQueryDisplay().getHmsTimings(QueryDisplay.Phase.EXECUTION) != null) {
            jamonWriter.write("\n             ");
            for (Map.Entry time : queryInfo.getQueryDisplay().getHmsTimings(QueryDisplay.Phase.EXECUTION).entrySet()) {
                jamonWriter.write("\n                 <tr>\n                     <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)((String)time.getKey())), jamonWriter);
                jamonWriter.write("</td>\n                     <td>");
                Escaping.HTML.write(StandardEmitter.valueOf(time.getValue()), jamonWriter);
                jamonWriter.write("</td>\n                 </tr>\n             ");
            }
            jamonWriter.write("\n         ");
        }
        jamonWriter.write("\n        </table>\n      </section>\n\n    <section>\n      <h3>Compile-Time Perf-Logger</h3>\n        <table class=\"table table-striped\">\n          <tr>\n             <th>Compile-time Call Name</th>\n             <th>Time (ms)</th>\n          </tr>\n\n          ");
        if (queryInfo.getQueryDisplay() != null && queryInfo.getQueryDisplay().getPerfLogTimes(QueryDisplay.Phase.COMPILATION) != null) {
            jamonWriter.write("\n             ");
            for (Map.Entry time : queryInfo.getQueryDisplay().getPerfLogTimes(QueryDisplay.Phase.COMPILATION).entrySet()) {
                jamonWriter.write("\n                 <tr>\n                     <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)((String)time.getKey())), jamonWriter);
                jamonWriter.write("</td>\n                     <td>");
                Escaping.HTML.write(StandardEmitter.valueOf(time.getValue()), jamonWriter);
                jamonWriter.write("</td>\n                 </tr>\n             ");
            }
            jamonWriter.write("\n         ");
        }
        jamonWriter.write("\n        </table>\n      </section>\n\n    <section>\n      <h3>Execution-Time Perf-Logger</h3>\n        <table class=\"table table-striped\">\n          <tr>\n             <th>Execution-time Call Name</th>\n             <th>Time (ms)</th>\n          </tr>\n\n          ");
        if (queryInfo.getQueryDisplay() != null && queryInfo.getQueryDisplay().getPerfLogTimes(QueryDisplay.Phase.EXECUTION) != null) {
            jamonWriter.write("\n             ");
            for (Map.Entry time : queryInfo.getQueryDisplay().getPerfLogTimes(QueryDisplay.Phase.EXECUTION).entrySet()) {
                jamonWriter.write("\n                 <tr>\n                     <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)((String)time.getKey())), jamonWriter);
                jamonWriter.write("</td>\n                     <td>");
                Escaping.HTML.write(StandardEmitter.valueOf(time.getValue()), jamonWriter);
                jamonWriter.write("</td>\n                 </tr>\n             ");
            }
            jamonWriter.write("\n         ");
        }
        jamonWriter.write("\n        </table>\n      </section>\n");
    }
}

