/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.triggers;

import java.util.List;
import java.util.Objects;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.AfterDelayFromFirstElementStateMachine;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.TriggerStateMachine;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Instant;

public class AfterProcessingTimeStateMachine
extends AfterDelayFromFirstElementStateMachine {
    @Override
    public @Nullable Instant getCurrentTime(TriggerStateMachine.TriggerContext context) {
        return context.currentProcessingTime();
    }

    private AfterProcessingTimeStateMachine(List<SerializableFunction<Instant, Instant>> transforms) {
        super(TimeDomain.PROCESSING_TIME, transforms);
    }

    public static AfterProcessingTimeStateMachine pastFirstElementInPane() {
        return new AfterProcessingTimeStateMachine(IDENTITY);
    }

    @Override
    protected AfterProcessingTimeStateMachine newWith(List<SerializableFunction<Instant, Instant>> transforms) {
        return new AfterProcessingTimeStateMachine(transforms);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("AfterProcessingTime.pastFirstElementInPane()");
        for (SerializableFunction delayFn : this.timestampMappers) {
            builder.append(".plusDelayOf(").append(delayFn).append(")");
        }
        return builder.toString();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AfterProcessingTimeStateMachine)) {
            return false;
        }
        AfterProcessingTimeStateMachine that = (AfterProcessingTimeStateMachine)obj;
        return Objects.equals(this.timestampMappers, that.timestampMappers);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getClass(), this.timestampMappers);
    }
}

