/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.transforms.kinesis;

import com.amazonaws.regions.Regions;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.engines.IBeamPipelineEngineRunConfiguration;
import org.apache.hop.beam.pipeline.IBeamPipelineTransformHandler;
import org.apache.hop.beam.transforms.kinesis.BeamKinesisConsume;
import org.apache.hop.beam.transforms.kinesis.BeamKinesisConsumeDialog;
import org.apache.hop.beam.transforms.kinesis.BeamKinesisConsumeTransform;
import org.apache.hop.core.Const;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.JsonRowMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.dummy.DummyData;

@Transform(id="BeamKinesisConsume", name="i18n::BeamKinesisConsumeMeta.name", description="i18n::BeamKinesisConsumeMeta.description", image="beam-kinesis-consume.svg", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.BigData", keywords={"i18n::BeamKinesisConsumeMeta.keyword"}, documentationUrl="/pipeline/transforms/beamkinesisconsume.html")
public class BeamKinesisConsumeMeta
extends BaseTransformMeta<BeamKinesisConsume, DummyData>
implements IBeamPipelineTransformHandler {
    @HopMetadataProperty(key="access_key")
    private String accessKey;
    @HopMetadataProperty(key="secret_key", password=true)
    private String secretKey;
    @HopMetadataProperty(key="stream_name", password=true)
    private String streamName = "stream";
    @HopMetadataProperty(key="unique_id_field")
    private String uniqueIdField = "id";
    @HopMetadataProperty(key="data_field")
    private String dataField = "data";
    @HopMetadataProperty(key="message_type")
    private String dataType = "String";
    @HopMetadataProperty(key="partition_key_field")
    private String partitionKeyField = "partitionKey";
    @HopMetadataProperty(key="sequence_number_field")
    private String sequenceNumberField = "sequenceNumber";
    @HopMetadataProperty(key="sub_sequence_number_field")
    private String subSequenceNumberField = "SubSequenceNumber";
    @HopMetadataProperty(key="shard_id_field")
    private String shardIdField = "shardId";
    @HopMetadataProperty(key="stream_name_field")
    private String streamNameField = "streamName";
    @HopMetadataProperty(key="max_num_records")
    private String maxNumRecords;
    @HopMetadataProperty(key="max_read_time_ms")
    private String maxReadTimeMs;
    @HopMetadataProperty(key="up_to_date_threshold_ms")
    private String upToDateThresholdMs;
    @HopMetadataProperty(key="request_records_limit")
    private String requestRecordsLimit;
    @HopMetadataProperty(key="arrival_time_watermark_polity")
    private boolean arrivalTimeWatermarkPolicy;
    @HopMetadataProperty(key="arrival_time_watermark_polity_ms")
    private String arrivalTimeWatermarkPolicyMs;
    @HopMetadataProperty(key="processing_time_watermark_polity")
    private boolean processingTimeWatermarkPolicy;
    @HopMetadataProperty(key="fixed_delay_rate_polity")
    private boolean fixedDelayRatePolicy;
    @HopMetadataProperty(key="fixed_delay_rate_polity_ms")
    private String fixedDelayRatePolicyMs;
    @HopMetadataProperty(key="max_capacity_per_shard")
    private String maxCapacityPerShard;

    public String getDialogClassName() {
        return BeamKinesisConsumeDialog.class.getName();
    }

    public void getFields(IRowMeta inputRowMeta, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        try {
            String fieldName;
            String shardId;
            String subSequenceNumber;
            String sequenceNumber;
            String uniqueId = variables.resolve(this.uniqueIdField);
            if (StringUtils.isNotEmpty((String)uniqueId)) {
                ValueMetaString valueMeta = new ValueMetaString(uniqueId);
                valueMeta.setOrigin(origin);
                inputRowMeta.addValueMeta((IValueMeta)valueMeta);
            }
            String typeString = Const.NVL((String)variables.resolve(this.dataType), (String)"String");
            int type = ValueMetaFactory.getIdForValueMeta((String)typeString);
            IValueMeta messageValueMeta = ValueMetaFactory.createValueMeta((String)variables.resolve(this.dataField), (int)type);
            messageValueMeta.setOrigin(origin);
            inputRowMeta.addValueMeta(messageValueMeta);
            String partitionKey = variables.resolve(this.partitionKeyField);
            if (StringUtils.isNotEmpty((String)partitionKey)) {
                ValueMetaString valueMeta = new ValueMetaString(partitionKey);
                valueMeta.setOrigin(origin);
                inputRowMeta.addValueMeta((IValueMeta)valueMeta);
            }
            if (StringUtils.isNotEmpty((String)(sequenceNumber = variables.resolve(this.sequenceNumberField)))) {
                ValueMetaString valueMeta = new ValueMetaString(sequenceNumber);
                valueMeta.setOrigin(origin);
                inputRowMeta.addValueMeta((IValueMeta)valueMeta);
            }
            if (StringUtils.isNotEmpty((String)(subSequenceNumber = variables.resolve(this.subSequenceNumberField)))) {
                ValueMetaInteger valueMeta = new ValueMetaInteger(subSequenceNumber);
                valueMeta.setOrigin(origin);
                inputRowMeta.addValueMeta((IValueMeta)valueMeta);
            }
            if (StringUtils.isNotEmpty((String)(shardId = variables.resolve(this.shardIdField)))) {
                ValueMetaString valueMeta = new ValueMetaString(shardId);
                valueMeta.setOrigin(origin);
                inputRowMeta.addValueMeta((IValueMeta)valueMeta);
            }
            if (StringUtils.isNotEmpty((String)(fieldName = variables.resolve(this.streamNameField)))) {
                ValueMetaString valueMeta = new ValueMetaString(fieldName);
                valueMeta.setOrigin(origin);
                inputRowMeta.addValueMeta((IValueMeta)valueMeta);
            }
        }
        catch (Exception e) {
            throw new HopTransformException("Error calculating transform output field layout", (Throwable)e);
        }
    }

    public boolean isInput() {
        return true;
    }

    public boolean isOutput() {
        return false;
    }

    public void handleTransform(ILogChannel log, IVariables variables, String runConfigurationName, IBeamPipelineEngineRunConfiguration runConfiguration, String dataSamplersJson, IHopMetadataProvider metadataProvider, PipelineMeta pipelineMeta, TransformMeta transformMeta, Map<String, PCollection<HopRow>> transformCollectionMap, Pipeline pipeline, IRowMeta rowMeta, List<TransformMeta> previousTransforms, PCollection<HopRow> input, String parentLogChannelId) throws HopException {
        RowMeta outputRowMeta = new RowMeta();
        this.getFields((IRowMeta)outputRowMeta, transformMeta.getName(), null, null, variables, null);
        BeamKinesisConsumeTransform beamInputTransform = new BeamKinesisConsumeTransform(transformMeta.getName(), variables.resolve(this.accessKey), variables.resolve(this.secretKey), Regions.DEFAULT_REGION, JsonRowMeta.toJson((IRowMeta)outputRowMeta), variables.resolve(this.streamName), variables.resolve(this.uniqueIdField), variables.resolve(this.dataField), variables.resolve(this.dataType), variables.resolve(this.partitionKeyField), variables.resolve(this.sequenceNumberField), variables.resolve(this.subSequenceNumberField), variables.resolve(this.shardIdField), variables.resolve(this.streamNameField), variables.resolve(this.maxNumRecords), variables.resolve(this.maxReadTimeMs), variables.resolve(this.upToDateThresholdMs), variables.resolve(this.requestRecordsLimit), this.arrivalTimeWatermarkPolicy, variables.resolve(this.arrivalTimeWatermarkPolicyMs), this.processingTimeWatermarkPolicy, this.fixedDelayRatePolicy, variables.resolve(this.fixedDelayRatePolicyMs), variables.resolve(this.maxCapacityPerShard));
        PCollection afterInput = (PCollection)pipeline.apply((PTransform)beamInputTransform);
        transformCollectionMap.put(transformMeta.getName(), (PCollection<HopRow>)afterInput);
        log.logBasic("Handled transform (KINESIS CONSUME) : " + transformMeta.getName());
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    public String getUniqueIdField() {
        return this.uniqueIdField;
    }

    public void setUniqueIdField(String uniqueIdField) {
        this.uniqueIdField = uniqueIdField;
    }

    public String getDataField() {
        return this.dataField;
    }

    public void setDataField(String dataField) {
        this.dataField = dataField;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getPartitionKeyField() {
        return this.partitionKeyField;
    }

    public void setPartitionKeyField(String partitionKeyField) {
        this.partitionKeyField = partitionKeyField;
    }

    public String getSequenceNumberField() {
        return this.sequenceNumberField;
    }

    public void setSequenceNumberField(String sequenceNumberField) {
        this.sequenceNumberField = sequenceNumberField;
    }

    public String getSubSequenceNumberField() {
        return this.subSequenceNumberField;
    }

    public void setSubSequenceNumberField(String subSequenceNumberField) {
        this.subSequenceNumberField = subSequenceNumberField;
    }

    public String getShardIdField() {
        return this.shardIdField;
    }

    public void setShardIdField(String shardIdField) {
        this.shardIdField = shardIdField;
    }

    public String getStreamNameField() {
        return this.streamNameField;
    }

    public void setStreamNameField(String streamNameField) {
        this.streamNameField = streamNameField;
    }

    public String getMaxNumRecords() {
        return this.maxNumRecords;
    }

    public void setMaxNumRecords(String maxNumRecords) {
        this.maxNumRecords = maxNumRecords;
    }

    public String getMaxReadTimeMs() {
        return this.maxReadTimeMs;
    }

    public void setMaxReadTimeMs(String maxReadTimeMs) {
        this.maxReadTimeMs = maxReadTimeMs;
    }

    public String getUpToDateThresholdMs() {
        return this.upToDateThresholdMs;
    }

    public void setUpToDateThresholdMs(String upToDateThresholdMs) {
        this.upToDateThresholdMs = upToDateThresholdMs;
    }

    public String getRequestRecordsLimit() {
        return this.requestRecordsLimit;
    }

    public void setRequestRecordsLimit(String requestRecordsLimit) {
        this.requestRecordsLimit = requestRecordsLimit;
    }

    public boolean isArrivalTimeWatermarkPolicy() {
        return this.arrivalTimeWatermarkPolicy;
    }

    public void setArrivalTimeWatermarkPolicy(boolean arrivalTimeWatermarkPolicy) {
        this.arrivalTimeWatermarkPolicy = arrivalTimeWatermarkPolicy;
    }

    public String getArrivalTimeWatermarkPolicyMs() {
        return this.arrivalTimeWatermarkPolicyMs;
    }

    public void setArrivalTimeWatermarkPolicyMs(String arrivalTimeWatermarkPolicyMs) {
        this.arrivalTimeWatermarkPolicyMs = arrivalTimeWatermarkPolicyMs;
    }

    public boolean isProcessingTimeWatermarkPolicy() {
        return this.processingTimeWatermarkPolicy;
    }

    public void setProcessingTimeWatermarkPolicy(boolean processingTimeWatermarkPolicy) {
        this.processingTimeWatermarkPolicy = processingTimeWatermarkPolicy;
    }

    public boolean isFixedDelayRatePolicy() {
        return this.fixedDelayRatePolicy;
    }

    public void setFixedDelayRatePolicy(boolean fixedDelayRatePolicy) {
        this.fixedDelayRatePolicy = fixedDelayRatePolicy;
    }

    public String getFixedDelayRatePolicyMs() {
        return this.fixedDelayRatePolicyMs;
    }

    public void setFixedDelayRatePolicyMs(String fixedDelayRatePolicyMs) {
        this.fixedDelayRatePolicyMs = fixedDelayRatePolicyMs;
    }

    public String getMaxCapacityPerShard() {
        return this.maxCapacityPerShard;
    }

    public void setMaxCapacityPerShard(String maxCapacityPerShard) {
        this.maxCapacityPerShard = maxCapacityPerShard;
    }
}

