/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.excelwriter;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.excelwriter.ExcelWriterOutputField;
import org.apache.hop.pipeline.transforms.excelwriter.ExcelWriterTransformData;
import org.apache.hop.pipeline.transforms.excelwriter.ExcelWriterTransformMeta;
import org.apache.hop.pipeline.transforms.excelwriter.ExcelWriterWorkbookDefinition;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelWriterTransform
extends BaseTransform<ExcelWriterTransformMeta, ExcelWriterTransformData> {
    private static final Class<?> PKG = ExcelWriterTransformMeta.class;
    public static final String STREAMER_FORCE_RECALC_PROP_NAME = "HOP_EXCEL_WRITER_STREAMER_FORCE_RECALCULATE";

    public ExcelWriterTransform(TransformMeta transformMeta, ExcelWriterTransformMeta meta, ExcelWriterTransformData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        int i;
        Object[] r = this.getRow();
        if (this.first) {
            this.first = false;
            if (r == null) {
                ((ExcelWriterTransformData)this.data).outputRowMeta = new RowMeta();
                ((ExcelWriterTransformData)this.data).inputRowMeta = new RowMeta();
            } else {
                ((ExcelWriterTransformData)this.data).outputRowMeta = this.getInputRowMeta().clone();
                ((ExcelWriterTransformData)this.data).inputRowMeta = this.getInputRowMeta().clone();
            }
            if (!((ExcelWriterTransformMeta)this.meta).getFile().isDoNotOpenNewFileInit()) {
                try {
                    this.prepareNextOutputFile(r);
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"ExcelWriterTransform.Exception.CouldNotPrepareFile", (String[])new String[]{this.resolve(((ExcelWriterTransformMeta)this.meta).getFile().getFileName())}));
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
            }
            if (r != null) {
                if (((ExcelWriterTransformMeta)this.meta).getFile().isDoNotOpenNewFileInit()) {
                    this.prepareNextOutputFile(r);
                }
                int outputFieldsCount = ((ExcelWriterTransformMeta)this.meta).getOutputFields().size();
                ((ExcelWriterTransformData)this.data).commentauthorfieldnrs = new int[outputFieldsCount];
                ((ExcelWriterTransformData)this.data).commentfieldnrs = new int[outputFieldsCount];
                ((ExcelWriterTransformData)this.data).linkfieldnrs = new int[outputFieldsCount];
                ((ExcelWriterTransformData)this.data).fieldnrs = new int[outputFieldsCount];
                i = 0;
                for (ExcelWriterOutputField outputField : ((ExcelWriterTransformMeta)this.meta).getOutputFields()) {
                    String outputFieldName = outputField.getName();
                    ((ExcelWriterTransformData)this.data).fieldnrs[i] = ((ExcelWriterTransformData)this.data).inputRowMeta.indexOfValue(outputFieldName);
                    if (((ExcelWriterTransformData)this.data).fieldnrs[i] < 0) {
                        this.logError("Field [" + outputFieldName + "] couldn't be found in the input stream!");
                        this.setErrors(1L);
                        this.stopAll();
                        return false;
                    }
                    String commentField = outputField.getCommentField();
                    ((ExcelWriterTransformData)this.data).commentfieldnrs[i] = ((ExcelWriterTransformData)this.data).inputRowMeta.indexOfValue(commentField);
                    if (((ExcelWriterTransformData)this.data).commentfieldnrs[i] < 0 && !Utils.isEmpty((CharSequence)commentField)) {
                        this.logError("Comment Field [" + commentField + "] couldn't be found in the input stream!");
                        this.setErrors(1L);
                        this.stopAll();
                        return false;
                    }
                    String commentAuthorField = outputField.getCommentAuthorField();
                    ((ExcelWriterTransformData)this.data).commentauthorfieldnrs[i] = ((ExcelWriterTransformData)this.data).inputRowMeta.indexOfValue(commentAuthorField);
                    if (((ExcelWriterTransformData)this.data).commentauthorfieldnrs[i] < 0 && !Utils.isEmpty((CharSequence)commentAuthorField)) {
                        this.logError("Comment Author Field [" + commentAuthorField + "] couldn't be found in the input stream!");
                        this.setErrors(1L);
                        this.stopAll();
                        return false;
                    }
                    String hyperlinkField = outputField.getHyperlinkField();
                    ((ExcelWriterTransformData)this.data).linkfieldnrs[i] = ((ExcelWriterTransformData)this.data).inputRowMeta.indexOfValue(hyperlinkField);
                    if (((ExcelWriterTransformData)this.data).linkfieldnrs[i] < 0 && !Utils.isEmpty((CharSequence)hyperlinkField)) {
                        this.logError("Link Field [" + hyperlinkField + "] couldn't be found in the input stream!");
                        this.setErrors(1L);
                        this.stopAll();
                        return false;
                    }
                    ++i;
                }
            }
        }
        if (r != null) {
            if (((ExcelWriterTransformMeta)this.meta).getFile().isFileNameInField()) {
                if (((ExcelWriterTransformData)this.data).isBeamContext()) {
                    throw new HopException("Storing filenames in an input field is not supported in Beam pipelines");
                }
                if (!((ExcelWriterTransformData)this.data).currentWorkbookDefinition.getFile().equals(this.getFileLocation(r))) {
                    boolean fileFound = false;
                    for (i = 0; i < ((ExcelWriterTransformData)this.data).usedFiles.size(); ++i) {
                        if (!((ExcelWriterTransformData)this.data).usedFiles.get(i).getFile().equals(this.getFileLocation(r))) continue;
                        fileFound = true;
                        ((ExcelWriterTransformData)this.data).currentWorkbookDefinition = ((ExcelWriterTransformData)this.data).usedFiles.get(i);
                        break;
                    }
                    if (!fileFound) {
                        this.prepareNextOutputFile(r);
                    }
                }
            }
            if (!((ExcelWriterTransformMeta)this.meta).isAppendLines() && !((ExcelWriterTransformMeta)this.meta).getFile().isFileNameInField() && ((ExcelWriterTransformMeta)this.meta).getFile().getSplitEvery() > 0 && ((ExcelWriterTransformData)this.data).currentWorkbookDefinition.getDatalines() > 0 && ((ExcelWriterTransformData)this.data).currentWorkbookDefinition.getDatalines() % ((ExcelWriterTransformMeta)this.meta).getFile().getSplitEvery() == 0) {
                this.prepareNextOutputFile(r);
            }
            this.writeNextLine(((ExcelWriterTransformData)this.data).currentWorkbookDefinition, r);
            this.incrementLinesOutput();
            ((ExcelWriterTransformData)this.data).currentWorkbookDefinition.setDatalines(((ExcelWriterTransformData)this.data).currentWorkbookDefinition.getDatalines() + 1);
            this.putRow(((ExcelWriterTransformData)this.data).outputRowMeta, r);
            if (this.checkFeedback(this.getLinesOutput()) && this.log.isBasic()) {
                this.logBasic("Linenr " + this.getLinesOutput());
            }
            return true;
        }
        this.closeFiles();
        this.setOutputDone();
        return false;
    }

    public void closeFiles() throws HopException {
        for (ExcelWriterWorkbookDefinition workbookDefinition : ((ExcelWriterTransformData)this.data).usedFiles) {
            this.closeOutputFile(workbookDefinition);
        }
        ((ExcelWriterTransformData)this.data).usedFiles.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createParentFolder(FileObject filename) throws Exception {
        block13: {
            FileObject parentfolder = null;
            try {
                parentfolder = filename.getParent();
                if (parentfolder.exists()) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ExcelWriter.Log.ParentFolderExist", (String[])new String[]{HopVfs.getFriendlyURI((FileObject)parentfolder)}));
                    }
                    break block13;
                }
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ExcelWriter.Log.ParentFolderNotExist", (String[])new String[]{HopVfs.getFriendlyURI((FileObject)parentfolder)}));
                }
                if (((ExcelWriterTransformMeta)this.meta).getFile().isCreateParentFolder()) {
                    parentfolder.createFolder();
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ExcelWriter.Log.ParentFolderCreated", (String[])new String[]{HopVfs.getFriendlyURI((FileObject)parentfolder)}));
                    }
                    break block13;
                }
                throw new HopException(BaseMessages.getString(PKG, (String)"ExcelWriter.Log.ParentFolderNotExistCreateIt", (String[])new String[]{HopVfs.getFriendlyURI((FileObject)parentfolder), HopVfs.getFriendlyURI((FileObject)filename)}));
            }
            finally {
                if (parentfolder != null) {
                    try {
                        parentfolder.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private void closeOutputFile(ExcelWriterWorkbookDefinition file) throws HopException {
        OutputStream out = null;
        try {
            out = new BufferedOutputStream(HopVfs.getOutputStream((FileObject)file.getFile(), (boolean)false));
            if (((ExcelWriterTransformMeta)this.meta).isFooterEnabled()) {
                this.writeHeader(file, file.getSheet(), file.getPosX(), file.getPosY());
            }
            if (((ExcelWriterTransformMeta)this.meta).getFile().isAutosizecolums()) {
                int i;
                if (file.getSheet() instanceof SXSSFSheet) {
                    ((SXSSFSheet)file.getSheet()).trackAllColumnsForAutoSizing();
                }
                if (((ExcelWriterTransformMeta)this.meta).getOutputFields() == null || ((ExcelWriterTransformMeta)this.meta).getOutputFields().isEmpty()) {
                    for (i = 0; i < ((ExcelWriterTransformData)this.data).inputRowMeta.size(); ++i) {
                        file.getSheet().autoSizeColumn(i + ((ExcelWriterTransformData)this.data).startingCol);
                    }
                } else {
                    for (i = 0; i < ((ExcelWriterTransformMeta)this.meta).getOutputFields().size(); ++i) {
                        file.getSheet().autoSizeColumn(i + ((ExcelWriterTransformData)this.data).startingCol);
                    }
                }
            }
            if (((ExcelWriterTransformMeta)this.meta).isForceFormulaRecalculation()) {
                this.recalculateAllWorkbookFormulas(((ExcelWriterTransformData)this.data).currentWorkbookDefinition);
            }
            file.getWorkbook().write(out);
            file.getWorkbook().close();
        }
        catch (IOException e) {
            throw new HopException((Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (Exception e) {
                    throw new HopException("Error closing excel file " + file.getFile(), (Throwable)e);
                }
            }
        }
    }

    void recalculateAllWorkbookFormulas(ExcelWriterWorkbookDefinition workbookDefinition) {
        if (workbookDefinition.getWorkbook() instanceof XSSFWorkbook) {
            FormulaEvaluator evaluator = workbookDefinition.getWorkbook().getCreationHelper().createFormulaEvaluator();
            for (int sheetNum = 0; sheetNum < workbookDefinition.getWorkbook().getNumberOfSheets(); ++sheetNum) {
                Sheet sheet = workbookDefinition.getWorkbook().getSheetAt(sheetNum);
                for (Row r : sheet) {
                    for (Cell c : r) {
                        if (c.getCellType() != CellType.FORMULA) continue;
                        evaluator.evaluateFormulaCell(c);
                    }
                }
            }
        } else if (workbookDefinition.getWorkbook() instanceof HSSFWorkbook) {
            for (int sheetNum = 0; sheetNum < workbookDefinition.getWorkbook().getNumberOfSheets(); ++sheetNum) {
                HSSFSheet sheet = ((HSSFWorkbook)workbookDefinition.getWorkbook()).getSheetAt(sheetNum);
                sheet.setForceFormulaRecalculation(true);
            }
        } else {
            String forceRecalc = this.getVariable(STREAMER_FORCE_RECALC_PROP_NAME, "N");
            if ("Y".equals(forceRecalc)) {
                workbookDefinition.getWorkbook().setForceFormulaRecalculation(true);
            }
        }
    }

    public void writeNextLine(ExcelWriterWorkbookDefinition workbookDefinition, Object[] r) throws HopException {
        try {
            this.openLine(workbookDefinition.getSheet(), workbookDefinition.getPosY());
            Row xlsRow = workbookDefinition.getSheet().getRow(workbookDefinition.getPosY());
            if (xlsRow == null) {
                xlsRow = workbookDefinition.getSheet().createRow(workbookDefinition.getPosY());
            }
            Object v = null;
            if (((ExcelWriterTransformMeta)this.meta).getOutputFields() == null || ((ExcelWriterTransformMeta)this.meta).getOutputFields().isEmpty()) {
                int nr = ((ExcelWriterTransformData)this.data).inputRowMeta.size();
                workbookDefinition.clearStyleCache(nr);
                ((ExcelWriterTransformData)this.data).linkfieldnrs = new int[nr];
                ((ExcelWriterTransformData)this.data).commentfieldnrs = new int[nr];
                int x = ((ExcelWriterTransformData)this.data).currentWorkbookDefinition.getPosX();
                for (int i = 0; i < nr; ++i) {
                    v = r[i];
                    this.writeField(workbookDefinition, v, ((ExcelWriterTransformData)this.data).inputRowMeta.getValueMeta(i), null, xlsRow, x++, r, i, false);
                }
                workbookDefinition.setPosX(((ExcelWriterTransformData)this.data).startingCol);
                workbookDefinition.incrementY();
            } else {
                int x = ((ExcelWriterTransformData)this.data).currentWorkbookDefinition.getPosX();
                for (int i = 0; i < ((ExcelWriterTransformMeta)this.meta).getOutputFields().size(); ++i) {
                    v = r[((ExcelWriterTransformData)this.data).fieldnrs[i]];
                    ExcelWriterOutputField field = ((ExcelWriterTransformMeta)this.meta).getOutputFields().get(i);
                    this.writeField(workbookDefinition, v, ((ExcelWriterTransformData)this.data).inputRowMeta.getValueMeta(((ExcelWriterTransformData)this.data).fieldnrs[i]), field, xlsRow, x++, r, i, false);
                }
                workbookDefinition.setPosX(((ExcelWriterTransformData)this.data).startingCol);
                workbookDefinition.incrementY();
            }
        }
        catch (Exception e) {
            this.logError("Error writing line :" + e.toString());
            throw new HopException((Throwable)e);
        }
    }

    private Comment createCellComment(ExcelWriterWorkbookDefinition workbookDefinition, String author, String comment) {
        if (workbookDefinition.getSheet() instanceof XSSFSheet) {
            CreationHelper factory = workbookDefinition.getWorkbook().getCreationHelper();
            Drawing drawing = workbookDefinition.getSheet().createDrawingPatriarch();
            ClientAnchor anchor = factory.createClientAnchor();
            Comment cmt = drawing.createCellComment(anchor);
            RichTextString str = factory.createRichTextString(comment);
            cmt.setString(str);
            cmt.setAuthor(author);
            return cmt;
        }
        return null;
    }

    private Cell getCellFromReference(ExcelWriterWorkbookDefinition workbookDefinition, String reference) {
        CellReference cellRef = new CellReference(reference);
        String sheetName = cellRef.getSheetName();
        Sheet sheet = workbookDefinition.getSheet();
        if (!Utils.isEmpty((CharSequence)sheetName)) {
            sheet = workbookDefinition.getWorkbook().getSheet(sheetName);
        }
        if (sheet == null) {
            return null;
        }
        Row xlsRow = sheet.getRow(cellRef.getRow());
        if (xlsRow == null) {
            return null;
        }
        return xlsRow.getCell((int)cellRef.getCol());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void writeField(ExcelWriterWorkbookDefinition workbookDefinition, Object v, IValueMeta vMeta, ExcelWriterOutputField excelField, Row xlsRow, int posX, Object[] row, int fieldNr, boolean isTitle) throws HopException {
        try {
            String comment;
            String link;
            boolean cellExisted = true;
            Cell cell = xlsRow.getCell(posX);
            if (cell == null) {
                cellExisted = false;
                cell = xlsRow.createCell(posX);
            }
            if (!cellExisted || !((ExcelWriterTransformMeta)this.meta).isLeaveExistingStylesUnchanged()) {
                if (!isTitle && workbookDefinition.getCachedStyle(fieldNr) != null) {
                    cell.setCellStyle(workbookDefinition.getCachedStyle(fieldNr));
                } else {
                    if (excelField != null) {
                        Cell styleCell;
                        String styleRef = null;
                        if (!isTitle && !Utils.isEmpty((CharSequence)excelField.getStyleCell())) {
                            styleRef = excelField.getStyleCell();
                        } else if (isTitle && !Utils.isEmpty((CharSequence)excelField.getTitleStyleCell())) {
                            styleRef = excelField.getTitleStyleCell();
                        }
                        if (styleRef != null && (styleCell = this.getCellFromReference(workbookDefinition, styleRef)) != null && cell != styleCell) {
                            cell.setCellStyle(styleCell.getCellStyle());
                        }
                    }
                    if (!(isTitle || excelField == null || Utils.isEmpty((CharSequence)excelField.getFormat()) || excelField.getFormat().startsWith("Image"))) {
                        this.setDataFormat(workbookDefinition, excelField.getFormat(), cell);
                    }
                    if (!isTitle) {
                        workbookDefinition.cacheStyle(fieldNr, cell.getCellStyle());
                    }
                }
            }
            if (!isTitle && excelField != null && ((ExcelWriterTransformData)this.data).linkfieldnrs[fieldNr] >= 0 && !Utils.isEmpty((CharSequence)(link = ((ExcelWriterTransformData)this.data).inputRowMeta.getValueMeta(((ExcelWriterTransformData)this.data).linkfieldnrs[fieldNr]).getString(row[((ExcelWriterTransformData)this.data).linkfieldnrs[fieldNr]])))) {
                CreationHelper ch = workbookDefinition.getWorkbook().getCreationHelper();
                Hyperlink hyperLink = null;
                if (link.startsWith("http:") || link.startsWith("https:") || link.startsWith("ftp:")) {
                    hyperLink = ch.createHyperlink(HyperlinkType.URL);
                    hyperLink.setLabel("URL Link");
                } else if (link.startsWith("mailto:")) {
                    hyperLink = ch.createHyperlink(HyperlinkType.EMAIL);
                    hyperLink.setLabel("Email Link");
                } else if (link.startsWith("'")) {
                    hyperLink = ch.createHyperlink(HyperlinkType.DOCUMENT);
                    hyperLink.setLabel("Link within this document");
                } else {
                    hyperLink = ch.createHyperlink(HyperlinkType.FILE);
                    hyperLink.setLabel("Link to a file");
                }
                hyperLink.setAddress(link);
                cell.setHyperlink(hyperLink);
                if (!cellExisted || !((ExcelWriterTransformMeta)this.meta).isLeaveExistingStylesUnchanged()) {
                    if (workbookDefinition.getCachedLinkStyle(fieldNr) != null) {
                        cell.setCellStyle(workbookDefinition.getCachedLinkStyle(fieldNr));
                    } else {
                        Font origFont = workbookDefinition.getWorkbook().getFontAt(cell.getCellStyle().getFontIndex());
                        Font hlinkFont = workbookDefinition.getWorkbook().createFont();
                        hlinkFont.setBold(origFont.getBold());
                        hlinkFont.setCharSet(origFont.getCharSet());
                        hlinkFont.setFontHeight(origFont.getFontHeight());
                        hlinkFont.setFontName(origFont.getFontName());
                        hlinkFont.setItalic(origFont.getItalic());
                        hlinkFont.setStrikeout(origFont.getStrikeout());
                        hlinkFont.setTypeOffset(origFont.getTypeOffset());
                        hlinkFont.setUnderline((byte)1);
                        hlinkFont.setColor(IndexedColors.BLUE.getIndex());
                        CellStyle style = cell.getCellStyle();
                        style.setFont(hlinkFont);
                        cell.setCellStyle(style);
                        workbookDefinition.cacheLinkStyle(fieldNr, cell.getCellStyle());
                    }
                }
            }
            if (!isTitle && excelField != null && ((ExcelWriterTransformData)this.data).commentfieldnrs[fieldNr] >= 0 && workbookDefinition.getWorkbook() instanceof XSSFWorkbook && !Utils.isEmpty((CharSequence)(comment = ((ExcelWriterTransformData)this.data).inputRowMeta.getValueMeta(((ExcelWriterTransformData)this.data).commentfieldnrs[fieldNr]).getString(row[((ExcelWriterTransformData)this.data).commentfieldnrs[fieldNr]])))) {
                String author = ((ExcelWriterTransformData)this.data).commentauthorfieldnrs[fieldNr] >= 0 ? ((ExcelWriterTransformData)this.data).inputRowMeta.getValueMeta(((ExcelWriterTransformData)this.data).commentauthorfieldnrs[fieldNr]).getString(row[((ExcelWriterTransformData)this.data).commentauthorfieldnrs[fieldNr]]) : "Apache Hop";
                cell.setCellComment(this.createCellComment(workbookDefinition, author, comment));
            }
            if (!isTitle && excelField != null && excelField.isFormula()) {
                cell.setCellFormula(vMeta.getString(v));
                return;
            } else {
                switch (vMeta.getType()) {
                    case 3: {
                        if (v == null || vMeta.getDate(v) == null) return;
                        cell.setCellValue(vMeta.getDate(v));
                        return;
                    }
                    case 4: {
                        if (v == null) return;
                        cell.setCellValue(vMeta.getBoolean(v).booleanValue());
                        return;
                    }
                    case 1: 
                    case 5: 
                    case 6: {
                        if (v == null) return;
                        cell.setCellValue(vMeta.getNumber(v).doubleValue());
                        return;
                    }
                    default: {
                        if (v == null) return;
                        cell.setCellValue(vMeta.getString(v));
                    }
                }
            }
            return;
        }
        catch (Exception e) {
            this.logError("Error writing field (" + workbookDefinition.getPosX() + "," + workbookDefinition.getPosY() + ") : " + e.toString());
            this.logError(Const.getStackTracker((Throwable)e));
            throw new HopException((Throwable)e);
        }
    }

    private void setDataFormat(ExcelWriterWorkbookDefinition workbookDefinition, String excelFieldFormat, Cell cell) {
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"ExcelWriterTransform.Log.SetDataFormat", (Object[])new Object[]{excelFieldFormat, CellReference.convertNumToColString((int)cell.getColumnIndex()), cell.getRowIndex()}));
        }
        DataFormat format = workbookDefinition.getWorkbook().createDataFormat();
        short formatIndex = format.getFormat(excelFieldFormat);
        CellStyle style = workbookDefinition.getWorkbook().createCellStyle();
        style.cloneStyleFrom(cell.getCellStyle());
        style.setDataFormat(formatIndex);
        cell.setCellStyle(style);
    }

    public String buildFilename(IRowMeta rowMeta, Object[] row) {
        return ((ExcelWriterTransformMeta)this.meta).buildFilename(rowMeta, row, (IVariables)this);
    }

    public String buildFilename(int splitNr) {
        return ((ExcelWriterTransformMeta)this.meta).buildFilename((IVariables)this, this.getCopy(), splitNr, ((ExcelWriterTransformData)this.data).isBeamContext(), this.log.getLogChannelId(), ((ExcelWriterTransformData)this.data).getBeamBundleNr());
    }

    public static void copyFile(FileObject in, FileObject out) throws HopException {
        try (BufferedInputStream fis = new BufferedInputStream(HopVfs.getInputStream((FileObject)in));
             BufferedOutputStream fos = new BufferedOutputStream(HopVfs.getOutputStream((FileObject)out, (boolean)false));){
            byte[] buf = new byte[0x100000];
            int i = 0;
            while ((i = fis.read(buf)) != -1) {
                fos.write(buf, 0, i);
            }
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void prepareNextOutputFile(Object[] row) throws HopException {
        try {
            Sheet sheet;
            InputStream inputStream;
            HSSFWorkbook wb;
            FileObject file;
            int numOfFields;
            if (((ExcelWriterTransformData)this.data).realSheetname != null && ((ExcelWriterTransformData)this.data).realSheetname.length() > 31) {
                throw new HopException(BaseMessages.getString(PKG, (String)"ExcelWriterTransform.Exception.MaxSheetName", (String[])new String[]{((ExcelWriterTransformData)this.data).realSheetname}));
            }
            if (((ExcelWriterTransformData)this.data).isBeamContext() && ((ExcelWriterTransformMeta)this.meta).getFile().isFileNameInField()) {
                throw new HopException(BaseMessages.getString(PKG, (String)"ExcelWriterTransform.Exception.FilenameFromFieldNotSupportedInBeam", (String[])new String[0]));
            }
            int n = numOfFields = ((ExcelWriterTransformMeta)this.meta).getOutputFields() != null && ((ExcelWriterTransformMeta)this.meta).getOutputFields().size() > 0 ? ((ExcelWriterTransformMeta)this.meta).getOutputFields().size() : 0;
            if (numOfFields == 0) {
                numOfFields = ((ExcelWriterTransformData)this.data).inputRowMeta != null ? ((ExcelWriterTransformData)this.data).inputRowMeta.size() : 0;
            }
            int splitNr = 0;
            if (!((ExcelWriterTransformMeta)this.meta).getFile().isFileNameInField()) {
                splitNr = this.getNextSplitNr(((ExcelWriterTransformMeta)this.meta).getFile().getFileName());
            }
            if (!(file = this.getFileLocation(row)).getParent().exists() && ((ExcelWriterTransformMeta)this.meta).getFile().isCreateParentFolder()) {
                this.logDebug("Create parent directory for " + file.getName().toString() + " because it does not exist.");
                this.createParentFolder(file);
            }
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"ExcelWriterTransform.Log.OpeningFile", (String[])new String[]{file.getName().toString()}));
            }
            if (file.exists() && ((ExcelWriterTransformData)this.data).createNewFile && !file.delete()) {
                if (this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"ExcelWriterTransform.Log.CouldNotDeleteStaleFile", (String[])new String[]{file.getName().toString()}));
                }
                this.setErrors(1L);
                throw new HopException("Could not delete stale file " + file.getName().toString());
            }
            if (((ExcelWriterTransformMeta)this.meta).isAddToResultFilenames()) {
                ResultFile resultFile = new ResultFile(0, file, this.getPipelineMeta().getName(), this.getTransformName());
                resultFile.setComment("This file was created with an Excel writer transform by Hop : The Hop Orchestration Platform");
                this.addResultFile(resultFile);
            }
            boolean appendingToSheet = true;
            if (!file.exists()) {
                block61: {
                    if (((ExcelWriterTransformMeta)this.meta).getTemplate().isTemplateEnabled()) {
                        String templateExt = HopVfs.getFileObject((String)((ExcelWriterTransformData)this.data).realTemplateFileName).getName().getExtension();
                        if (!((ExcelWriterTransformMeta)this.meta).getFile().getExtension().equalsIgnoreCase(templateExt)) {
                            throw new HopException("Template Format Mismatch: Template has extension: " + templateExt + ", but output file has extension: " + ((ExcelWriterTransformMeta)this.meta).getFile().getExtension() + ". Template and output file must share the same format!");
                        }
                        if (HopVfs.getFileObject((String)((ExcelWriterTransformData)this.data).realTemplateFileName).exists()) {
                            ExcelWriterTransform.copyFile(HopVfs.getFileObject((String)((ExcelWriterTransformData)this.data).realTemplateFileName), file);
                            break block61;
                        } else {
                            if (this.log.isBasic()) {
                                this.logBasic(BaseMessages.getString(PKG, (String)"ExcelWriterTransform.Log.TemplateMissing", (String[])new String[]{((ExcelWriterTransformData)this.data).realTemplateFileName}));
                            }
                            this.setErrors(1L);
                            throw new HopException("Template file missing: " + ((ExcelWriterTransformData)this.data).realTemplateFileName);
                        }
                    }
                    wb = ((ExcelWriterTransformMeta)this.meta).getFile().getExtension().equalsIgnoreCase("xlsx") ? new XSSFWorkbook() : new HSSFWorkbook();
                    try {
                        wb.createSheet(((ExcelWriterTransformData)this.data).realSheetname);
                        try (OutputStream out = HopVfs.getOutputStream((FileObject)file, (boolean)false);){
                            wb.write(out);
                        }
                    }
                    finally {
                        if (wb != null) {
                            wb.close();
                        }
                    }
                }
                appendingToSheet = false;
            }
            if (((ExcelWriterTransformMeta)this.meta).getFile().getExtension().equalsIgnoreCase("xlsx")) {
                inputStream = HopVfs.getInputStream((String)HopVfs.getFilename((FileObject)file));
                try {
                    XSSFWorkbook xssfWorkbook = new XSSFWorkbook(inputStream);
                    if (((ExcelWriterTransformMeta)this.meta).getFile().isStreamingData() && !((ExcelWriterTransformMeta)this.meta).getTemplate().isTemplateEnabled()) {
                        wb = new SXSSFWorkbook(xssfWorkbook, 100);
                    }
                    wb = xssfWorkbook;
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            } else {
                inputStream = HopVfs.getInputStream((FileObject)file);
                try {
                    wb = new HSSFWorkbook(inputStream);
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            int existingActiveSheetIndex = wb.getActiveSheetIndex();
            int replacingSheetAt = -1;
            if (wb.getSheet(((ExcelWriterTransformData)this.data).realSheetname) != null && ((ExcelWriterTransformData)this.data).createNewSheet) {
                replacingSheetAt = wb.getSheetIndex(wb.getSheet(((ExcelWriterTransformData)this.data).realSheetname));
                wb.removeSheetAt(replacingSheetAt);
            }
            if (wb.getSheet(((ExcelWriterTransformData)this.data).realSheetname) == null) {
                if (((ExcelWriterTransformMeta)this.meta).getTemplate().isTemplateSheetEnabled()) {
                    Sheet ts = wb.getSheet(((ExcelWriterTransformData)this.data).realTemplateSheetName);
                    if (ts == null) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"ExcelWriterTransform.Exception.TemplateNotFound", (String[])new String[]{((ExcelWriterTransformData)this.data).realTemplateSheetName}));
                    }
                    sheet = wb.cloneSheet(wb.getSheetIndex(ts));
                    wb.setSheetName(wb.getSheetIndex(sheet), ((ExcelWriterTransformData)this.data).realSheetname);
                    wb.setSheetHidden(wb.getSheetIndex(sheet), false);
                    if (((ExcelWriterTransformMeta)this.meta).getTemplate().isTemplateSheetHidden()) {
                        wb.setSheetHidden(wb.getSheetIndex(ts), true);
                    }
                } else {
                    sheet = wb.createSheet(((ExcelWriterTransformData)this.data).realSheetname);
                }
                if (replacingSheetAt > -1) {
                    wb.setSheetOrder(sheet.getSheetName(), replacingSheetAt);
                }
                wb.setActiveSheet(existingActiveSheetIndex);
                wb.setSelectedTab(existingActiveSheetIndex);
                appendingToSheet = false;
            } else {
                sheet = wb.getSheet(((ExcelWriterTransformData)this.data).realSheetname);
            }
            if (((ExcelWriterTransformMeta)this.meta).isMakeSheetActive()) {
                int sheetIndex = wb.getSheetIndex(sheet);
                wb.setActiveSheet(sheetIndex);
                wb.setSelectedTab(sheetIndex);
            }
            if (((ExcelWriterTransformMeta)this.meta).getFile().isProtectsheet()) {
                this.protectSheet(sheet, ((ExcelWriterTransformData)this.data).realPassword);
            }
            if (!Utils.isEmpty((CharSequence)((ExcelWriterTransformData)this.data).realStartingCell)) {
                CellReference cellRef = new CellReference(((ExcelWriterTransformData)this.data).realStartingCell);
                ((ExcelWriterTransformData)this.data).startingRow = cellRef.getRow();
                ((ExcelWriterTransformData)this.data).startingCol = cellRef.getCol();
            } else {
                ((ExcelWriterTransformData)this.data).startingRow = 0;
                ((ExcelWriterTransformData)this.data).startingCol = 0;
            }
            int posX = ((ExcelWriterTransformData)this.data).startingCol;
            int posY = ((ExcelWriterTransformData)this.data).startingRow;
            if (!((ExcelWriterTransformData)this.data).createNewSheet && ((ExcelWriterTransformMeta)this.meta).isAppendLines() && appendingToSheet) {
                posY = sheet.getPhysicalNumberOfRows() > 0 ? sheet.getLastRowNum() + 1 : 0;
            }
            if (!((ExcelWriterTransformData)this.data).createNewSheet && ((ExcelWriterTransformMeta)this.meta).getAppendOffset() != 0 && appendingToSheet) {
                posY += ((ExcelWriterTransformMeta)this.meta).getAppendOffset();
            }
            if (!((ExcelWriterTransformData)this.data).createNewSheet && ((ExcelWriterTransformMeta)this.meta).getAppendEmpty() > 0 && appendingToSheet) {
                for (int i = 0; i < ((ExcelWriterTransformMeta)this.meta).getAppendEmpty(); ++i) {
                    sheet = this.openLine(sheet, posY);
                    if (((ExcelWriterTransformData)this.data).shiftExistingCells && !((ExcelWriterTransformMeta)this.meta).isAppendLines()) continue;
                    ++posY;
                }
            }
            String baseFileName = !((ExcelWriterTransformMeta)this.meta).getFile().isFileNameInField() ? ((ExcelWriterTransformMeta)this.meta).getFile().getFileName() : file.getName().toString();
            ExcelWriterWorkbookDefinition workbookDefinition = new ExcelWriterWorkbookDefinition(baseFileName, file, (Workbook)wb, sheet, posX, Math.max(posY, sheet.getLastRowNum()));
            workbookDefinition.setSplitNr(splitNr);
            ((ExcelWriterTransformData)this.data).usedFiles.add(workbookDefinition);
            ((ExcelWriterTransformData)this.data).currentWorkbookDefinition = workbookDefinition;
            ((ExcelWriterTransformData)this.data).currentWorkbookDefinition.clearStyleCache(numOfFields);
            if (((ExcelWriterTransformMeta)this.meta).isHeaderEnabled() && (((ExcelWriterTransformData)this.data).createNewSheet || !((ExcelWriterTransformMeta)this.meta).isAppendOmitHeader() || !appendingToSheet)) {
                ((ExcelWriterTransformData)this.data).currentWorkbookDefinition.setSheet(this.writeHeader(workbookDefinition, sheet, posX, posY));
            }
            if (!this.log.isDebug()) return;
            this.logDebug(BaseMessages.getString(PKG, (String)"ExcelWriterTransform.Log.FileOpened", (String[])new String[]{file.getName().toString()}));
            return;
        }
        catch (Exception e) {
            this.logError("Error opening new file", e);
            this.setErrors(1L);
            throw new HopException("Error opening new file", (Throwable)e);
        }
    }

    private Sheet openLine(Sheet sheet, int posY) {
        if (((ExcelWriterTransformData)this.data).shiftExistingCells) {
            sheet.shiftRows(posY, Math.max(posY, sheet.getLastRowNum()), 1);
        }
        return sheet;
    }

    private Sheet writeHeader(ExcelWriterWorkbookDefinition workbookDefinition, Sheet sheet, int posX, int posY) throws HopException {
        try {
            sheet = this.openLine(sheet, posY);
            Row xlsRow = sheet.getRow(posY);
            if (xlsRow == null) {
                xlsRow = sheet.createRow(posY);
            }
            if (((ExcelWriterTransformMeta)this.meta).getOutputFields() != null && !((ExcelWriterTransformMeta)this.meta).getOutputFields().isEmpty()) {
                for (int i = 0; i < ((ExcelWriterTransformMeta)this.meta).getOutputFields().size(); ++i) {
                    ExcelWriterOutputField field = ((ExcelWriterTransformMeta)this.meta).getOutputFields().get(i);
                    String fieldName = !Utils.isEmpty((CharSequence)field.getTitle()) ? field.getTitle() : field.getName();
                    ValueMetaString vMeta = new ValueMetaString(fieldName);
                    this.writeField(workbookDefinition, fieldName, (IValueMeta)vMeta, field, xlsRow, posX++, null, -1, true);
                }
            } else if (((ExcelWriterTransformData)this.data).inputRowMeta != null) {
                for (int i = 0; i < ((ExcelWriterTransformData)this.data).inputRowMeta.size(); ++i) {
                    String fieldName = ((ExcelWriterTransformData)this.data).inputRowMeta.getFieldNames()[i];
                    ValueMetaString vMeta = new ValueMetaString(fieldName);
                    this.writeField(workbookDefinition, fieldName, (IValueMeta)vMeta, null, xlsRow, posX++, null, -1, true);
                }
            }
            workbookDefinition.setPosY(posY + 1);
            this.incrementLinesOutput();
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
        return sheet;
    }

    public boolean init() {
        if (super.init()) {
            ((ExcelWriterTransformData)this.data).realSheetname = this.resolve(((ExcelWriterTransformMeta)this.meta).getFile().getSheetname());
            ((ExcelWriterTransformData)this.data).realTemplateSheetName = this.resolve(((ExcelWriterTransformMeta)this.meta).getTemplate().getTemplateSheetName());
            ((ExcelWriterTransformData)this.data).realTemplateFileName = this.resolve(((ExcelWriterTransformMeta)this.meta).getTemplate().getTemplateFileName());
            ((ExcelWriterTransformData)this.data).realStartingCell = this.resolve(((ExcelWriterTransformMeta)this.meta).getStartingCell());
            ((ExcelWriterTransformData)this.data).realPassword = Utils.resolvePassword((IVariables)this.variables, (String)((ExcelWriterTransformMeta)this.meta).getFile().getPassword());
            ((ExcelWriterTransformData)this.data).realProtectedBy = this.resolve(((ExcelWriterTransformMeta)this.meta).getFile().getProtectedBy());
            ((ExcelWriterTransformData)this.data).shiftExistingCells = "push".equals(((ExcelWriterTransformMeta)this.meta).getRowWritingMethod());
            ((ExcelWriterTransformData)this.data).createNewSheet = "new".equals(((ExcelWriterTransformMeta)this.meta).getFile().getIfSheetExists());
            ((ExcelWriterTransformData)this.data).createNewFile = "new".equals(((ExcelWriterTransformMeta)this.meta).getFile().getIfFileExists());
            return true;
        }
        return false;
    }

    public void startBundle() throws HopException {
        if (!this.first) {
            this.prepareNextOutputFile(null);
        }
    }

    public void finishBundle() throws HopException {
        this.closeFiles();
    }

    public void batchComplete() throws HopException {
        if (!((ExcelWriterTransformData)this.data).isBeamContext()) {
            this.closeFiles();
        }
    }

    protected void protectSheet(Sheet sheet, String password) {
        if (sheet instanceof HSSFSheet) {
            sheet.protectSheet(password);
        }
    }

    private FileObject getFileLocation(Object[] row) throws HopFileException {
        String buildFilename = !((ExcelWriterTransformMeta)this.meta).getFile().isFileNameInField() ? this.buildFilename(this.getNextSplitNr(((ExcelWriterTransformMeta)this.meta).getFile().getFileName())) : this.buildFilename(((ExcelWriterTransformData)this.data).inputRowMeta, row);
        return HopVfs.getFileObject((String)buildFilename);
    }

    private int getNextSplitNr(String fileName) {
        int splitNr = 0;
        boolean fileFound = false;
        for (ExcelWriterWorkbookDefinition workbookDefinition : ((ExcelWriterTransformData)this.data).usedFiles) {
            if (!workbookDefinition.getFileName().equals(fileName)) continue;
            fileFound = true;
            if (workbookDefinition.getSplitNr() <= splitNr) continue;
            splitNr = workbookDefinition.getSplitNr();
        }
        if (fileFound) {
            ++splitNr;
        }
        return splitNr;
    }
}

