/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.types;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public final class EncodedValueSerializer
extends TypeSerializerSingleton<byte[]> {
    private static final long serialVersionUID = 1L;
    private static final byte[] EMPTY = new byte[0];

    public boolean isImmutableType() {
        return true;
    }

    public byte[] createInstance() {
        return EMPTY;
    }

    public byte[] copy(byte[] from) {
        return from;
    }

    public byte[] copy(byte[] from, byte[] reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(byte[] record, DataOutputView target) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException("The record must not be null.");
        }
        int len = record.length;
        target.writeInt(len);
        target.write(record);
    }

    public byte[] deserialize(DataInputView source) throws IOException {
        int len = source.readInt();
        byte[] result = new byte[len];
        source.readFully(result);
        return result;
    }

    public byte[] deserialize(byte[] reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int len = source.readInt();
        target.writeInt(len);
        target.write(source, len);
    }

    public TypeSerializerSnapshot<byte[]> snapshotConfiguration() {
        return new TypeSerializerSnapshot<byte[]>(){

            public int getCurrentVersion() {
                return 1;
            }

            public void writeSnapshot(DataOutputView out) throws IOException {
            }

            public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            }

            public TypeSerializer<byte[]> restoreSerializer() {
                return new EncodedValueSerializer();
            }

            public TypeSerializerSchemaCompatibility<byte[]> resolveSchemaCompatibility(TypeSerializer<byte[]> newSerializer) {
                return newSerializer instanceof EncodedValueSerializer ? TypeSerializerSchemaCompatibility.compatibleAsIs() : TypeSerializerSchemaCompatibility.compatibleAfterMigration();
            }
        };
    }
}

