/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.ssl;

import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.api.core.ssl.SslEngineFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

public class ProgrammaticSslEngineFactory
implements SslEngineFactory {
    protected final SSLContext sslContext;
    protected final String[] cipherSuites;
    protected final boolean requireHostnameValidation;

    public ProgrammaticSslEngineFactory(@NonNull SSLContext sslContext) {
        this(sslContext, null);
    }

    public ProgrammaticSslEngineFactory(@NonNull SSLContext sslContext, @Nullable String[] cipherSuites) {
        this(sslContext, cipherSuites, false);
    }

    public ProgrammaticSslEngineFactory(@NonNull SSLContext sslContext, @Nullable String[] cipherSuites, boolean requireHostnameValidation) {
        this.sslContext = sslContext;
        this.cipherSuites = cipherSuites;
        this.requireHostnameValidation = requireHostnameValidation;
    }

    @Override
    @NonNull
    public SSLEngine newSslEngine(@NonNull EndPoint remoteEndpoint) {
        SSLEngine engine;
        SocketAddress remoteAddress = remoteEndpoint.resolve();
        if (remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress socketAddress = (InetSocketAddress)remoteAddress;
            engine = this.sslContext.createSSLEngine(socketAddress.getHostName(), socketAddress.getPort());
        } else {
            engine = this.sslContext.createSSLEngine();
        }
        engine.setUseClientMode(true);
        if (this.cipherSuites != null) {
            engine.setEnabledCipherSuites(this.cipherSuites);
        }
        if (this.requireHostnameValidation) {
            SSLParameters parameters = engine.getSSLParameters();
            parameters.setEndpointIdentificationAlgorithm("HTTPS");
            engine.setSSLParameters(parameters);
        }
        return engine;
    }

    @Override
    public void close() {
    }
}

