/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transform;

import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.changed.ChangedFlag;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.w3c.dom.Node;

public class TransformErrorMeta
extends ChangedFlag
implements Cloneable {
    public static final String XML_ERROR_TAG = "error";
    public static final String XML_SOURCE_TRANSFORM_TAG = "source_transform";
    public static final String XML_TARGET_TRANSFORM_TAG = "target_transform";
    private TransformMeta sourceTransform;
    private TransformMeta targetTransform;
    private boolean enabled;
    private String nrErrorsValuename;
    private String errorDescriptionsValuename;
    private String errorFieldsValuename;
    private String errorCodesValuename;
    private String maxErrors = "";
    private String maxPercentErrors = "";
    private String minPercentRows = "";

    public TransformErrorMeta(TransformMeta sourceTransform) {
        this.sourceTransform = sourceTransform;
        this.enabled = false;
    }

    public TransformErrorMeta(TransformMeta sourceTransform, TransformMeta targetTransform) {
        this.sourceTransform = sourceTransform;
        this.targetTransform = targetTransform;
        this.enabled = false;
    }

    public TransformErrorMeta(TransformMeta sourceTransform, TransformMeta targetTransform, String nrErrorsValuename, String errorDescriptionsValuename, String errorFieldsValuename, String errorCodesValuename) {
        this.sourceTransform = sourceTransform;
        this.targetTransform = targetTransform;
        this.enabled = false;
        this.nrErrorsValuename = nrErrorsValuename;
        this.errorDescriptionsValuename = errorDescriptionsValuename;
        this.errorFieldsValuename = errorFieldsValuename;
        this.errorCodesValuename = errorCodesValuename;
    }

    public TransformErrorMeta clone() {
        try {
            return (TransformErrorMeta)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String getXml() {
        StringBuilder xml = new StringBuilder(300);
        xml.append("      ").append(XmlHandler.openTag((String)XML_ERROR_TAG)).append(Const.CR);
        xml.append("        ").append(XmlHandler.addTagValue((String)XML_SOURCE_TRANSFORM_TAG, (String)(this.sourceTransform != null ? this.sourceTransform.getName() : "")));
        xml.append("        ").append(XmlHandler.addTagValue((String)XML_TARGET_TRANSFORM_TAG, (String)(this.targetTransform != null ? this.targetTransform.getName() : "")));
        xml.append("        ").append(XmlHandler.addTagValue((String)"is_enabled", (boolean)this.enabled));
        xml.append("        ").append(XmlHandler.addTagValue((String)"nr_valuename", (String)this.nrErrorsValuename));
        xml.append("        ").append(XmlHandler.addTagValue((String)"descriptions_valuename", (String)this.errorDescriptionsValuename));
        xml.append("        ").append(XmlHandler.addTagValue((String)"fields_valuename", (String)this.errorFieldsValuename));
        xml.append("        ").append(XmlHandler.addTagValue((String)"codes_valuename", (String)this.errorCodesValuename));
        xml.append("        ").append(XmlHandler.addTagValue((String)"max_errors", (String)this.maxErrors));
        xml.append("        ").append(XmlHandler.addTagValue((String)"max_pct_errors", (String)this.maxPercentErrors));
        xml.append("        ").append(XmlHandler.addTagValue((String)"min_pct_rows", (String)this.minPercentRows));
        xml.append("      ").append(XmlHandler.closeTag((String)XML_ERROR_TAG)).append(Const.CR);
        return xml.toString();
    }

    public TransformErrorMeta(Node node, List<TransformMeta> transforms) {
        this.sourceTransform = TransformMeta.findTransform(transforms, XmlHandler.getTagValue((Node)node, (String)XML_SOURCE_TRANSFORM_TAG));
        this.targetTransform = TransformMeta.findTransform(transforms, XmlHandler.getTagValue((Node)node, (String)XML_TARGET_TRANSFORM_TAG));
        this.enabled = "Y".equals(XmlHandler.getTagValue((Node)node, (String)"is_enabled"));
        this.nrErrorsValuename = XmlHandler.getTagValue((Node)node, (String)"nr_valuename");
        this.errorDescriptionsValuename = XmlHandler.getTagValue((Node)node, (String)"descriptions_valuename");
        this.errorFieldsValuename = XmlHandler.getTagValue((Node)node, (String)"fields_valuename");
        this.errorCodesValuename = XmlHandler.getTagValue((Node)node, (String)"codes_valuename");
        this.maxErrors = XmlHandler.getTagValue((Node)node, (String)"max_errors");
        this.maxPercentErrors = XmlHandler.getTagValue((Node)node, (String)"max_pct_errors");
        this.minPercentRows = XmlHandler.getTagValue((Node)node, (String)"min_pct_rows");
    }

    public String getErrorCodesValuename() {
        return this.errorCodesValuename;
    }

    public void setErrorCodesValuename(String errorCodesValuename) {
        this.errorCodesValuename = errorCodesValuename;
    }

    public String getErrorDescriptionsValuename() {
        return this.errorDescriptionsValuename;
    }

    public void setErrorDescriptionsValuename(String errorDescriptionsValuename) {
        this.errorDescriptionsValuename = errorDescriptionsValuename;
    }

    public String getErrorFieldsValuename() {
        return this.errorFieldsValuename;
    }

    public void setErrorFieldsValuename(String errorFieldsValuename) {
        this.errorFieldsValuename = errorFieldsValuename;
    }

    public String getNrErrorsValuename() {
        return this.nrErrorsValuename;
    }

    public void setNrErrorsValuename(String nrErrorsValuename) {
        this.nrErrorsValuename = nrErrorsValuename;
    }

    public TransformMeta getTargetTransform() {
        return this.targetTransform;
    }

    public void setTargetTransform(TransformMeta targetTransform) {
        this.targetTransform = targetTransform;
    }

    public TransformMeta getSourceTransform() {
        return this.sourceTransform;
    }

    public void setSourceTransform(TransformMeta sourceTransform) {
        this.sourceTransform = sourceTransform;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public IRowMeta getErrorRowMeta(IVariables variables) {
        String errCodes;
        String errFields;
        String errDesc;
        RowMeta row = new RowMeta();
        String nrErr = variables.resolve(this.getNrErrorsValuename());
        if (!Utils.isEmpty((CharSequence)nrErr)) {
            ValueMetaInteger v = new ValueMetaInteger(nrErr);
            v.setLength(3);
            row.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)(errDesc = variables.resolve(this.getErrorDescriptionsValuename())))) {
            ValueMetaString v = new ValueMetaString(errDesc);
            row.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)(errFields = variables.resolve(this.getErrorFieldsValuename())))) {
            ValueMetaString v = new ValueMetaString(errFields);
            row.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)(errCodes = variables.resolve(this.getErrorCodesValuename())))) {
            ValueMetaString v = new ValueMetaString(errCodes);
            row.addValueMeta((IValueMeta)v);
        }
        return row;
    }

    public void addErrorRowData(IVariables variables, Object[] row, int startIndex, long nrErrors, String errorDescriptions, String fieldNames, String errorCodes) {
        String errCodes;
        String errFields;
        String errDesc;
        int index = startIndex;
        String nrErr = variables.resolve(this.getNrErrorsValuename());
        if (!Utils.isEmpty((CharSequence)nrErr)) {
            row[index] = nrErrors;
            ++index;
        }
        if (!Utils.isEmpty((CharSequence)(errDesc = variables.resolve(this.getErrorDescriptionsValuename())))) {
            row[index] = errorDescriptions;
            ++index;
        }
        if (!Utils.isEmpty((CharSequence)(errFields = variables.resolve(this.getErrorFieldsValuename())))) {
            row[index] = fieldNames;
            ++index;
        }
        if (!Utils.isEmpty((CharSequence)(errCodes = variables.resolve(this.getErrorCodesValuename())))) {
            row[index] = errorCodes;
        }
    }

    public String getMaxErrors() {
        return this.maxErrors;
    }

    public void setMaxErrors(String maxErrors) {
        this.maxErrors = maxErrors;
    }

    public String getMaxPercentErrors() {
        return this.maxPercentErrors;
    }

    public void setMaxPercentErrors(String maxPercentErrors) {
        this.maxPercentErrors = maxPercentErrors;
    }

    public String getMinPercentRows() {
        return this.minPercentRows;
    }

    public void setMinPercentRows(String minRowsForPercent) {
        this.minPercentRows = minRowsForPercent;
    }
}

