/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.userdefinedjavaclass;

import java.io.Serializable;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.sql.Timestamp;
import java.util.Date;
import java.util.regex.Pattern;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaInternetAddress;
import org.apache.hop.core.row.value.ValueMetaTimestamp;
import org.apache.hop.i18n.BaseMessages;

public class FieldHelper {
    private static final Class<?> PKG = FieldHelper.class;
    private int index = -1;
    private IValueMeta meta;
    private static final Pattern validJavaIdentifier = Pattern.compile("^[\\w&&\\D]\\w*");

    public FieldHelper(IRowMeta rowMeta, String fieldName) {
        this.meta = rowMeta.searchValueMeta(fieldName);
        this.index = rowMeta.indexOfValue(fieldName);
        if (this.index == -1) {
            throw new IllegalArgumentException(String.format("FieldHelper could not be initialized. The field named '%s' not found in RowMeta: %s", fieldName, rowMeta.toStringMeta()));
        }
    }

    public Object getObject(Object[] dataRow) {
        return dataRow[this.index];
    }

    public BigDecimal getBigDecimal(Object[] dataRow) throws HopValueException {
        return this.meta.getBigNumber(dataRow[this.index]);
    }

    public byte[] getBinary(Object[] dataRow) throws HopValueException {
        return this.meta.getBinary(dataRow[this.index]);
    }

    public Boolean getBoolean(Object[] dataRow) throws HopValueException {
        return this.meta.getBoolean(dataRow[this.index]);
    }

    public Date getDate(Object[] dataRow) throws HopValueException {
        return this.meta.getDate(dataRow[this.index]);
    }

    public Long getLong(Object[] dataRow) throws HopValueException {
        return this.meta.getInteger(dataRow[this.index]);
    }

    public Double getDouble(Object[] dataRow) throws HopValueException {
        return this.meta.getNumber(dataRow[this.index]);
    }

    public Timestamp getTimestamp(Object[] dataRow) throws HopValueException {
        return ((ValueMetaTimestamp)this.meta).getTimestamp(dataRow[this.index]);
    }

    public InetAddress getInetAddress(Object[] dataRow) throws HopValueException {
        return ((ValueMetaInternetAddress)this.meta).getInternetAddress(dataRow[this.index]);
    }

    public Serializable getSerializable(Object[] dataRow) throws HopValueException {
        return (Serializable)dataRow[this.index];
    }

    public String getString(Object[] dataRow) throws HopValueException {
        return this.meta.getString(dataRow[this.index]);
    }

    public IValueMeta getValueMeta() {
        return this.meta;
    }

    public int indexOfValue() {
        return this.index;
    }

    public void setValue(Object[] dataRow, Object value) {
        dataRow[this.index] = value;
    }

    public void setValue(Object[] dataRow, byte[] value) {
        dataRow[this.index] = value;
    }

    public static String getAccessor(boolean isIn, String fieldName) {
        StringBuilder sb = new StringBuilder("get(Fields.");
        sb.append(isIn ? "In" : "Out");
        sb.append(String.format(", \"%s\")", fieldName.replace("\\", "\\\\").replace("\"", "\\\"")));
        return sb.toString();
    }

    public static String getGetSignature(String accessor, IValueMeta v) {
        StringBuilder sb = new StringBuilder();
        switch (v.getType()) {
            case 6: {
                sb.append("BigDecimal ");
                break;
            }
            case 8: {
                sb.append("byte[] ");
                break;
            }
            case 4: {
                sb.append("Boolean ");
                break;
            }
            case 3: {
                sb.append("Date ");
                break;
            }
            case 5: {
                sb.append("Long ");
                break;
            }
            case 1: {
                sb.append("Double ");
                break;
            }
            case 2: {
                sb.append("String ");
                break;
            }
            case 10: {
                sb.append("InetAddress ");
                break;
            }
            case 9: {
                sb.append("Timestamp ");
                break;
            }
            default: {
                sb.append("Object ");
            }
        }
        if (validJavaIdentifier.matcher(v.getName()).matches()) {
            sb.append(v.getName());
        } else {
            sb.append("value");
        }
        String name = FieldHelper.getNativeDataTypeSimpleName(v);
        sb.append(" = ").append(accessor).append(".get").append("-".equals(name) ? "Object" : name).append("(r);");
        return sb.toString();
    }

    public static String getNativeDataTypeSimpleName(IValueMeta v) {
        try {
            return v.getType() != 8 ? v.getNativeDataTypeClass().getSimpleName() : "Binary";
        }
        catch (HopValueException e) {
            LogChannel log = new LogChannel((Object)v);
            log.logDebug(BaseMessages.getString(PKG, (String)"FieldHelper.Log.UnknownNativeDataTypeSimpleName", (String[])new String[0]));
            return "Object";
        }
    }
}

