/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.List;
import org.apache.beam.sdk.io.kafka.AutoValue_KafkaSourceDescriptor;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.annotations.SchemaCreate;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldName;
import org.apache.beam.sdk.schemas.annotations.SchemaIgnore;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.kafka.common.TopicPartition;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Deterministic;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Instant;

@DefaultSchema(value=AutoValueSchema.class)
@AutoValue
public abstract class KafkaSourceDescriptor
implements Serializable {
    private @Nullable TopicPartition topicPartition = null;

    @SchemaFieldName(value="topic")
    @Pure
    abstract String getTopic();

    @SchemaFieldName(value="partition")
    @Pure
    abstract Integer getPartition();

    @SchemaFieldName(value="start_read_offset")
    @Pure
    abstract @Nullable Long getStartReadOffset();

    @SchemaFieldName(value="start_read_time")
    @Pure
    abstract @Nullable Instant getStartReadTime();

    @SchemaFieldName(value="stop_read_offset")
    @Pure
    abstract @Nullable Long getStopReadOffset();

    @SchemaFieldName(value="stop_read_time")
    @Pure
    abstract @Nullable Instant getStopReadTime();

    @SchemaFieldName(value="bootstrap_servers")
    @Pure
    abstract @Nullable List<String> getBootStrapServers();

    @SchemaIgnore
    @Deterministic
    public TopicPartition getTopicPartition() {
        if (this.topicPartition == null) {
            this.topicPartition = new TopicPartition(this.getTopic(), this.getPartition().intValue());
        }
        return this.topicPartition;
    }

    public static KafkaSourceDescriptor of(TopicPartition topicPartition, @Nullable Long startReadOffset, @Nullable Instant startReadTime, @Nullable Long stopReadOffset, @Nullable Instant stopReadTime, @Nullable List<String> bootstrapServers) {
        KafkaSourceDescriptor.checkArguments(startReadOffset, startReadTime, stopReadOffset, stopReadTime);
        return new AutoValue_KafkaSourceDescriptor(topicPartition.topic(), topicPartition.partition(), startReadOffset, startReadTime, stopReadOffset, stopReadTime, bootstrapServers);
    }

    private static void checkArguments(@Nullable Long startReadOffset, @Nullable Instant startReadTime, @Nullable Long stopReadOffset, @Nullable Instant stopReadTime) {
        Preconditions.checkArgument((startReadOffset == null || startReadTime == null ? 1 : 0) != 0, (Object)"startReadOffset and startReadTime are optional but mutually exclusive. Please set only one of them.");
        Preconditions.checkArgument((stopReadOffset == null || stopReadTime == null ? 1 : 0) != 0, (Object)"stopReadOffset and stopReadTime are optional but mutually exclusive. Please set only one of them.");
    }

    @SchemaCreate
    static KafkaSourceDescriptor create(String topic, Integer partition, Long start_read_offset, Instant start_read_time, Long stop_read_offset, Instant stop_read_time, List<String> bootstrap_servers) {
        KafkaSourceDescriptor.checkArguments(start_read_offset, start_read_time, stop_read_offset, stop_read_time);
        return new AutoValue_KafkaSourceDescriptor(topic, partition, start_read_offset, start_read_time, stop_read_offset, stop_read_time, bootstrap_servers);
    }
}

