/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.columnsexist;

import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.w3c.dom.Node;

@Action(id="COLUMNS_EXIST", name="i18n::ActionColumnsExist.Name", description="i18n::ActionColumnsExist.Description", image="ColumnsExist.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Conditions", keywords={"i18n::ActionColumnsExist.keyword"}, documentationUrl="/workflow/actions/columnsexist.html")
public class ActionColumnsExist
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionColumnsExist.class;
    private String schemaname = null;
    private String tableName = null;
    private DatabaseMeta connection = null;
    private String[] arguments;

    public ActionColumnsExist(String n) {
        super(n, "");
    }

    public ActionColumnsExist() {
        this("");
    }

    public void allocate(int nrFields) {
        this.arguments = new String[nrFields];
    }

    public Object clone() {
        ActionColumnsExist je = (ActionColumnsExist)super.clone();
        if (this.arguments != null) {
            int nrFields = this.arguments.length;
            je.allocate(nrFields);
            System.arraycopy(this.arguments, 0, je.arguments, 0, nrFields);
        }
        return je;
    }

    public String getXml() {
        StringBuilder xml = new StringBuilder(200);
        xml.append(super.getXml());
        xml.append("      ").append(XmlHandler.addTagValue((String)"tablename", (String)this.tableName));
        xml.append("      ").append(XmlHandler.addTagValue((String)"schemaname", (String)this.schemaname));
        xml.append("      ").append(XmlHandler.addTagValue((String)"connection", this.connection == null ? null : this.connection.getName()));
        xml.append("      <fields>").append(Const.CR);
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                xml.append("        <field>").append(Const.CR);
                xml.append("          ").append(XmlHandler.addTagValue((String)"name", (String)this.arguments[i]));
                xml.append("        </field>").append(Const.CR);
            }
        }
        xml.append("      </fields>").append(Const.CR);
        return xml.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.tableName = XmlHandler.getTagValue((Node)entrynode, (String)"tablename");
            this.schemaname = XmlHandler.getTagValue((Node)entrynode, (String)"schemaname");
            String dbname = XmlHandler.getTagValue((Node)entrynode, (String)"connection");
            this.connection = DatabaseMeta.loadDatabase((IHopMetadataProvider)metadataProvider, (String)dbname);
            Node fields = XmlHandler.getSubNode((Node)entrynode, (String)"fields");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.arguments[i] = XmlHandler.getTagValue((Node)fnode, (String)"name");
            }
        }
        catch (HopException e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"ActionColumnsExist.Meta.UnableLoadXml", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setTablename(String tableName) {
        this.tableName = tableName;
    }

    public String getTablename() {
        return this.tableName;
    }

    public void setSchemaname(String schemaname) {
        this.schemaname = schemaname;
    }

    public String getSchemaname() {
        return this.schemaname;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public void setArguments(String[] arguments) {
        this.arguments = arguments;
    }

    public void setDatabase(DatabaseMeta database) {
        this.connection = database;
    }

    public DatabaseMeta getDatabase() {
        return this.connection;
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(false);
        result.setNrErrors(1L);
        int nrexistcolums = 0;
        int nrnotexistcolums = 0;
        if (Utils.isEmpty((CharSequence)this.tableName)) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionColumnsExist.Error.TablenameEmpty", (String[])new String[0]));
            return result;
        }
        if (this.arguments == null) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionColumnsExist.Error.ColumnameEmpty", (String[])new String[0]));
            return result;
        }
        if (this.connection != null) {
            Database db = this.getNewDatabaseFromMeta();
            try {
                String realSchemaname = this.resolve(this.schemaname);
                String realTablename = this.resolve(this.tableName);
                db.connect();
                if (db.checkTableExists(realSchemaname, realTablename)) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionColumnsExist.Log.TableExists", (String[])new String[]{realTablename}));
                    }
                    for (int i = 0; i < this.arguments.length && !this.parentWorkflow.isStopped(); ++i) {
                        String realColumnname = this.resolve(this.arguments[i]);
                        if (db.checkColumnExists(realSchemaname, realTablename, realColumnname)) {
                            if (this.isDetailed()) {
                                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionColumnsExist.Log.ColumnExists", (String[])new String[]{realColumnname, realTablename}));
                            }
                            ++nrexistcolums;
                            continue;
                        }
                        this.logError(BaseMessages.getString(PKG, (String)"ActionColumnsExist.Log.ColumnNotExists", (String[])new String[]{realColumnname, realTablename}));
                        ++nrnotexistcolums;
                    }
                }
                this.logError(BaseMessages.getString(PKG, (String)"ActionColumnsExist.Log.TableNotExists", (String[])new String[]{realTablename}));
            }
            catch (HopDatabaseException dbe) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionColumnsExist.Error.UnexpectedError", (String[])new String[]{dbe.getMessage()}));
            }
            finally {
                if (db != null) {
                    try {
                        db.disconnect();
                    }
                    catch (Exception exception) {}
                }
            }
        } else {
            this.logError(BaseMessages.getString(PKG, (String)"ActionColumnsExist.Error.NoDbConnection", (String[])new String[0]));
        }
        result.setEntryNr((long)nrnotexistcolums);
        result.setNrLinesWritten((long)nrexistcolums);
        if (nrexistcolums == this.arguments.length) {
            result.setNrErrors(0L);
            result.setResult(true);
        }
        return result;
    }

    Database getNewDatabaseFromMeta() {
        return new Database((ILoggingObject)this, (IVariables)this, this.connection);
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        return new DatabaseMeta[]{this.connection};
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (this.connection != null) {
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(this.connection.getHostname(), ResourceEntry.ResourceType.SERVER));
            reference.getEntries().add(new ResourceEntry(this.connection.getDatabaseName(), ResourceEntry.ResourceType.DATABASENAME));
            references.add(reference);
        }
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "tablename", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "columnname", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
    }
}

